/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import net.querz.mcaselector.io.Job;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.util.progress.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ProcessDataJob
extends Job {
    private static final Logger LOGGER = LogManager.getLogger(ProcessDataJob.class);
    protected Consumer<Throwable> errorHandler;

    public ProcessDataJob(RegionDirectories dirs, int priority) {
        super(dirs, priority);
    }

    public byte[] loadPoi() {
        return this.load(this.getRegionDirectories().getPoi());
    }

    public byte[] loadEntities() {
        return this.load(this.getRegionDirectories().getEntities());
    }

    public byte[] loadRegion() {
        return this.load(this.getRegionDirectories().getRegion());
    }

    public byte[] loadPoiHeader() {
        return this.load(this.getRegionDirectories().getPoi(), 8192);
    }

    public byte[] loadEntitiesHeader() {
        return this.load(this.getRegionDirectories().getEntities(), 8192);
    }

    public byte[] loadRegionHeader() {
        return this.load(this.getRegionDirectories().getRegion(), 8192);
    }

    protected byte[] load(File file) {
        if (file == null) {
            return null;
        }
        long length = file.length();
        if (length > 0L) {
            return this.load(file, (int)length);
        }
        return null;
    }

    protected byte[] load(File file, int length) {
        int read;
        if (file == null || !file.exists() || file.length() < (long)length) {
            return null;
        }
        Timer t = new Timer();
        byte[] data = new byte[length];
        try (InputStream is = Files.newInputStream(file.toPath(), StandardOpenOption.READ);){
            read = is.read(data);
        }
        catch (IOException ex) {
            LOGGER.warn("failed to read data from {}", (Object)file, (Object)ex);
            return null;
        }
        LOGGER.debug("read {} bytes from {} in {}", (Object)read, (Object)file.getAbsolutePath(), (Object)t);
        return data;
    }

    @Override
    public void run() {
        block3: {
            try {
                if (this.execute()) {
                    this.done();
                }
            }
            catch (Throwable t) {
                LOGGER.error("unhandled exception in ProcessDataJob", t);
                if (this.errorHandler == null) break block3;
                this.errorHandler.accept(t);
            }
        }
    }

    public abstract boolean execute();
}

