/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.function.Consumer;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.job.SaveDataJob;
import net.querz.mcaselector.io.mca.Region;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import net.querz.mcaselector.util.progress.Timer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SelectionDeleter {
    private static final Logger LOGGER = LogManager.getLogger(SelectionDeleter.class);

    private SelectionDeleter() {
    }

    public static void deleteSelection(Selection selection, Progress progressChannel) {
        if (selection.isEmpty()) {
            progressChannel.done("no selection");
            return;
        }
        JobHandler.clearQueues();
        progressChannel.setMessage("preparing");
        Selection trueSelection = selection.getTrueSelection(ConfigProvider.WORLD.getWorldDirs());
        progressChannel.setMax(trueSelection.size());
        Point2i first = trueSelection.one();
        progressChannel.updateProgress(FileHelper.createMCAFileName(first), 0);
        Consumer<Throwable> errorHandler = t -> progressChannel.incrementProgress("error");
        for (Long2ObjectMap.Entry<ChunkSet> entry : trueSelection) {
            MCADeleteSelectionProcessJob job = new MCADeleteSelectionProcessJob(FileHelper.createRegionDirectories(new Point2i(entry.getLongKey())), (ChunkSet)entry.getValue(), progressChannel);
            job.errorHandler = errorHandler;
            JobHandler.addJob(job);
        }
    }

    private static class MCADeleteSelectionProcessJob
    extends ProcessDataJob {
        private final Progress progressChannel;
        private final ChunkSet selection;

        private MCADeleteSelectionProcessJob(RegionDirectories dirs, ChunkSet selection, Progress progressChannel) {
            super(dirs, 20000000);
            this.selection = selection;
            this.progressChannel = progressChannel;
        }

        @Override
        public boolean execute() {
            if (this.selection == null) {
                if (this.getRegionDirectories().getRegion().delete()) {
                    LOGGER.debug("deleted file {}", (Object)this.getRegionDirectories().getRegion());
                } else {
                    LOGGER.warn("failed to delete file {}", (Object)this.getRegionDirectories().getRegion());
                }
                if (this.getRegionDirectories().getPoi().delete()) {
                    LOGGER.debug("deleted file {}", (Object)this.getRegionDirectories().getPoi());
                } else {
                    LOGGER.warn("failed to delete file {}", (Object)this.getRegionDirectories().getPoi());
                }
                if (this.getRegionDirectories().getEntities().delete()) {
                    LOGGER.debug("deleted file {}", (Object)this.getRegionDirectories().getEntities());
                } else {
                    LOGGER.warn("failed to delete file {}", (Object)this.getRegionDirectories().getEntities());
                }
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
            try {
                Region region = Region.loadRegionHeaders(this.getRegionDirectories());
                region.deleteChunks(this.selection);
                MCADeleteSelectionSaveJob job = new MCADeleteSelectionSaveJob(this.getRegionDirectories(), region, this.progressChannel);
                job.errorHandler = this.errorHandler;
                JobHandler.executeSaveData(job);
                return false;
            }
            catch (Exception ex) {
                this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
                LOGGER.warn("error deleting chunk indices in {}", (Object)this.getRegionDirectories().getLocationAsFileName());
                return true;
            }
        }
    }

    private static class MCADeleteSelectionSaveJob
    extends SaveDataJob<Region> {
        private final Progress progressChannel;

        private MCADeleteSelectionSaveJob(RegionDirectories dirs, Region region, Progress progressChannel) {
            super(dirs, region);
            this.progressChannel = progressChannel;
        }

        @Override
        public void execute() {
            Timer t = new Timer();
            try {
                ((Region)this.getData()).deFragment();
            }
            catch (Exception ex) {
                LOGGER.warn("failed to delete selected chunks from {}", (Object)this.getRegionDirectories().getLocationAsFileName(), (Object)ex);
            }
            this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
            LOGGER.debug("took {} to save data for {}", (Object)t, (Object)this.getRegionDirectories().getLocationAsFileName());
        }
    }
}

