/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.SelectionData;
import net.querz.mcaselector.tile.OverlayPool;
import net.querz.mcaselector.tile.TileImage;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SelectionImageExporter {
    private static final Logger LOGGER = LogManager.getLogger(SelectionImageExporter.class);

    private SelectionImageExporter() {
    }

    public static int[] exportSelectionImage(SelectionData data, OverlayPool overlayPool, Progress progressChannel) {
        JobHandler.clearQueues();
        progressChannel.setMax(data.size());
        progressChannel.updateProgress(FileHelper.createMCAFileName(data.getSelection().one()), 0);
        LOGGER.debug("creating image generation jobs for image: {}", (Object)data);
        int[] pixels = new int[(int)(data.getWidth() * 16L * data.getHeight() * 16L)];
        Consumer<Throwable> errorHandler = t -> progressChannel.incrementProgress("error");
        for (Long2ObjectMap.Entry<ChunkSet> entry : data.getSelection()) {
            ExportSelectionImageProcessJob job = new ExportSelectionImageProcessJob(new Point2i(entry.getLongKey()), (ChunkSet)entry.getValue(), data, pixels, overlayPool, progressChannel);
            job.errorHandler = errorHandler;
            JobHandler.addJob(job);
        }
        return pixels;
    }

    private static void iterateChunks(ChunkSet chunks, Point2i region, Consumer<Point2i> chunkConsumer) {
        if (chunks == null) {
            Point2i regionChunk = region.regionToChunk();
            for (int x = regionChunk.getX(); x < regionChunk.getX() + 32; ++x) {
                for (int z = regionChunk.getZ(); z < regionChunk.getZ() + 32; ++z) {
                    chunkConsumer.accept(new Point2i(x, z));
                }
            }
        } else {
            Point2i regionChunk = region.regionToChunk();
            chunks.forEach(chunk -> chunkConsumer.accept(regionChunk.add(new Point2i(chunk))));
        }
    }

    private static class ExportSelectionImageProcessJob
    extends ProcessDataJob {
        private final int[] pixels;
        private final ChunkSet chunks;
        private final SelectionData data;
        private final Progress progressChannel;
        private final OverlayPool overlayPool;

        public ExportSelectionImageProcessJob(Point2i region, ChunkSet chunks, SelectionData data, int[] pixels, OverlayPool overlayPool, Progress progressChannel) {
            super(new RegionDirectories(region, null, null, null), 20000000);
            this.pixels = pixels;
            this.chunks = chunks;
            this.data = data;
            this.progressChannel = progressChannel;
            this.overlayPool = overlayPool;
        }

        @Override
        public boolean execute() {
            PixelReader pixelReader;
            javafx.scene.image.Image image = null;
            File cacheImage = FileHelper.createPNGFilePath(ConfigProvider.WORLD.getCacheDir(), 1, this.getRegionDirectories().getLocation());
            File regionFile = FileHelper.createRegionMCAFilePath(this.getRegionDirectories().getLocation());
            RegionMCAFile mcaFile = null;
            if (cacheImage.exists()) {
                image = new javafx.scene.image.Image(cacheImage.toURI().toString(), false);
            } else if (regionFile.exists()) {
                mcaFile = new RegionMCAFile(regionFile);
                try {
                    mcaFile.load(true);
                }
                catch (IOException ex) {
                    this.progressChannel.incrementProgress(regionFile.getName());
                    return true;
                }
                image = TileImage.generateImage(mcaFile, 1);
            }
            if (image == null) {
                this.progressChannel.incrementProgress(regionFile.getName());
                return true;
            }
            javafx.scene.image.Image overlay = null;
            if (this.overlayPool != null && this.overlayPool.getParser() != null) {
                overlay = this.overlayPool.getImage(this.getRegionDirectories().getLocation(), mcaFile, null, null);
                BufferedImage scaled = ImageHelper.scaleImage(SwingFXUtils.fromFXImage((javafx.scene.image.Image)overlay, null), 512.0, ConfigProvider.WORLD.getSmoothOverlays());
                overlay = SwingFXUtils.toFXImage((BufferedImage)scaled, null);
            }
            if (overlay != null) {
                BufferedImage sourceBuf = SwingFXUtils.fromFXImage((javafx.scene.image.Image)image, null);
                Graphics2D graphics2D = sourceBuf.createGraphics();
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                BufferedImage overlayBuf = SwingFXUtils.fromFXImage((javafx.scene.image.Image)overlay, null);
                graphics2D.setComposite(ac);
                graphics2D.drawImage((Image)overlayBuf, 0, 0, null);
                pixelReader = SwingFXUtils.toFXImage((BufferedImage)sourceBuf, null).getPixelReader();
            } else {
                pixelReader = image.getPixelReader();
            }
            SelectionImageExporter.iterateChunks(this.chunks, this.getRegionDirectories().getLocation(), chunk -> {
                Point2i relBlock = chunk.asRelativeChunk().chunkToBlock();
                int[] pixelData = new int[256];
                pixelReader.getPixels(relBlock.getX(), relBlock.getZ(), 16, 16, PixelFormat.getIntArgbPreInstance(), pixelData, 0, 16);
                Point2i blockInSelection = chunk.sub(this.data.getMin()).chunkToBlock();
                for (int cx = 0; cx < 16; ++cx) {
                    for (int cz = 0; cz < 16; ++cz) {
                        int srcIndex = cz * 16 + cx;
                        int dstIndex = (blockInSelection.getZ() + cz) * (int)this.data.getWidth() * 16 + (blockInSelection.getX() + cx);
                        this.pixels[dstIndex] = pixelData[srcIndex];
                    }
                }
            });
            this.progressChannel.incrementProgress(this.getRegionDirectories().getLocationAsFileName());
            return true;
        }
    }
}

