/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.job;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.job.ProcessDataJob;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.io.mca.EntitiesChunk;
import net.querz.mcaselector.io.mca.EntitiesMCAFile;
import net.querz.mcaselector.io.mca.PoiChunk;
import net.querz.mcaselector.io.mca.PoiMCAFile;
import net.querz.mcaselector.io.mca.RegionChunk;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Progress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectionSummer {
    private static final Logger LOGGER = LogManager.getLogger(SelectionSummer.class);

    private SelectionSummer() {
    }

    public static AtomicLong sumSelection(Selection data, Overlay overlay, Progress progressChannel) {
        AtomicLong answer = new AtomicLong();
        answer.set(0L);
        JobHandler.clearQueues();
        data = data.getTrueSelection(ConfigProvider.WORLD.getWorldDirs());
        progressChannel.setMax(data.count());
        progressChannel.updateProgress("0", 0);
        LOGGER.debug("creating counting jobs: {}", (Object)data);
        Consumer<Throwable> errorHandler = t -> {
            answer.set(-1L);
            progressChannel.done("error");
        };
        for (Long2ObjectMap.Entry<ChunkSet> entry : data) {
            SumInSelectionProcessJob job = new SumInSelectionProcessJob(new Point2i(entry.getLongKey()), (ChunkSet)entry.getValue(), answer, overlay, progressChannel);
            job.errorHandler = errorHandler;
            JobHandler.addJob(job);
        }
        return answer;
    }

    private static int getSize(ChunkSet chunks) {
        return chunks != null ? (int)chunks.size() : 1024;
    }

    private static void iterateChunks(ChunkSet chunks, Point2i region, Consumer<Point2i> chunkConsumer) {
        if (chunks == null) {
            Point2i regionChunk = region.regionToChunk();
            for (int x = regionChunk.getX(); x < regionChunk.getX() + 32; ++x) {
                for (int z = regionChunk.getZ(); z < regionChunk.getZ() + 32; ++z) {
                    chunkConsumer.accept(new Point2i(x, z));
                }
            }
        } else {
            Point2i regionChunk = region.regionToChunk();
            chunks.forEach(chunk -> chunkConsumer.accept(regionChunk.add(new Point2i(chunk))));
        }
    }

    private static class SumInSelectionProcessJob
    extends ProcessDataJob {
        private final AtomicLong sum;
        private final ChunkSet chunks;
        private final Progress progressChannel;
        private final Overlay parser;

        public SumInSelectionProcessJob(Point2i region, ChunkSet chunks, AtomicLong sum, Overlay parser, Progress progressChannel) {
            super(new RegionDirectories(region, null, null, null), 20000000);
            this.sum = sum;
            this.chunks = chunks;
            this.progressChannel = progressChannel;
            this.parser = parser;
        }

        @Override
        public boolean execute() {
            File regionFile = FileHelper.createRegionMCAFilePath(this.getRegionDirectories().getLocation());
            File poiFile = FileHelper.createPoiMCAFilePath(this.getRegionDirectories().getLocation());
            File entitiesFile = FileHelper.createEntitiesMCAFilePath(this.getRegionDirectories().getLocation());
            if (!(regionFile.exists() || poiFile.exists() || entitiesFile.exists())) {
                this.progressChannel.incrementProgress(String.valueOf(this.sum.get()), SelectionSummer.getSize(this.chunks));
                return true;
            }
            RegionMCAFile regionMCAFile = null;
            if (regionFile.exists()) {
                regionMCAFile = new RegionMCAFile(regionFile);
                try {
                    regionMCAFile.load(false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            PoiMCAFile poiMCAFile = null;
            if (poiFile.exists()) {
                poiMCAFile = new PoiMCAFile(poiFile);
                try {
                    poiMCAFile.load(false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            EntitiesMCAFile entitiesMCAFile = null;
            if (entitiesFile.exists()) {
                entitiesMCAFile = new EntitiesMCAFile(entitiesFile);
                try {
                    entitiesMCAFile.load(false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            RegionMCAFile finalRegionMCAFile = regionMCAFile;
            PoiMCAFile finalPoiMCAFile = poiMCAFile;
            EntitiesMCAFile finalEntitiesMCAFile = entitiesMCAFile;
            SelectionSummer.iterateChunks(this.chunks, this.getRegionDirectories().getLocation(), chunk -> {
                int chunkValue;
                if (this.progressChannel.taskCancelled()) {
                    return;
                }
                RegionChunk regionChunk = finalRegionMCAFile != null ? (RegionChunk)finalRegionMCAFile.getChunkAt((Point2i)chunk) : null;
                PoiChunk poiChunk = finalPoiMCAFile != null ? (PoiChunk)finalPoiMCAFile.getChunkAt((Point2i)chunk) : null;
                EntitiesChunk entitiesChunk = finalEntitiesMCAFile != null ? (EntitiesChunk)finalEntitiesMCAFile.getChunkAt((Point2i)chunk) : null;
                try {
                    chunkValue = new ChunkData(regionChunk, poiChunk, entitiesChunk, true).parseData(this.parser);
                }
                catch (Exception e) {
                    LOGGER.warn(e);
                    chunkValue = 0;
                }
                long current = this.sum.addAndGet(chunkValue);
                if (current < 0L) {
                    throw new ArithmeticException("counter overflow");
                }
                this.progressChannel.incrementProgress(String.valueOf(current));
            });
            return true;
        }
    }
}

