/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.mca;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.Chunk;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MCAFile<T extends Chunk> {
    private static final Logger LOGGER = LogManager.getLogger(MCAFile.class);
    protected Point2i location;
    protected File file;
    protected int[] timestamps;
    protected T[] chunks;
    private transient int[] offsets;
    private transient byte[] sectors;
    protected Function<Point2i, T> chunkConstructor;

    public MCAFile(File file, Function<Point2i, T> chunkConstructor) {
        Point2i location = FileHelper.parseMCAFileName(file);
        if (location == null) {
            throw new IllegalArgumentException("failed to parse region file name from " + String.valueOf(file));
        }
        this.location = location;
        this.file = file;
        this.timestamps = new int[1024];
        this.chunkConstructor = chunkConstructor;
    }

    protected MCAFile(Point2i location) {
        this.location = location;
    }

    public boolean save() throws IOException {
        return this.save(this.file);
    }

    public boolean save(File dest) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(dest, "rw");){
            boolean bl = this.save(raf);
            return bl;
        }
    }

    public boolean saveWithTempFile() throws IOException {
        return this.saveWithTempFile(this.file);
    }

    public boolean saveWithTempFile(File dest) throws IOException {
        boolean result;
        File tempFile = File.createTempFile(dest.getName(), null, null);
        try (RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");){
            result = this.save(raf);
        }
        if (!result) {
            if (dest.exists()) {
                if (dest.delete()) {
                    LOGGER.debug("deleted empty region file {}", (Object)dest);
                } else {
                    LOGGER.warn("failed to delete empty region file {}", (Object)dest);
                }
            }
            if (!tempFile.delete()) {
                LOGGER.warn("failed to delete temp file {}", (Object)tempFile);
            }
        } else {
            Files.move(tempFile.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return result;
    }

    public boolean save(RandomAccessFile raf) throws IOException {
        int globalOffset = 2;
        int lastWritten = 0;
        raf.seek(0L);
        for (int i = 0; i < 1024; ++i) {
            raf.seek((long)globalOffset * 4096L);
            T chunk = this.chunks[i];
            if (chunk == null || ((Chunk)chunk).isEmpty()) continue;
            int sectors = (lastWritten >> 12) + ((lastWritten = ((Chunk)chunk).save(raf)) % 4096 == 0 ? 0 : 1);
            raf.seek(i * 4);
            raf.write(globalOffset >>> 16);
            raf.write(globalOffset >> 8 & 0xFF);
            raf.write(globalOffset & 0xFF);
            raf.write(sectors);
            raf.seek(4096 + i * 4);
            raf.writeInt(((Chunk)chunk).getTimestamp());
            globalOffset += sectors;
        }
        if (lastWritten % 4096 != 0) {
            raf.seek((long)globalOffset * 4096L - 1L);
            raf.write(0);
        }
        return globalOffset != 2;
    }

    public void deFragment() throws IOException {
        this.deFragment(this.file);
    }

    public void deFragment(File dest) throws IOException {
        File tmpFile = File.createTempFile(this.file.getName(), null, null);
        int globalOffset = 2;
        int skippedChunks = 0;
        try (RandomAccessFile rafTmp = new RandomAccessFile(tmpFile, "rw");
             RandomAccessFile source = new RandomAccessFile(this.file, "r");){
            for (int i = 0; i < this.offsets.length; ++i) {
                if (this.offsets[i] == 0 || this.sectors[i] == 0) {
                    ++skippedChunks;
                    continue;
                }
                int sectors = this.sectors[i] & 0xFF;
                rafTmp.seek((long)i * 4L);
                rafTmp.writeByte(globalOffset >>> 16);
                rafTmp.writeByte(globalOffset >> 8 & 0xFF);
                rafTmp.writeByte(globalOffset & 0xFF);
                rafTmp.writeByte(sectors);
                rafTmp.seek(4096L + (long)i * 4L);
                rafTmp.writeInt(this.timestamps[i]);
                source.seek((long)this.offsets[i] * 4096L);
                rafTmp.seek((long)globalOffset * 4096L);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(source.getFD()), sectors * 4096));
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(rafTmp.getFD()), sectors * 4096));
                byte[] data = new byte[sectors * 4096];
                dis.read(data);
                dos.write(data);
                this.offsets[i] = globalOffset;
                globalOffset += sectors;
            }
        }
        if (skippedChunks == 1024) {
            LOGGER.debug("all chunks in {} deleted, removing entire file", (Object)this.file.getAbsolutePath());
            if (tmpFile.exists() && !tmpFile.delete()) {
                LOGGER.warn("failed to delete tmpFile {} after all chunks were deleted", (Object)tmpFile.getAbsolutePath());
            }
            if (dest.getCanonicalPath().equals(this.file.getCanonicalPath()) && !dest.delete()) {
                LOGGER.warn("failed to delete file {} after all chunks were deleted", (Object)dest.getAbsolutePath());
            }
        } else {
            LOGGER.debug("moving temp file {} to {}", (Object)tmpFile.getAbsolutePath(), (Object)dest.getAbsolutePath());
            Files.move(tmpFile.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void load(boolean raw) throws IOException {
        try (FileChannel fc = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);){
            if (fc.size() < 8196L) {
                return;
            }
            ByteBuffer buf = ByteBuffer.allocate((int)fc.size());
            fc.read(buf);
            this.loadHeader(buf);
            Point2i origin = this.location.regionToChunk();
            for (short i = 0; i < 1024; i = (short)((short)(i + 1))) {
                if (this.offsets[i] == 0) {
                    this.chunks[i] = null;
                    continue;
                }
                buf.position(this.offsets[i] * 4096);
                Point2i chunkLocation = origin.add(new Point2i(i));
                try {
                    this.chunks[i] = (Chunk)this.chunkConstructor.apply(chunkLocation);
                    ((Chunk)this.chunks[i]).setTimestamp(this.timestamps[i]);
                    ((Chunk)this.chunks[i]).load(buf, raw);
                    continue;
                }
                catch (Exception ex) {
                    this.chunks[i] = null;
                    LOGGER.warn("failed to load chunk at {}", (Object)chunkLocation, (Object)ex);
                }
            }
        }
    }

    public void loadHeader() throws IOException {
        try (FileChannel fc = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);){
            ByteBuffer buf = ByteBuffer.allocate(8192);
            fc.read(buf);
            this.loadHeader(buf);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IOException(ex);
        }
    }

    private void loadHeader(ByteBuffer buf) throws IOException {
        this.offsets = new int[1024];
        this.sectors = new byte[1024];
        try {
            int i;
            buf.position(0);
            for (i = 0; i < this.offsets.length; ++i) {
                int offset = buf.get() << 16;
                this.offsets[i] = (offset |= (buf.get() & 0xFF) << 8) | buf.get() & 0xFF;
                this.sectors[i] = buf.get();
            }
            this.timestamps = new int[1024];
            for (i = 0; i < 1024; ++i) {
                this.timestamps[i] = buf.getInt();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IOException(ex);
        }
    }

    public T loadSingleChunk(Point2i chunk) throws IOException {
        if (this.file.length() < 8192L) {
            return null;
        }
        try (FileChannel fc = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);){
            Point2i rel;
            ByteBuffer buf = ByteBuffer.allocate((int)fc.size());
            fc.read(buf);
            Point2i region = FileHelper.parseMCAFileName(this.file);
            if (region == null) {
                throw new IOException("invalid region file name " + String.valueOf(this.file));
            }
            rel.setX((rel = chunk.mod(32)).getX() < 0 ? 32 + rel.getX() : rel.getX());
            rel.setZ(rel.getZ() < 0 ? 32 + rel.getZ() : rel.getZ());
            int headerIndex = rel.getZ() * 32 + rel.getX();
            int headerOffset = headerIndex * 4;
            buf.position(headerOffset);
            int offset = buf.get() << 16;
            offset |= (buf.get() & 0xFF) << 8;
            offset |= buf.get() & 0xFF;
            Point2i absoluteChunkLocation = region.regionToChunk().add(rel);
            buf.position(headerOffset + 4096);
            int timestamp = buf.getInt();
            Chunk chunkData = (Chunk)this.chunkConstructor.apply(absoluteChunkLocation);
            chunkData.setTimestamp(timestamp);
            if (offset > 0) {
                buf.position(offset * 4096);
                chunkData.load(buf, false);
            }
            Chunk chunk2 = chunkData;
            return (T)chunk2;
        }
    }

    public void loadBorderChunks() throws IOException {
        try (FileChannel fc = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);){
            ByteBuffer buf = ByteBuffer.allocate((int)fc.size());
            fc.read(buf);
            this.loadHeader(buf);
            for (int x = 0; x < 32; ++x) {
                this.loadChunk(buf, x);
                this.loadChunk(buf, x + 992);
            }
            for (int z = 1; z < 31; ++z) {
                this.loadChunk(buf, z * 32);
                this.loadChunk(buf, 31 + z * 32);
            }
        }
    }

    private void loadChunk(ByteBuffer buf, int index) throws IOException {
        try {
            if (this.offsets[index] == 0) {
                this.chunks[index] = null;
                return;
            }
            buf.position(this.offsets[index] * 4096);
            Point2i origin = this.location.regionToChunk();
            Point2i chunkLocation = origin.add(new Point2i(index));
            try {
                this.chunks[index] = (Chunk)this.chunkConstructor.apply(chunkLocation);
                ((Chunk)this.chunks[index]).setTimestamp(this.timestamps[index]);
                ((Chunk)this.chunks[index]).load(buf, false);
            }
            catch (Exception ex) {
                this.chunks[index] = null;
                LOGGER.warn("failed to load chunk at {}", (Object)chunkLocation, (Object)ex);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IOException(ex);
        }
    }

    public void saveSingleChunk(Point2i location, T chunk) throws IOException {
        if (this.file.exists() && this.file.length() > 0L) {
            this.load(false);
        } else if (chunk == null || ((Chunk)chunk).isEmpty()) {
            LOGGER.debug("nothing to save and no existing file found for chunk {}", (Object)location);
            return;
        }
        short index = location.asChunkIndex();
        this.setChunk(index, chunk);
        if (chunk != null) {
            this.setTimestamp(index, ((Chunk)chunk).getTimestamp());
        }
        this.saveWithTempFile();
    }

    public void deleteChunks(ChunkSet selection) {
        IntIterator intIterator = selection.iterator();
        while (intIterator.hasNext()) {
            int chunk = (Integer)intIterator.next();
            this.timestamps[chunk] = 0;
            this.chunks[chunk] = null;
            this.sectors[chunk] = 0;
            this.offsets[chunk] = 0;
        }
    }

    public abstract void mergeChunksInto(MCAFile<T> var1, Point3i var2, boolean var3, ChunkSet var4, ChunkSet var5, List<Range> var6);

    protected void mergeChunksInto(MCAFile<T> destination, Point3i offset, boolean overwrite, ChunkSet sourceChunks, ChunkSet targetChunks, List<Range> ranges, BiFunction<Point2i, Integer, T> chunkCreator) {
        Point2i relativeOffset = this.location.regionToChunk().add(offset.toPoint2i()).sub(destination.location.regionToChunk());
        int startX = relativeOffset.getX() > 0 ? 0 : 32 - (32 + relativeOffset.getX());
        int limitX = relativeOffset.getX() > 0 ? 32 - relativeOffset.getX() : 32;
        int startZ = relativeOffset.getZ() > 0 ? 0 : 32 - (32 + relativeOffset.getZ());
        int limitZ = relativeOffset.getZ() > 0 ? 32 - relativeOffset.getZ() : 32;
        for (int x = startX; x < limitX; ++x) {
            for (int z = startZ; z < limitZ; ++z) {
                Point2i destChunk;
                Object destinationChunk;
                T sourceChunk;
                block11: {
                    int sourceIndex = z * 32 + x;
                    int destX = relativeOffset.getX() > 0 ? relativeOffset.getX() + x : x - startX;
                    int destZ = relativeOffset.getZ() > 0 ? relativeOffset.getZ() + z : z - startZ;
                    int destIndex = destZ * 32 + destX;
                    sourceChunk = this.chunks[sourceIndex];
                    destinationChunk = destination.chunks[destIndex];
                    if (!overwrite && destinationChunk != null && !((Chunk)destinationChunk).isEmpty() || sourceChunk == null || ((Chunk)sourceChunk).isEmpty() || sourceChunks != null && !sourceChunks.get(sourceIndex)) continue;
                    destChunk = destination.location.regionToChunk().add(destX, destZ);
                    if (targetChunks != null && !targetChunks.get(destIndex)) continue;
                    try {
                        if (!((Chunk)sourceChunk).relocate(offset.sectionToBlock())) {
                        }
                        break block11;
                    }
                    catch (Exception ex) {
                        Point2i srcChunk = this.location.regionToChunk().add(x, z);
                        LOGGER.warn("failed to relocate chunk {} to {}", (Object)srcChunk, (Object)destChunk, (Object)ex);
                    }
                    continue;
                }
                if (ranges != null) {
                    int sourceVersion = ((Chunk)sourceChunk).getData().getIntOrDefault("DataVersion", 0);
                    if (sourceVersion == 0) continue;
                    if (destinationChunk == null || ((Chunk)destinationChunk).isEmpty()) {
                        destinationChunk = (Chunk)chunkCreator.apply(destChunk, sourceVersion);
                        destination.chunks[destIndex] = destinationChunk;
                    } else {
                        int destinationVersion = ((Chunk)destinationChunk).getData().getIntOrDefault("DataVersion", 0);
                        if (sourceVersion != destinationVersion) {
                            Point2i srcChunk = this.location.regionToChunk().add(x, z);
                            LOGGER.warn("failed to merge chunk at {} into chunk at {} because their DataVersion does not match ({} != {})", (Object)srcChunk, (Object)destChunk, (Object)sourceVersion, (Object)destinationVersion);
                        }
                    }
                    try {
                        ((Chunk)sourceChunk).merge(((Chunk)destinationChunk).getData(), ranges, offset.getY());
                    }
                    catch (Exception ex) {
                        Point2i srcChunk = this.location.regionToChunk().add(x, z);
                        LOGGER.warn("failed to merge chunk {} into {}", (Object)srcChunk, (Object)destChunk, (Object)ex);
                    }
                    continue;
                }
                destination.chunks[destIndex] = sourceChunk;
            }
        }
    }

    private int getChunkIndex(Point2i chunkCoordinate) {
        return (chunkCoordinate.getX() & 0x1F) + (chunkCoordinate.getZ() & 0x1F) * 32;
    }

    public Point2i getLocation() {
        return this.location;
    }

    public void setFile(File file) {
        Point2i location = FileHelper.parseMCAFileName(file);
        if (!this.location.equals(location)) {
            throw new IllegalArgumentException("invalid file name change for region file from " + String.valueOf(this.file) + " to " + String.valueOf(file));
        }
        this.location = location;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setTimestamp(int index, int timestamp) {
        this.timestamps[index] = timestamp;
    }

    public int getTimestamp(int index) {
        return this.timestamps[index];
    }

    public T getChunkAt(Point2i location) {
        return this.chunks[this.getChunkIndex(location)];
    }

    public T getChunk(int index) {
        return this.chunks[index];
    }

    public boolean hasChunkIndex(Point2i location) {
        return this.offsets[this.getChunkIndex(location)] != 0;
    }

    public void setChunkAt(Point2i location, T chunk) {
        this.chunks[this.getChunkIndex((Point2i)location)] = chunk;
    }

    public void setChunk(int index, T chunk) {
        this.chunks[index] = chunk;
    }

    public void deleteChunk(int index) {
        this.chunks[index] = null;
        this.timestamps[index] = 0;
        this.offsets[index] = 0;
        this.sectors[index] = 0;
    }

    public boolean isEmpty() {
        for (T chunk : this.chunks) {
            if (chunk == null) continue;
            return false;
        }
        return true;
    }

    protected <V extends MCAFile<T>> V clone(Function<File, V> mcaFileConstructor) {
        MCAFile clone = (MCAFile)mcaFileConstructor.apply(this.file);
        for (int i = 0; i < this.chunks.length; ++i) {
            if (this.chunks[i] == null) continue;
            clone.chunks[i] = ((Chunk)this.chunks[i]).clone(clone.chunkConstructor);
        }
        clone.timestamps = (int[])this.timestamps.clone();
        return (V)clone;
    }
}

