/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.io.mca;

import java.io.File;
import java.util.List;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.io.mca.CompressionType;
import net.querz.mcaselector.io.mca.MCAFile;
import net.querz.mcaselector.io.mca.RegionChunk;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.ChunkRenderer;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.CompoundTag;

public class RegionMCAFile
extends MCAFile<RegionChunk>
implements Cloneable {
    public RegionMCAFile(File file) {
        super(file, RegionChunk::new);
        this.chunks = new RegionChunk[1024];
    }

    private RegionMCAFile(Point2i location) {
        super(location);
    }

    static RegionChunk newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
        CompoundTag root = VersionHandler.getImpl(dataVersion, ChunkFilter.Merge.class).newEmptyChunk(absoluteLocation, dataVersion);
        RegionChunk chunk = new RegionChunk(absoluteLocation);
        chunk.data = root;
        chunk.compressionType = CompressionType.ZLIB;
        return chunk;
    }

    @Override
    public void mergeChunksInto(MCAFile<RegionChunk> destination, Point3i offset, boolean overwrite, ChunkSet sourceChunks, ChunkSet targetChunks, List<Range> ranges) {
        this.mergeChunksInto(destination, offset, overwrite, sourceChunks, targetChunks, ranges, RegionMCAFile::newEmptyChunk);
        if (ranges != null || offset.getY() != 0) {
            Point2i relativeOffset = this.location.regionToChunk().add(offset.toPoint2i()).sub(destination.location.regionToChunk());
            int startX = relativeOffset.getX() > 0 ? 0 : 32 - (32 + relativeOffset.getX());
            int limitX = relativeOffset.getX() > 0 ? 32 - relativeOffset.getX() : 32;
            int startZ = relativeOffset.getZ() > 0 ? 0 : 32 - (32 + relativeOffset.getZ());
            int limitZ = relativeOffset.getZ() > 0 ? 32 - relativeOffset.getZ() : 32;
            for (int x = startX; x < limitX; ++x) {
                for (int z = startZ; z < limitZ; ++z) {
                    RegionChunk destinationChunk;
                    int sourceIndex = z * 32 + x;
                    if (sourceChunks != null && !sourceChunks.get(sourceIndex)) continue;
                    int destX = relativeOffset.getX() > 0 ? relativeOffset.getX() + x : x - startX;
                    int destZ = relativeOffset.getZ() > 0 ? relativeOffset.getZ() + z : z - startZ;
                    int destIndex = destZ * 32 + destX;
                    if (targetChunks != null && !targetChunks.get(destIndex) || (destinationChunk = ((RegionChunk[])destination.chunks)[destIndex]) == null || destinationChunk.isEmpty()) continue;
                    ChunkData data = new ChunkData(destinationChunk, null, null, false);
                    ChunkFilter.Heightmap heightmap = VersionHandler.getImpl(data, ChunkFilter.Heightmap.class);
                    heightmap.worldSurface(data);
                    heightmap.oceanFloor(data);
                    heightmap.motionBlocking(data);
                    heightmap.motionBlockingNoLeaves(data);
                }
            }
        }
    }

    public RegionMCAFile minimizeForRendering() {
        RegionMCAFile min = new RegionMCAFile(this.getLocation());
        min.setFile(this.getFile());
        min.chunks = new RegionChunk[1024];
        for (int index = 0; index < 1024; ++index) {
            RegionChunk chunk = (RegionChunk)this.getChunk(index);
            if (chunk == null || chunk.data == null) continue;
            try {
                CompoundTag minData = VersionHandler.getImpl(Helper.getDataVersion(chunk.data), ChunkRenderer.class).minimizeChunk(chunk.data);
                RegionChunk minChunk = new RegionChunk(chunk.absoluteLocation.clone());
                minChunk.data = minData;
                ((RegionChunk[])min.chunks)[index] = minChunk;
                continue;
            }
            catch (Exception ex) {
                ((RegionChunk[])min.chunks)[index] = chunk;
            }
        }
        return min;
    }

    public RegionMCAFile clone() {
        return this.clone(RegionMCAFile::new);
    }
}

