/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.overlay;

import java.util.function.Supplier;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.overlay.overlays.AverageHeightOverlay;
import net.querz.mcaselector.overlay.overlays.BlockAmountOverlay;
import net.querz.mcaselector.overlay.overlays.DataVersionOverlay;
import net.querz.mcaselector.overlay.overlays.EntityAmountOverlay;
import net.querz.mcaselector.overlay.overlays.InhabitedTimeOverlay;
import net.querz.mcaselector.overlay.overlays.LastUpdateOverlay;
import net.querz.mcaselector.overlay.overlays.PathOverlay;
import net.querz.mcaselector.overlay.overlays.ScriptOverlay;
import net.querz.mcaselector.overlay.overlays.TileEntityAmountOverlay;
import net.querz.mcaselector.overlay.overlays.TimestampOverlay;

public enum OverlayType {
    INHABITED_TIME("InhabitedTime", InhabitedTimeOverlay::new),
    TIMESTAMP("Timestamp", TimestampOverlay::new),
    LAST_UPDATE("LastUpdate", LastUpdateOverlay::new),
    ENTITY_AMOUNT("#Entities", EntityAmountOverlay::new),
    TILE_ENTITY_AMOUNT("#TileEntities", TileEntityAmountOverlay::new),
    DATA_VERSION("DataVersion", DataVersionOverlay::new),
    AVERAGE_HEIGHT("AverageHeight", AverageHeightOverlay::new),
    BLOCK_AMOUNT("#Blocks", BlockAmountOverlay::new),
    PATH("Path", PathOverlay::new),
    SCRIPT("Script", ScriptOverlay::new);

    private final String name;
    private final Supplier<Overlay> supplier;

    private OverlayType(String name, Supplier<Overlay> supplier) {
        this.name = name;
        this.supplier = supplier;
    }

    public Overlay instance() {
        return this.supplier.get();
    }

    public String toString() {
        return this.name;
    }

    public static OverlayType getByName(String name) {
        for (OverlayType t : OverlayType.values()) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return null;
    }
}

