/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.overlay.overlays;

import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.overlay.OverlayType;
import net.querz.mcaselector.text.TextHelper;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.nbt.LongTag;

public class LastUpdateOverlay
extends Overlay {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 0x6666666;
    private String minDuration;
    private String maxDuration;

    public LastUpdateOverlay() {
        super(OverlayType.LAST_UPDATE);
    }

    @Override
    public int parseValue(ChunkData data) {
        LongTag tag = VersionHandler.getImpl(data, ChunkFilter.LastUpdate.class).getLastUpdate(data);
        return tag == null ? 0 : tag.asInt();
    }

    @Override
    public String name() {
        return "LastUpdate";
    }

    @Override
    public String minString() {
        return this.minDuration == null ? super.minString() : this.minDuration;
    }

    @Override
    public String maxString() {
        return this.maxDuration == null ? super.maxString() : this.maxDuration;
    }

    @Override
    public boolean setMin(String raw) {
        this.setRawMin(raw);
        this.minDuration = null;
        if (raw == null || raw.isEmpty()) {
            return this.setMinInt(null);
        }
        try {
            return this.setMinInt(Integer.parseInt(raw));
        }
        catch (NumberFormatException ex) {
            try {
                long duration = TextHelper.parseDuration(raw);
                if (duration > 0x6666666L || duration < 0L) {
                    return this.setMinInt(null);
                }
                boolean res = this.setMinInt((int)(duration * 20L));
                if (res) {
                    this.minDuration = raw;
                }
                return res;
            }
            catch (IllegalArgumentException ex2) {
                return this.setMinInt(null);
            }
        }
    }

    @Override
    public boolean setMax(String raw) {
        this.setRawMax(raw);
        this.maxDuration = null;
        if (raw == null || raw.isEmpty()) {
            return this.setMaxInt(null);
        }
        try {
            return this.setMaxInt(Integer.parseInt(raw));
        }
        catch (NumberFormatException ex) {
            try {
                long duration = TextHelper.parseDuration(raw);
                if (duration > 0x6666666L || duration < 0L) {
                    return this.setMaxInt(null);
                }
                boolean res = this.setMaxInt((int)(duration * 20L));
                if (res) {
                    this.maxDuration = raw;
                }
                return res;
            }
            catch (IllegalArgumentException ex2) {
                return this.setMaxInt(null);
            }
        }
    }
}

