/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.overlay.overlays;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.script.ScriptException;
import net.querz.mcaselector.io.GroovyScriptEngine;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.overlay.AmountOverlay;
import net.querz.mcaselector.overlay.OverlayType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptOverlay
extends AmountOverlay {
    private static final Logger LOGGER = LogManager.getLogger(ScriptOverlay.class);
    private static final String[] empty = new String[0];
    private final GroovyScriptEngine engine = new GroovyScriptEngine();

    public ScriptOverlay() {
        super(OverlayType.SCRIPT);
        this.setMultiValues(empty);
    }

    @Override
    public int parseValue(ChunkData data) {
        try {
            Integer res = (Integer)this.engine.invoke("get", data);
            return res == null ? 0 : res;
        }
        catch (NoSuchMethodException | ScriptException ex) {
            LOGGER.warn("failed to invoke get function in custom overlay script", (Throwable)ex);
            return 0;
        }
    }

    @Override
    public String name() {
        return "Script";
    }

    @Override
    public boolean setMultiValuesString(String raw) {
        if (raw == null || !raw.endsWith(".groovy")) {
            this.setMultiValues(empty);
            return false;
        }
        try {
            String code = Files.readString(Path.of(raw, new String[0]));
            this.engine.eval(code);
            this.setMultiValues(new String[]{raw});
            this.setRawMultiValues(raw);
            return true;
        }
        catch (IOException | IllegalArgumentException | ScriptException e) {
            this.setMultiValues(empty);
            return false;
        }
    }
}

