/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.selection;

import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.shorts.ShortPredicate;
import java.io.Serializable;
import net.querz.mcaselector.util.point.Point2i;

public class ChunkSet
implements IntIterable,
Serializable,
Cloneable {
    long[] words = new long[16];
    short setBits = 0;
    public static final ChunkSet EMPTY_SET = new ChunkSet().immutable();

    public void set(int index) {
        if (!this.get(index)) {
            this.setBits = (short)(this.setBits + 1);
        }
        int n = index >> 6;
        this.words[n] = this.words[n] | 1L << index;
    }

    public void clear(int index) {
        if (this.get(index)) {
            this.setBits = (short)(this.setBits - 1);
        }
        int n = index >> 6;
        this.words[n] = this.words[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear() {
        for (int i = 0; i < 16; ++i) {
            this.words[i] = 0L;
        }
        this.setBits = 0;
    }

    public boolean get(int index) {
        return (this.words[index >> 6] & 1L << index) != 0L;
    }

    public void or(ChunkSet other) {
        for (int i = 0; i < 1024; i = (int)((short)(i + 1))) {
            if (!other.get(i)) continue;
            this.set(i);
        }
    }

    public void otherNotAnd(ChunkSet other) {
        for (int i = 0; i < 1024; i = (int)((short)(i + 1))) {
            if (this.get(i) && !other.get(i)) continue;
            this.clear(i);
        }
    }

    public ChunkSet flip() {
        ChunkSet result = new ChunkSet();
        for (int i = 0; i < 16; ++i) {
            result.words[i] = this.words[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        result.setBits = (short)(1024 - this.setBits);
        return result;
    }

    public ChunkSet clone() {
        ChunkSet clone;
        try {
            clone = (ChunkSet)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        clone.words = (long[])this.words.clone();
        clone.setBits = this.setBits;
        return clone;
    }

    public short size() {
        return this.setBits;
    }

    public boolean isEmpty() {
        return this.setBits == 0;
    }

    public void fill() {
        for (int i = 0; i < 16; ++i) {
            this.words[i] = -1L;
        }
        this.setBits = (short)1024;
    }

    @Override
    public IntIterator iterator() {
        return new ChunkIterator();
    }

    @Override
    public void forEach(IntConsumer action) {
        for (int i = 0; i < 16; ++i) {
            int c;
            if (this.words[i] == 0L) continue;
            int l = c + 64;
            for (c = i << 6; c < l; ++c) {
                if (!this.get(c)) continue;
                action.accept(c);
            }
        }
    }

    public void forEachFrom(short index, IntConsumer action) {
        for (int i = index >> 6; i < 16; ++i) {
            int c;
            if (this.words[i] == 0L) continue;
            int l = c + 64;
            for (c = i << 6; c < l; ++c) {
                if (!this.get(c)) continue;
                action.accept(c);
            }
        }
    }

    public void forEachFromInverse(short index, IntConsumer action) {
        for (int i = index >> 6; i >= 0; --i) {
            if (this.words[i] == 0L) continue;
            int l = i << 6;
            for (int c = l + 64; c >= l; --c) {
                if (!this.get(c)) continue;
                action.accept(c);
            }
        }
    }

    public int getMinX(int max) {
        for (int x = 0; x < max; ++x) {
            for (int z = 0; z < 32; ++z) {
                if (!this.get(z << 5 | x)) continue;
                return x;
            }
        }
        return max;
    }

    public int getMaxX(int min) {
        for (int x = 31; x > min; --x) {
            for (int z = 31; z >= 0; --z) {
                if (!this.get(z << 5 | x)) continue;
                return x;
            }
        }
        return min;
    }

    public int getMinZ(int max) {
        int l = max >> 1;
        for (int i = 0; i <= l; ++i) {
            if (this.words[i] == 0L) continue;
            if ((this.words[i] & 0xFFFFFFFFL) == 0L) {
                return i * 2 + 1;
            }
            return i * 2;
        }
        return max;
    }

    public int getMaxZ(int min) {
        int l = min >> 1;
        for (int i = 15; i >= l; --i) {
            if (this.words[i] == 0L) continue;
            if ((this.words[i] & 0xFFFFFFFF00000000L) == 0L) {
                return i * 2;
            }
            return i * 2 + 1;
        }
        return min;
    }

    public void removeIf(ShortPredicate predicate) {
        short c = 0;
        short l = 64;
        for (int i = 0; i < 16; ++i) {
            if (this.words[i] == 0L) continue;
            while (c < l) {
                if (predicate.test(c)) {
                    this.clear(c);
                }
                c = (short)(c + 1);
            }
            l = (short)(l + 64);
        }
    }

    public ChunkSet immutable() {
        return new ImmutableChunkSet(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("   0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31\n");
        for (int z = 0; z < 32; ++z) {
            sb.append(z);
            sb.append(z > 9 ? "" : " ");
            for (int x = 0; x < 32; ++x) {
                sb.append(" ");
                sb.append(this.get(new Point2i(x, z).asChunkIndex()) ? 1 : 0);
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private class ChunkIterator
    implements IntIterator {
        short index = 0;

        private ChunkIterator() {
        }

        @Override
        public int nextInt() {
            return this.index - 1;
        }

        @Override
        public boolean hasNext() {
            while (this.index < 1024) {
                short s = this.index;
                this.index = (short)(s + 1);
                if (!ChunkSet.this.get(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            while (this.index < 1024) {
                if (ChunkSet.this.get(this.index)) {
                    action.accept(this.index);
                }
                this.index = (short)(this.index + 1);
            }
        }
    }

    private static class ImmutableChunkSet
    extends ChunkSet {
        ImmutableChunkSet(ChunkSet chunkSet) {
            this.words = (long[])chunkSet.words.clone();
            this.setBits = chunkSet.setBits;
        }

        @Override
        public void set(int index) {
            throw new UnsupportedOperationException("cannot modify immutable ChunkSet");
        }

        @Override
        public void clear(int index) {
            throw new UnsupportedOperationException("cannot modify immutable ChunkSet");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("cannot modify immutable ChunkSet");
        }

        @Override
        public void removeIf(ShortPredicate predicate) {
            throw new UnsupportedOperationException("cannot modify immutable ChunkSet");
        }

        @Override
        public void or(ChunkSet other) {
            throw new UnsupportedOperationException("cannot modify immutable ChunkSet");
        }
    }
}

