/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.tile;

import java.awt.Color;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.NamedThreadFactory;
import net.querz.mcaselector.io.db.CacheHandler;
import net.querz.mcaselector.io.job.ParseDataJob;
import net.querz.mcaselector.io.mca.EntitiesMCAFile;
import net.querz.mcaselector.io.mca.PoiMCAFile;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.property.DataProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.iq80.leveldb.DBException;

public class OverlayPool {
    private static final Logger LOGGER = LogManager.getLogger(OverlayPool.class);
    private final TileMap tileMap;
    private final Set<Point2i> noData = new HashSet<Point2i>();
    private final ThreadPoolExecutor overlayCacheLoaders = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("overlayCachePool"));
    private final ThreadPoolExecutor overlayValueLoader = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("overlayValuePool"));
    private Overlay parser;
    private Point2i hoveredRegion;
    private int[] hoveredRegionData;

    public OverlayPool(TileMap tileMap) {
        this.tileMap = tileMap;
    }

    public Overlay getParser() {
        return this.parser;
    }

    public void setParser(Overlay overlay) {
        this.parser = overlay;
        if (overlay != null && overlay.isValid() && overlay.isActive()) {
            this.hoveredRegion = null;
            this.hoveredRegionData = null;
        }
    }

    public void requestImage(Tile tile, Overlay parser) {
        if (parser == null || !parser.isActive() || !parser.isValid()) {
            return;
        }
        if (this.noData.contains(tile.location)) {
            return;
        }
        if (ParseDataJob.isLoading(tile)) {
            return;
        }
        ParseDataJob.setLoading(tile, true);
        Overlay parserClone = parser.clone();
        this.overlayCacheLoaders.execute(() -> {
            int[] data = null;
            try {
                data = CacheHandler.getData(parserClone, tile.location);
            }
            catch (Exception ex) {
                LOGGER.warn("failed to load cached overlay data for region {}", (Object)tile.location, (Object)ex);
            }
            if (data != null) {
                Image overlay = OverlayPool.parseColorGrades(data, parserClone.min(), parserClone.max(), parserClone.getMinHue(), parserClone.getMaxHue());
                if (parserClone.equals(this.parser)) {
                    tile.overlay = overlay;
                    tile.overlayLoaded = true;
                    this.tileMap.draw();
                }
                ParseDataJob.setLoading(tile, false);
            } else {
                JobHandler.executeParseData(new ParseDataJob(tile, FileHelper.createRegionDirectories(tile.location), ConfigProvider.WORLD.getWorldUUID(), (d, u) -> {
                    if (u.equals(ConfigProvider.WORLD.getWorldUUID())) {
                        if (d == null) {
                            this.noData.add(tile.location);
                            tile.overlayLoaded = true;
                            return;
                        }
                        if (parserClone.equals(this.parser)) {
                            this.push(tile.location, (int[])d);
                            tile.overlay = OverlayPool.parseColorGrades(d, parser.min(), parser.max(), parser.getMinHue(), parser.getMaxHue());
                            tile.overlayLoaded = true;
                            this.tileMap.draw();
                        }
                    }
                }, parser, () -> this.tileMap.getTilePriority(tile.location)));
            }
        });
    }

    public Image getImage(Point2i location, RegionMCAFile region, PoiMCAFile poi, EntitiesMCAFile entities) {
        try {
            int[] data = CacheHandler.getData(this.parser, location);
            if (data != null) {
                return OverlayPool.parseColorGrades(data, this.parser.min(), this.parser.max(), this.parser.getMinHue(), this.parser.getMaxHue());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("failed to load cached overlay data for region {}", (Object)location, (Object)ex);
            return null;
        }
        DataProperty image = new DataProperty();
        new ParseDataJob(new Tile(location), ConfigProvider.WORLD.getWorldDirs().makeRegionDirectories(location), ConfigProvider.WORLD.getWorldUUID(), region, poi, entities, (i, u) -> {
            if (i != null) {
                image.set(OverlayPool.parseColorGrades(i, this.parser.min(), this.parser.max(), this.parser.getMinHue(), this.parser.getMaxHue()));
            }
        }, this.parser, null).execute();
        return (Image)image.get();
    }

    private static Image parseColorGrades(int[] data, int min, int max, float minHue, float maxHue) {
        int[] colors = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            colors[i] = OverlayPool.getColorGrade(data[i], min, max, minHue, maxHue);
        }
        WritableImage image = new WritableImage(32, 32);
        image.getPixelWriter().setPixels(0, 0, 32, 32, (PixelFormat)PixelFormat.getIntArgbPreInstance(), colors, 0, 32);
        return image;
    }

    private static int getColorGrade(int value, int min, int max, float minHue, float maxHue) {
        if (value <= min) {
            return Color.HSBtoRGB(minHue, 1.0f, 1.0f);
        }
        if (value >= max) {
            return Color.HSBtoRGB(maxHue, 1.0f, 1.0f);
        }
        float percent = (float)(value - min) / (float)(max - min);
        float hue = minHue + percent * (maxHue - minHue);
        return Color.HSBtoRGB(hue, 1.0f, 1.0f);
    }

    public void push(Point2i location, int[] data) {
        try {
            CacheHandler.setData(this.tileMap.getOverlay(), location, data);
        }
        catch (Exception ex) {
            LOGGER.warn("failed to cache data for region {}", (Object)location, (Object)ex);
        }
    }

    public void switchTo(String dbPath) {
        try {
            CacheHandler.switchTo(dbPath);
            this.hoveredRegion = null;
            this.hoveredRegionData = null;
        }
        catch (IOException ex) {
            LOGGER.warn("failed to switch cache db", (Throwable)ex);
        }
    }

    public void clear(boolean initCache) {
        try {
            CacheHandler.clear(ConfigProvider.WORLD.getCacheDBDir(), initCache);
            this.hoveredRegion = null;
            this.hoveredRegionData = null;
        }
        catch (IOException ex) {
            LOGGER.warn("failed to clear data cache", (Throwable)ex);
        }
        this.noData.clear();
    }

    public void discardData(Point2i region) {
        try {
            CacheHandler.deleteData(region);
            if (region.equals(this.hoveredRegion)) {
                this.hoveredRegion = null;
                this.hoveredRegionData = null;
            }
            LOGGER.debug("removed data for {} from data pool", (Object)region);
        }
        catch (IOException ex) {
            LOGGER.warn("failed to remove data from cache", (Throwable)ex);
        }
        this.noData.remove(region);
    }

    public void getHoveredChunkValue(Point2i chunk, Consumer<Integer> callback) {
        if (this.parser == null) {
            callback.accept(null);
        }
        Point2i region = chunk.chunkToRegion();
        Point2i normalizedChunk = chunk.asRelativeChunk();
        if (region.equals(this.hoveredRegion)) {
            if (this.hoveredRegionData != null) {
                callback.accept(this.hoveredRegionData[normalizedChunk.getZ() * 32 + normalizedChunk.getX()]);
            } else {
                callback.accept(null);
            }
        } else {
            this.overlayValueLoader.getQueue().clear();
            this.overlayValueLoader.execute(() -> {
                try {
                    int[] regionData = CacheHandler.getData(this.parser, region);
                    this.hoveredRegion = region;
                    this.hoveredRegionData = regionData;
                    if (regionData == null) {
                        Platform.runLater(() -> callback.accept(null));
                        return;
                    }
                    Platform.runLater(() -> callback.accept(regionData[normalizedChunk.getZ() * 32 + normalizedChunk.getX()]));
                }
                catch (IOException | DBException ex) {
                    LOGGER.warn("failed to load data for overlay value", (Throwable)ex);
                    Platform.runLater(() -> callback.accept(null));
                }
            });
        }
    }
}

