/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Paint;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.CacheHelper;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ChunkFilterDeleter;
import net.querz.mcaselector.io.job.ChunkFilterExporter;
import net.querz.mcaselector.io.job.ChunkFilterSelector;
import net.querz.mcaselector.io.job.ChunkImporter;
import net.querz.mcaselector.io.job.FieldChanger;
import net.querz.mcaselector.io.job.RegionImageGenerator;
import net.querz.mcaselector.io.job.SelectionDeleter;
import net.querz.mcaselector.io.job.SelectionExporter;
import net.querz.mcaselector.io.job.SelectionImageExporter;
import net.querz.mcaselector.io.job.SelectionSummer;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.io.mca.Region;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.ClipboardSelection;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.selection.SelectionData;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.Color;
import net.querz.mcaselector.ui.ProgressTask;
import net.querz.mcaselector.ui.dialog.AboutDialog;
import net.querz.mcaselector.ui.dialog.CancellableProgressDialog;
import net.querz.mcaselector.ui.dialog.ChangeFieldsConfirmationDialog;
import net.querz.mcaselector.ui.dialog.ChangeNBTDialog;
import net.querz.mcaselector.ui.dialog.ConfirmationDialog;
import net.querz.mcaselector.ui.dialog.DeleteConfirmationDialog;
import net.querz.mcaselector.ui.dialog.ErrorDialog;
import net.querz.mcaselector.ui.dialog.ExportConfirmationDialog;
import net.querz.mcaselector.ui.dialog.FilterChunksDialog;
import net.querz.mcaselector.ui.dialog.GotoDialog;
import net.querz.mcaselector.ui.dialog.ImageExportConfirmationDialog;
import net.querz.mcaselector.ui.dialog.ImportConfirmationDialog;
import net.querz.mcaselector.ui.dialog.ImportSelectionDialog;
import net.querz.mcaselector.ui.dialog.NBTEditorDialog;
import net.querz.mcaselector.ui.dialog.NumberDialog;
import net.querz.mcaselector.ui.dialog.OverlayEditorDialog;
import net.querz.mcaselector.ui.dialog.ProgressDialog;
import net.querz.mcaselector.ui.dialog.SelectWorldDialog;
import net.querz.mcaselector.ui.dialog.SettingsDialog;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.mcaselector.util.validation.BeforeAfterCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogHelper {
    private static final Logger LOGGER = LogManager.getLogger(DialogHelper.class);

    public static void showAboutDialog(Stage primaryStage) {
        new AboutDialog(primaryStage).showAndWait();
    }

    public static void changeFields(TileMap tileMap, Stage primaryStage) {
        Optional result = new ChangeNBTDialog(tileMap, primaryStage).showAndWait();
        result.ifPresent(r -> {
            Optional confRes = new ChangeFieldsConfirmationDialog(null, primaryStage).showAndWait();
            confRes.ifPresent(confR -> {
                if (confR == ButtonType.OK) {
                    if (DialogHelper.runBefore(r, primaryStage)) {
                        return;
                    }
                    CancellableProgressDialog c = new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_CHANGING_NBT_DATA, primaryStage);
                    c.showProgressBar(t -> FieldChanger.changeNBTFields(r.fields(), r.force(), r.selectionOnly() ? tileMap.getSelection() : null, t, false));
                    if (r.requiresClearCache()) {
                        if (r.selectionOnly()) {
                            CacheHelper.clearSelectionCache(tileMap);
                        } else {
                            CacheHelper.clearAllCache(tileMap);
                        }
                    }
                    if (c.cancelled()) {
                        return;
                    }
                    DialogHelper.runAfter(r, primaryStage);
                }
            });
        });
    }

    public static void filterChunks(TileMap tileMap, Stage primaryStage) {
        Optional result = new FilterChunksDialog(primaryStage).showAndWait();
        result.ifPresent(r -> {
            LOGGER.debug("chunk filter query: {}", (Object)r.filter());
            if (r.filter().isEmpty()) {
                LOGGER.debug("filter is empty, won't delete everything");
                return;
            }
            switch (r.type()) {
                case DELETE: {
                    Optional confRes = new DeleteConfirmationDialog(null, primaryStage).showAndWait();
                    confRes.ifPresent(confR -> {
                        if (confR == ButtonType.OK) {
                            if (DialogHelper.runBefore(r, primaryStage)) {
                                return;
                            }
                            CancellableProgressDialog c = new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_DELETING_FILTERED_CHUNKS, primaryStage);
                            c.showProgressBar(t -> ChunkFilterDeleter.deleteFilter(r.filter(), r.selectionOnly() ? tileMap.getSelection() : null, t, false));
                            r.filter().resetTempData();
                            if (r.selectionOnly()) {
                                CacheHelper.clearSelectionCache(tileMap);
                                tileMap.clear();
                                tileMap.clearSelection();
                            } else {
                                CacheHelper.clearAllCache(tileMap);
                            }
                            if (c.cancelled()) {
                                return;
                            }
                            DialogHelper.runAfter(r, primaryStage);
                        }
                    });
                    break;
                }
                case EXPORT: {
                    File dir = DialogHelper.createDirectoryChooser(FileHelper.getLastOpenedDirectory("chunk_import_export", null)).showDialog((Window)primaryStage);
                    if (dir != null) {
                        Optional confRes = new ExportConfirmationDialog(null, primaryStage).showAndWait();
                        confRes.ifPresent(confR -> {
                            if (confR == ButtonType.OK) {
                                FileHelper.setLastOpenedDirectory("chunk_import_export", dir.getAbsolutePath());
                                LOGGER.debug("exporting chunks to {}", (Object)dir);
                                WorldDirectories worldDirectories = FileHelper.createWorldDirectories(dir);
                                if (worldDirectories == null) {
                                    LOGGER.warn("failed to create world directories");
                                    new ErrorDialog((Window)primaryStage, "failed to create world directories");
                                    return;
                                }
                                if (DialogHelper.runBefore(r, primaryStage)) {
                                    return;
                                }
                                CancellableProgressDialog c = new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_EXPORTING_FILTERED_CHUNKS, primaryStage);
                                c.showProgressBar(t -> ChunkFilterExporter.exportFilter(r.filter(), r.selectionOnly() ? tileMap.getSelection() : null, worldDirectories, t, false));
                                r.filter().resetTempData();
                                if (c.cancelled()) {
                                    return;
                                }
                                DialogHelper.runAfter(r, primaryStage);
                            }
                        });
                        break;
                    }
                    LOGGER.debug("cancelled exporting chunks, no valid destination directory");
                    break;
                }
                case SELECT: {
                    Selection selection = tileMap.getSelection();
                    if (r.overwriteSelection()) {
                        tileMap.clearSelection();
                    }
                    if (DialogHelper.runBefore(r, primaryStage)) break;
                    CancellableProgressDialog c = new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_SELECTING_FILTERED_CHUNKS, primaryStage);
                    c.showProgressBar(t -> ChunkFilterSelector.selectFilter(r.filter(), r.selectionOnly() ? (selection.isEmpty() ? null : selection) : null, r.radius(), s -> Platform.runLater(() -> {
                        tileMap.addSelection((Selection)s);
                        tileMap.draw();
                    }), t, false));
                    r.filter().resetTempData();
                    if (c.cancelled()) break;
                    DialogHelper.runAfter(r, primaryStage);
                    break;
                }
                default: {
                    LOGGER.debug("i have no idea how you got no selection there...");
                }
            }
        });
        tileMap.draw();
    }

    private static boolean runBefore(BeforeAfterCallback result, Stage primaryStage) {
        if (result.valid()) {
            CancellableProgressDialog c = new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_RUNNING_BEFORE, primaryStage);
            c.showProgressBar(t -> {
                t.setIndeterminate("running before()...");
                result.before();
                t.done("done");
            });
            return c.cancelled();
        }
        return false;
    }

    private static boolean runAfter(BeforeAfterCallback result, Stage primaryStage) {
        if (result.valid()) {
            CancellableProgressDialog c = new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_RUNNING_AFTER, primaryStage);
            c.showProgressBar(t -> {
                t.setIndeterminate("running after()...");
                result.after();
                t.done("done");
            });
            return c.cancelled();
        }
        return false;
    }

    public static void quit(TileMap tileMap, Stage primaryStage) {
        if (tileMap.hasUnsavedSelection()) {
            Optional result = new ConfirmationDialog((Window)primaryStage, Translation.DIALOG_UNSAVED_SELECTION_TITLE, Translation.DIALOG_UNSAVED_SELECTION_HEADER, "unsaved-changes").showAndWait();
            result.ifPresent(r -> {
                if (r == ButtonType.OK) {
                    System.exit(0);
                }
            });
        } else {
            System.exit(0);
        }
    }

    public static void editOverlays(TileMap tileMap, Stage primaryStage) {
        new OverlayEditorDialog(primaryStage, tileMap, tileMap.getOverlays()).show();
    }

    public static void deleteSelection(TileMap tileMap, Stage primaryStage) {
        Optional result = new DeleteConfirmationDialog(tileMap, primaryStage).showAndWait();
        result.ifPresent(r -> {
            if (r == ButtonType.OK) {
                new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_DELETING_SELECTION, primaryStage).showProgressBar(t -> SelectionDeleter.deleteSelection(tileMap.getSelection(), t));
                CacheHelper.clearSelectionCache(tileMap);
                tileMap.clear();
                tileMap.clearSelection();
                tileMap.draw();
            }
        });
    }

    public static void exportSelectedChunks(TileMap tileMap, Stage primaryStage) {
        File dir = DialogHelper.createDirectoryChooser(FileHelper.getLastOpenedDirectory("chunk_import_export", null)).showDialog((Window)primaryStage);
        if (dir != null) {
            Optional result = new ExportConfirmationDialog(tileMap, primaryStage).showAndWait();
            result.ifPresent(r -> {
                if (r == ButtonType.OK) {
                    FileHelper.setLastOpenedDirectory("chunk_import_export", dir.getAbsolutePath());
                    WorldDirectories worldDirectories = FileHelper.createWorldDirectories(dir);
                    if (worldDirectories == null) {
                        LOGGER.warn("failed to create world directories");
                        new ErrorDialog((Window)primaryStage, "failed to create world directories");
                        return;
                    }
                    new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_EXPORTING_SELECTION, primaryStage).showProgressBar(t -> SelectionExporter.exportSelection(tileMap.getSelection(), worldDirectories, t));
                }
            });
        }
    }

    public static void importChunks(TileMap tileMap, Stage primaryStage) {
        File dir = DialogHelper.createDirectoryChooser(FileHelper.getLastOpenedDirectory("chunk_import_export", null)).showDialog((Window)primaryStage);
        DataProperty dataProperty = new DataProperty();
        if (dir != null) {
            Optional result = new ImportConfirmationDialog(primaryStage, null, dataProperty::set).showAndWait();
            result.ifPresent(r -> {
                if (r == ButtonType.OK) {
                    FileHelper.setLastOpenedDirectory("chunk_import_export", dir.getAbsolutePath());
                    DataProperty tempFiles = new DataProperty();
                    WorldDirectories wd = FileHelper.validateWorldDirectories(dir);
                    if (wd == null) {
                        new ErrorDialog((Window)primaryStage, "invalid world directory, missing 'region' directory");
                        return;
                    }
                    new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_IMPORTING_CHUNKS, primaryStage).showProgressBar(t -> ChunkImporter.importChunks(wd, t, false, ((ImportConfirmationDialog.ChunkImportConfirmationData)dataProperty.get()).overwrite(), null, ((ImportConfirmationDialog.ChunkImportConfirmationData)dataProperty.get()).selectionOnly() ? tileMap.getSelection() : null, ((ImportConfirmationDialog.ChunkImportConfirmationData)dataProperty.get()).getRanges(), ((ImportConfirmationDialog.ChunkImportConfirmationData)dataProperty.get()).getOffset(), tempFiles));
                    DialogHelper.deleteTempFiles((Map)tempFiles.get());
                    CacheHelper.clearAllCache(tileMap);
                }
            });
        }
    }

    public static void gotoCoordinate(TileMap tileMap, Stage primaryStage) {
        Optional result = new GotoDialog(primaryStage).showAndWait();
        result.ifPresent(r -> tileMap.goTo(r.getX(), r.getZ()));
    }

    public static void editSettings(TileMap tileMap, Stage primaryStage, boolean renderSettings) {
        if (tileMap.getDisabled() && renderSettings) {
            return;
        }
        Optional result = new SettingsDialog(primaryStage, renderSettings).showAndWait();
        result.ifPresent(r -> {
            if (ConfigProvider.GLOBAL.getProcessThreads() != r.processThreads || ConfigProvider.GLOBAL.getWriteThreads() != r.writeThreads) {
                ConfigProvider.GLOBAL.setProcessThreads(r.processThreads);
                ConfigProvider.GLOBAL.setWriteThreads(r.writeThreads);
                JobHandler.init();
            }
            ConfigProvider.GLOBAL.setMaxLoadedFiles(r.maxLoadedFiles);
            if (!ConfigProvider.GLOBAL.getLocale().equals(r.locale)) {
                ConfigProvider.GLOBAL.setLocale(r.locale);
                Locale.setDefault(ConfigProvider.GLOBAL.getLocale());
            }
            ConfigProvider.GLOBAL.setRegionSelectionColor(new Color(r.regionColor));
            ConfigProvider.GLOBAL.setChunkSelectionColor(new Color(r.chunkColor));
            ConfigProvider.GLOBAL.setPasteChunksColor(new Color(r.pasteColor));
            tileMap.redrawOverlays();
            ConfigProvider.GLOBAL.setMcSavesDir(String.valueOf(r.mcSavesDir));
            ConfigProvider.GLOBAL.setDebug(r.debug);
            if (!tileMap.getDisabled()) {
                ConfigProvider.WORLD.setShowNonexistentRegions(r.showNonexistentRegions);
                tileMap.setShowNonexistentRegions(r.showNonexistentRegions);
                ConfigProvider.WORLD.setSmoothRendering(r.smoothRendering);
                tileMap.setSmoothRendering(r.smoothRendering);
                ConfigProvider.WORLD.setSmoothOverlays(r.smoothOverlays);
                ConfigProvider.WORLD.setTileMapBackground(r.tileMapBackground.name());
                tileMap.getWindow().getTileMapBox().setBackground(r.tileMapBackground.getBackground());
                if (r.height != ConfigProvider.WORLD.getRenderHeight() || r.layerOnly != ConfigProvider.WORLD.getRenderLayerOnly() || r.shade != ConfigProvider.WORLD.getShade() || r.shadeWater != ConfigProvider.WORLD.getShadeWater() || r.shadeAltitude != ConfigProvider.WORLD.getShadeAltitude() || r.caves != ConfigProvider.WORLD.getRenderCaves()) {
                    ConfigProvider.WORLD.setRenderHeight(r.height);
                    ConfigProvider.WORLD.setRenderLayerOnly(r.layerOnly);
                    ConfigProvider.WORLD.setRenderCaves(r.caves);
                    tileMap.getWindow().getOptionBar().setRenderHeight(r.height);
                    ConfigProvider.WORLD.setShade(r.shade);
                    ConfigProvider.WORLD.setShadeWater(r.shadeWater);
                    ConfigProvider.WORLD.setShadeAltitude(r.shadeAltitude);
                    CacheHelper.clearAllCache(tileMap);
                }
                WorldDirectories worldDirectories = ConfigProvider.WORLD.getWorldDirs();
                worldDirectories.setPoi(r.poi);
                worldDirectories.setEntities(r.entities);
                ConfigProvider.WORLD.save();
            }
            ConfigProvider.GLOBAL.save();
            ConfigProvider.OVERLAY.save();
            tileMap.draw();
        });
    }

    public static void editNBT(TileMap tileMap, Stage primaryStage) {
        new NBTEditorDialog(tileMap, primaryStage).showAndWait();
    }

    public static void screenshot(TileMap tileMap, Stage primaryStage) {
        SnapshotParameters params = new SnapshotParameters();
        params.setFill((Paint)Color.TRANSPARENT.makeJavaFXColor());
        WritableImage snapshot = tileMap.snapshot(params, null);
        File file = DialogHelper.createFileChooser(FileHelper.getLastOpenedDirectory("snapshot_save", null), new FileChooser.ExtensionFilter("*.png Files", new String[]{"*.png"})).showSaveDialog((Window)primaryStage);
        if (file != null) {
            try {
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)snapshot, null), "png", file);
                FileHelper.setLastOpenedDirectory("snapshot_save", file.getParent());
            }
            catch (IOException ex) {
                LOGGER.warn("failed to save screenshot", (Throwable)ex);
                new ErrorDialog((Window)primaryStage, ex);
            }
        }
    }

    public static void generateImageFromSelection(TileMap tileMap, Stage primaryStage) {
        SelectionData data = new SelectionData(tileMap.getSelection(), null);
        if (data.getWidth() * 16L * data.getHeight() * 16L > Integer.MAX_VALUE) {
            String error = String.format("dimensions are too large to generate an image: %dx%d", data.getWidth() * 16L, data.getHeight() * 16L);
            LOGGER.warn(error);
            new ErrorDialog((Window)primaryStage, error);
            return;
        }
        File file = DialogHelper.createFileChooser(FileHelper.getLastOpenedDirectory("snapshot_save", null), new FileChooser.ExtensionFilter("*.png Files", new String[]{"*.png"})).showSaveDialog((Window)primaryStage);
        if (file == null) {
            return;
        }
        Optional result = new ImageExportConfirmationDialog(tileMap, data, primaryStage).showAndWait();
        result.ifPresent(b -> {
            if (b == ButtonType.OK) {
                DataProperty pixels = new DataProperty();
                CancellableProgressDialog cpd = new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_CREATING_IMAGE, primaryStage);
                cpd.showProgressBar(t -> pixels.set(SelectionImageExporter.exportSelectionImage(data, tileMap.getOverlayPool(), t)));
                if (!cpd.cancelled() && pixels.get() != null) {
                    new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_SAVING_IMAGE, primaryStage).showProgressBar(t -> {
                        try {
                            ImageHelper.saveImageData((int[])pixels.get(), (int)data.getWidth() * 16, (int)data.getHeight() * 16, file, t);
                            FileHelper.setLastOpenedDirectory("snapshot_save", file.getParent());
                        }
                        catch (IOException ex) {
                            LOGGER.warn("failed to save image", (Throwable)ex);
                            new ErrorDialog((Window)primaryStage, ex);
                        }
                    });
                }
            }
        });
    }

    public static void swapChunks(TileMap tileMap, Stage primaryStage) {
        new ProgressDialog(Translation.MENU_TOOLS_SWAP_CHUNKS, (Window)primaryStage).showProgressBar(t -> {
            Region to;
            Region from;
            t.setMax(4);
            Selection markedChunks = tileMap.getSelection();
            LongArrayList chunks = new LongArrayList(2);
            for (Long2ObjectMap.Entry<ChunkSet> entry : markedChunks) {
                IntIterator intIterator = ((ChunkSet)entry.getValue()).iterator();
                while (intIterator.hasNext()) {
                    int markedChunk = (Integer)intIterator.next();
                    chunks.add(new Point2i(entry.getLongKey()).regionToChunk().add(new Point2i(markedChunk)).asLong());
                }
            }
            if (chunks.size() != 2) {
                throw new IllegalStateException("need 2 chunks to swap");
            }
            Point2i fromChunk = new Point2i(chunks.getLong(0));
            Point2i toChunk = new Point2i(chunks.getLong(1));
            Point2i fromRegion = fromChunk.chunkToRegion();
            Point2i toRegion = toChunk.chunkToRegion();
            LOGGER.debug("swapping chunk {}:{} with {}:{}", (Object)fromChunk, (Object)fromRegion, (Object)toChunk, (Object)toRegion);
            t.incrementProgress(FileHelper.createMCAFileName(fromRegion));
            try {
                from = Region.loadOrCreateEmptyRegion(FileHelper.createRegionDirectories(fromRegion));
            }
            catch (IOException ex) {
                LOGGER.warn("failed to load region files", (Throwable)ex);
                t.done(null);
                new ErrorDialog((Window)primaryStage, ex);
                return;
            }
            if (fromRegion.equals(toRegion)) {
                to = from;
            } else {
                try {
                    to = Region.loadOrCreateEmptyRegion(FileHelper.createRegionDirectories(toRegion));
                }
                catch (IOException ex) {
                    LOGGER.warn("failed to load region files", (Throwable)ex);
                    t.done(null);
                    new ErrorDialog((Window)primaryStage, ex);
                    return;
                }
            }
            Point2i fromOffset = toChunk.sub(fromChunk);
            Point2i toOffset = fromChunk.sub(toChunk);
            ChunkData fromData = from.getChunkDataAt(fromChunk, true);
            fromData.relocate(fromOffset.chunkToBlock().toPoint3i());
            ChunkData toData = to.getChunkDataAt(toChunk, true);
            toData.relocate(toOffset.chunkToBlock().toPoint3i());
            from.setChunkDataAt(toData, fromChunk);
            to.setChunkDataAt(fromData, toChunk);
            t.incrementProgress(FileHelper.createMCAFileName(toRegion));
            try {
                to.saveWithTempFiles();
            }
            catch (IOException ex) {
                LOGGER.warn("failed to save region files", (Throwable)ex);
                t.done(null);
                new ErrorDialog((Window)primaryStage, ex);
                return;
            }
            if (to != from) {
                try {
                    from.saveWithTempFiles();
                }
                catch (IOException ex) {
                    LOGGER.warn("failed to save region files", (Throwable)ex);
                    t.done(null);
                    new ErrorDialog((Window)primaryStage, ex);
                    return;
                }
            }
            t.done(Translation.DIALOG_PROGRESS_DONE.toString());
            Platform.runLater(() -> CacheHelper.clearSelectionCache(tileMap));
        });
    }

    public static void copySelectedChunks(TileMap tileMap) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        SelectionData data = new SelectionData(tileMap.getSelection(), ConfigProvider.WORLD.getWorldDirs());
        ClipboardSelection clipboardSelection = new ClipboardSelection(data);
        clipboard.setContents(clipboardSelection, tileMap);
    }

    public static void pasteSelectedChunks(TileMap tileMap, Stage primaryStage) {
        if (tileMap.isInPastingMode()) {
            DataProperty dataProperty = new DataProperty();
            ImportConfirmationDialog.ChunkImportConfirmationData preFill = new ImportConfirmationDialog.ChunkImportConfirmationData(tileMap.getPastedChunksOffset(), 0, true, false, null);
            Optional result = new ImportConfirmationDialog(primaryStage, preFill, dataProperty::set).showAndWait();
            result.ifPresent(r -> {
                if (r == ButtonType.OK) {
                    DataProperty tempFiles = new DataProperty();
                    new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_IMPORTING_CHUNKS, primaryStage).showProgressBar(t -> ChunkImporter.importChunks(tileMap.getPastedWorld(), t, false, ((ImportConfirmationDialog.ChunkImportConfirmationData)dataProperty.get()).overwrite(), tileMap.getPastedChunks(), ((ImportConfirmationDialog.ChunkImportConfirmationData)dataProperty.get()).selectionOnly() ? tileMap.getSelection() : null, ((ImportConfirmationDialog.ChunkImportConfirmationData)dataProperty.get()).getRanges(), ((ImportConfirmationDialog.ChunkImportConfirmationData)dataProperty.get()).getOffset(), tempFiles));
                    DialogHelper.deleteTempFiles((Map)tempFiles.get());
                    CacheHelper.clearAllCache(tileMap);
                }
            });
        } else {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = clipboard.getContents(tileMap);
            DataFlavor[] flavors = content.getTransferDataFlavors();
            if (flavors.length == 1 && flavors[0].equals(ClipboardSelection.SELECTION_DATA_FLAVOR)) {
                try {
                    Object data = content.getTransferData(flavors[0]);
                    SelectionData selectionData = (SelectionData)data;
                    tileMap.setPastedChunks(selectionData);
                    tileMap.draw();
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    LOGGER.warn("failed to paste chunks", (Throwable)ex);
                }
            }
        }
    }

    private static void deleteTempFiles(Map<Point2i, RegionDirectories> tempFiles) {
        if (tempFiles != null) {
            for (RegionDirectories tempFile : tempFiles.values()) {
                if (!tempFile.getRegion().delete()) {
                    LOGGER.warn("failed to delete temp file {}", (Object)tempFile.getRegion());
                }
                if (!tempFile.getPoi().delete()) {
                    LOGGER.warn("failed to delete temp file {}", (Object)tempFile.getPoi());
                }
                if (tempFile.getEntities().delete()) continue;
                LOGGER.warn("failed to delete temp file {}", (Object)tempFile.getEntities());
            }
        }
    }

    public static void openWorld(TileMap tileMap, Stage primaryStage) {
        Optional result;
        if (tileMap.hasUnsavedSelection() && (result = new ConfirmationDialog((Window)primaryStage, Translation.DIALOG_UNSAVED_SELECTION_TITLE, Translation.DIALOG_UNSAVED_SELECTION_HEADER, "unsaved-changes").showAndWait()).isPresent() && result.get() == ButtonType.CANCEL) {
            return;
        }
        String lastOpenDirectory = FileHelper.getLastOpenedDirectory("open_world", ConfigProvider.GLOBAL.getMcSavesDir());
        File file = DialogHelper.createDirectoryChooser(lastOpenDirectory).showDialog((Window)primaryStage);
        if (file != null && file.isDirectory()) {
            List<File> dimensions = FileHelper.detectDimensionDirectories(file);
            if (dimensions.isEmpty()) {
                new ErrorDialog((Window)primaryStage, String.format("no dimensions found in %s", file.getAbsolutePath()));
                LOGGER.warn("no dimensions found in {}", (Object)file.getAbsolutePath());
                return;
            }
            FileHelper.setLastOpenedDirectory("open_world", file.getAbsolutePath());
            if (dimensions.size() == 1) {
                DialogHelper.setWorld(FileHelper.detectWorldDirectories(dimensions.getFirst()), dimensions, tileMap, primaryStage);
                return;
            }
            Optional result2 = new SelectWorldDialog(dimensions, primaryStage).showAndWait();
            result2.ifPresent(dim -> DialogHelper.setWorld(FileHelper.detectWorldDirectories(dim), dimensions, tileMap, primaryStage));
        } else if (file != null) {
            new ErrorDialog((Window)primaryStage, String.format("%s is not a directory", file));
        }
    }

    public static void setWorld(WorldDirectories worldDirectories, List<File> dimensionDirectories, TileMap tileMap, Stage primaryStage) {
        ConfigProvider.GLOBAL.addRecentWorld(worldDirectories.getRegion().getParentFile(), dimensionDirectories);
        new ProgressDialog(Translation.DIALOG_PROGRESS_TITLE_LOADING_WORLD, (Window)primaryStage).showProgressBar(task -> {
            ConfigProvider.loadWorldConfig(worldDirectories, dimensionDirectories);
            CacheHelper.validateCacheVersion(tileMap);
            RegionImageGenerator.invalidateCachedMCAFiles();
            tileMap.getWindow().getOptionBar().setRenderHeight(ConfigProvider.WORLD.getRenderHeight());
            tileMap.clear((ProgressTask)task, false);
            tileMap.getOverlayPool().switchTo(new File(ConfigProvider.WORLD.getCacheDir(), "cache").toString());
            tileMap.clearSelection();
            tileMap.draw();
            tileMap.disable(false);
            tileMap.getWindow().getOptionBar().setWorldDependentMenuItemsEnabled(true, tileMap, primaryStage);
            task.done(Translation.DIALOG_PROGRESS_DONE.toString());
            Platform.runLater(() -> tileMap.getWindow().setTitleSuffix(worldDirectories.getRegion().getParent()));
        });
    }

    public static void importSelection(TileMap tileMap, Stage primaryStage) {
        File file = DialogHelper.createFileChooser(FileHelper.getLastOpenedDirectory("selection_import_export", null), new FileChooser.ExtensionFilter("*.csv Files", new String[]{"*.csv"})).showOpenDialog((Window)primaryStage);
        if (file != null) {
            Selection selection;
            ImportSelectionDialog.Result result = ImportSelectionDialog.Result.OVERWRITE;
            if (tileMap.getSelectedChunks() > 0) {
                Optional optional = new ImportSelectionDialog(primaryStage).showAndWait();
                if (optional.isEmpty()) {
                    return;
                }
                result = (ImportSelectionDialog.Result)((Object)optional.get());
            }
            try {
                selection = Selection.readFromFile(file);
            }
            catch (IOException ex) {
                LOGGER.warn("failed to read selection from file", (Throwable)ex);
                new ErrorDialog((Window)primaryStage, ex.getMessage());
                return;
            }
            FileHelper.setLastOpenedDirectory("selection_import_export", file.getParent());
            switch (result) {
                case OVERWRITE: {
                    tileMap.setSelection(selection);
                    break;
                }
                case MERGE: {
                    tileMap.addSelection(selection);
                }
            }
            tileMap.draw();
        }
    }

    public static void exportSelection(TileMap tileMap, Stage primaryStage) {
        File file = DialogHelper.createFileChooser(FileHelper.getLastOpenedDirectory("selection_import_export", null), new FileChooser.ExtensionFilter("*.csv Files", new String[]{"*.csv"})).showSaveDialog((Window)primaryStage);
        if (file != null) {
            try {
                tileMap.getSelection().saveToFile(file);
            }
            catch (IOException ex) {
                LOGGER.warn("failed to save selection to file", (Throwable)ex);
                new ErrorDialog((Window)primaryStage, ex);
                return;
            }
            FileHelper.setLastOpenedDirectory("selection_import_export", file.getParent());
            tileMap.setSelectionSaved();
            tileMap.draw();
        }
    }

    public static void sumSelection(TileMap tileMap, Stage primaryStage) {
        if (tileMap.getOverlay() == null) {
            String error = "a right overlay must be active in order to sum the selection";
            LOGGER.warn(error);
            new ErrorDialog((Window)primaryStage, error);
            return;
        }
        DataProperty sum = new DataProperty();
        CancellableProgressDialog cpd = new CancellableProgressDialog(Translation.DIALOG_PROGRESS_TITLE_SUMMING, primaryStage);
        cpd.showProgressBar(t -> sum.set(SelectionSummer.sumSelection(tileMap.getSelection(), tileMap.getOverlay(), t)));
        if (!cpd.cancelled()) {
            String s = tileMap.getOverlay().getShortMultiValues();
            String title = String.valueOf((Object)tileMap.getOverlay().getType()) + (String)(s == null ? "" : "(" + s + ")");
            new NumberDialog(primaryStage, ((AtomicLong)sum.get()).get(), title).showAndWait();
        }
    }

    public static DirectoryChooser createDirectoryChooser(String initialDirectory) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        if (initialDirectory != null) {
            directoryChooser.setInitialDirectory(new File(initialDirectory));
        }
        return directoryChooser;
    }

    public static FileChooser createFileChooser(String initialDirectory, FileChooser.ExtensionFilter filter) {
        FileChooser fileChooser = new FileChooser();
        if (filter != null) {
            fileChooser.getExtensionFilters().add((Object)filter);
        }
        if (initialDirectory != null) {
            fileChooser.setInitialDirectory(new File(initialDirectory));
        }
        return fileChooser;
    }
}

