/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui;

import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.util.progress.Progress;

public abstract class ProgressTask
extends Task<Void>
implements Progress {
    private int max;
    private final AtomicInteger current = new AtomicInteger(0);
    private final StringProperty infoProperty = new SimpleStringProperty(Translation.DIALOG_PROGRESS_RUNNING.toString());
    private Runnable onFinish;
    private boolean locked = false;
    private boolean cancelled = false;

    public ProgressTask() {
    }

    public ProgressTask(int max) {
        this.max = max;
    }

    @Override
    public void cancelTask() {
        this.cancelled = true;
        this.done("");
    }

    @Override
    public boolean taskCancelled() {
        return this.cancelled;
    }

    @Override
    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void incrementProgress(String info) {
        this.updateProgress(info, this.current.incrementAndGet(), this.max);
    }

    @Override
    public void incrementProgress(String info, int count) {
        this.updateProgress(info, this.current.addAndGet(count), this.max);
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    public void done(String info) {
        this.updateProgress(info, 1.0, 1);
    }

    @Override
    public void setMessage(String msg) {
        Platform.runLater(() -> this.infoProperty.setValue(msg));
    }

    public void setIndeterminate(String info) {
        Platform.runLater(() -> this.infoProperty.setValue(info));
        this.updateProgress(-1L, 0L);
    }

    @Override
    public void updateProgress(String info, int progress) {
        this.current.set(progress);
        this.updateProgress(info, progress, this.max);
    }

    public void updateProgress(String info, double progress, int max) {
        if (!this.locked) {
            Platform.runLater(() -> this.infoProperty.setValue(info));
            this.updateProgress(progress, max);
            if (progress == (double)max && this.onFinish != null) {
                Platform.runLater((Runnable)this.onFinish);
            }
        }
    }

    public StringProperty infoProperty() {
        return this.infoProperty;
    }

    public void setOnFinish(Runnable r) {
        this.onFinish = r;
    }
}

