/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Dialog;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.logging.Logging;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.DialogHelper;
import net.querz.mcaselector.ui.component.OptionBar;
import net.querz.mcaselector.ui.component.StatusBar;
import net.querz.mcaselector.ui.component.TileMapBox;
import net.querz.mcaselector.ui.dialog.PreviewDisclaimerDialog;

public class Window
extends Application {
    private final int width = 800;
    private final int height = 600;
    private final Set<KeyCode> pressedKeys = EnumSet.noneOf(KeyCode.class);
    private Stage primaryStage;
    private String title = "";
    private OptionBar optionBar;
    private TileMapBox tileMapBox;
    private final List<Dialog<?>> trackedDialogs = new ArrayList();

    public void start(Stage primaryStage) {
        String version;
        this.primaryStage = primaryStage;
        try {
            version = FileHelper.getManifestAttributes().getValue("Application-Version");
        }
        catch (IOException ex) {
            version = "dev";
        }
        this.title = "MCA Selector " + version;
        primaryStage.setTitle(this.title);
        primaryStage.getIcons().add((Object)FileHelper.getIconFromResources("img/icon"));
        TileMap tileMap = new TileMap(this, 800, 600);
        BorderPane pane = new BorderPane();
        this.optionBar = new OptionBar(tileMap, primaryStage);
        pane.setTop((Node)this.optionBar);
        this.tileMapBox = new TileMapBox(tileMap, primaryStage);
        pane.setCenter((Node)this.tileMapBox);
        pane.setBottom((Node)new StatusBar(tileMap));
        Scene scene = new Scene((Parent)pane, 800.0, 600.0);
        Font.loadFont((String)Objects.requireNonNull(Window.class.getClassLoader().getResource("font/NotoSans-Regular.ttf")).toExternalForm(), (double)10.0);
        Font.loadFont((String)Objects.requireNonNull(Window.class.getClassLoader().getResource("font/NotoSansMono-Regular.ttf")).toExternalForm(), (double)10.0);
        Font.loadFont((String)Objects.requireNonNull(Window.class.getClassLoader().getResource("font/NotoSansMono-Bold.ttf")).toExternalForm(), (double)10.0);
        URL cssRes = Window.class.getClassLoader().getResource("style/base.css");
        if (cssRes != null) {
            String styleSheet = cssRes.toExternalForm();
            scene.getStylesheets().add((Object)styleSheet);
        }
        scene.setOnKeyPressed(e -> this.pressedKeys.add(e.getCode()));
        scene.setOnKeyReleased(e -> this.pressedKeys.remove(e.getCode()));
        primaryStage.focusedProperty().addListener((obs, o, n) -> {
            if (!n.booleanValue()) {
                this.pressedKeys.clear();
            }
        });
        primaryStage.setOnCloseRequest(e -> {
            DialogHelper.quit(tileMap, primaryStage);
            e.consume();
        });
        primaryStage.setScene(scene);
        if (version.contains("pre")) {
            new PreviewDisclaimerDialog(primaryStage).showAndWait();
        }
        tileMap.requestFocus();
        primaryStage.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.trackedDialogs.forEach(d -> {
                    ((Stage)d.getDialogPane().getScene().getWindow()).setAlwaysOnTop(true);
                    ((Stage)d.getDialogPane().getScene().getWindow()).setAlwaysOnTop(false);
                });
            }
        });
        Logging.updateThreadContext();
        primaryStage.show();
    }

    public void trackDialog(Dialog<?> dialog) {
        this.trackedDialogs.add(dialog);
    }

    public void untrackDialog(Dialog<?> dialog) {
        this.trackedDialogs.remove(dialog);
    }

    public void setTitleSuffix(String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            this.primaryStage.setTitle(this.title);
        } else {
            this.primaryStage.setTitle(this.title + "    " + suffix);
        }
    }

    public boolean isKeyPressed(KeyCode keyCode) {
        return this.pressedKeys.contains(keyCode);
    }

    public OptionBar getOptionBar() {
        return this.optionBar;
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public TileMapBox getTileMapBox() {
        return this.tileMapBox;
    }
}

