/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.io.Closeable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javax.script.ScriptException;
import net.querz.mcaselector.io.GroovyScriptEngine;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.reactfx.Subscription;

public class GroovyCodeArea
extends CodeArea
implements Closeable {
    private final ExecutorService executor;
    private final Subscription highlightSubscription;
    private Subscription evalSubscription;
    private GroovyScriptEngine engine;
    private final StringProperty error = new SimpleStringProperty();
    private Runnable changeListener;
    private static final String[] KEYWORDS = new String[]{"abstract", "as", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "def", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "threadsafe", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final String KEYWORD_PATTERN = "(?<KEYWORD>\\b(" + String.join((CharSequence)"|", KEYWORDS) + ")\\b)";
    private static final String PAREN_PATTERN = "(?<PAREN>[()])";
    private static final String BRACE_PATTERN = "(?<BRACE>[{}])";
    private static final String BRACKET_PATTERN = "(?<BRACKET>[\\[\\]])";
    private static final String SEMICOLON_PATTERN = "(?<SEMICOLON>;)";
    private static final String STRING_PATTERN = "(?<STRING>[\"']([^\"'\\\\]|\\\\.)*[\"'])";
    private static final String COMMENT_PATTERN = "(?<COMMENT>//[^\n]*|/\\*(.|\\R)*?\\*/)";
    private static final String FUNCTION_PATTERN = "(?<FUNCTION>[a-zA-Z_$][\\w$]*)\\(";
    private static final Pattern PATTERN = Pattern.compile(KEYWORD_PATTERN + "|(?<PAREN>[()])|(?<BRACE>[{}])|(?<BRACKET>[\\[\\]])|(?<SEMICOLON>;)|(?<STRING>[\"']([^\"'\\\\]|\\\\.)*[\"'])|(?<COMMENT>//[^\n]*|/\\*(.|\\R)*?\\*/)|(?<FUNCTION>[a-zA-Z_$][\\w$]*)\\(");
    private final Pattern infoPattern = Pattern.compile("Script\\d+.groovy: \\d+: (.*) @ line (\\d+), column (\\d+).");

    public ObservableValue<String> errorProperty() {
        return this.error;
    }

    public void setChangeListener(Runnable listener) {
        this.changeListener = listener;
    }

    public GroovyCodeArea(boolean eval) {
        this.executor = Executors.newSingleThreadExecutor();
        this.setParagraphGraphicFactory(LineNumberFactory.get(this));
        this.highlightSubscription = this.multiPlainChanges().successionEnds(Duration.ofMillis(500L)).retainLatestUntilLater(this.executor).supplyTask(this::computeHighlightingAsync).awaitLatest(this.multiPlainChanges()).filterMap(t -> {
            if (t.isSuccess()) {
                return Optional.of((StyleSpans)t.get());
            }
            t.getFailure().printStackTrace();
            return Optional.empty();
        }).subscribe(h -> this.setStyleSpans(0, h));
        if (eval) {
            this.engine = new GroovyScriptEngine();
            this.evalSubscription = this.multiPlainChanges().successionEnds(Duration.ofMillis(500L)).retainLatestUntilLater(this.executor).supplyTask(this::evalAsync).awaitLatest(this.multiPlainChanges()).filterMap(t -> {
                if (t.isSuccess()) {
                    if (this.changeListener != null) {
                        this.changeListener.run();
                    }
                    return Optional.of((String)t.get());
                }
                t.getFailure().printStackTrace();
                return Optional.empty();
            }).subscribe(arg_0 -> ((StringProperty)this.error).set(arg_0));
        }
        this.getStylesheets().add((Object)Objects.requireNonNull(GroovyCodeArea.class.getClassLoader().getResource("style/component/groovy-code-area.css")).toExternalForm());
    }

    private Task<String> evalAsync() {
        final String text = this.getText();
        Task<String> task = new Task<String>(){

            protected String call() {
                try {
                    GroovyCodeArea.this.engine.eval(text);
                    return "";
                }
                catch (ScriptException e) {
                    return GroovyCodeArea.this.readInfo(e, text);
                }
            }
        };
        this.executor.execute((Runnable)task);
        return task;
    }

    private String readInfo(ScriptException ex, String script) {
        Matcher m = this.infoPattern.matcher(ex.getMessage());
        if (m.find()) {
            String msg = m.group(1);
            int line = Integer.parseInt(m.group(2));
            int column = Integer.parseInt(m.group(3));
            String[] scriptLines = script.split("\n", line + 1);
            String scriptLine = scriptLines[line - 1];
            String scriptLineLeft = scriptLine.substring(0, column - 1);
            int tabs = (int)scriptLineLeft.chars().filter(c -> c == 9).count();
            String arrow = "-".repeat(column + tabs * 3 - 1) + "^";
            scriptLine = scriptLine.replace("\t", "    ");
            return String.format("%s: line %d, column %d.\n%s\n%s", msg, line, column, scriptLine, arrow);
        }
        return "";
    }

    private Task<StyleSpans<Collection<String>>> computeHighlightingAsync() {
        final String text = this.getText();
        Task<StyleSpans<Collection<String>>> task = new Task<StyleSpans<Collection<String>>>(this){

            protected StyleSpans<Collection<String>> call() {
                return GroovyCodeArea.computeHighlighting(text);
            }
        };
        this.executor.execute((Runnable)task);
        return task;
    }

    private static StyleSpans<Collection<String>> computeHighlighting(String text) {
        Matcher matcher = PATTERN.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder<Collection<Object>> spansBuilder = new StyleSpansBuilder<Collection<Object>>();
        while (matcher.find()) {
            String styleClass;
            String match = matcher.group("KEYWORD");
            String string = match != null ? "keyword" : ((match = matcher.group("PAREN")) != null ? "paren" : ((match = matcher.group("BRACE")) != null ? "brace" : ((match = matcher.group("BRACKET")) != null ? "bracket" : ((match = matcher.group("SEMICOLON")) != null ? "semicolon" : ((match = matcher.group("STRING")) != null ? "string" : ((match = matcher.group("COMMENT")) != null ? "comment" : (styleClass = (match = matcher.group("FUNCTION")) != null ? "function" : null)))))));
            assert (styleClass != null);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), match.length());
            lastKwEnd = matcher.start() + match.length();
            matcher.region(lastKwEnd, text.length());
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }

    public void setText(String text) {
        this.replaceText(0, this.getLength(), text);
        this.setStyleSpans(0, GroovyCodeArea.computeHighlighting(text));
    }

    @Override
    public void close() {
        this.highlightSubscription.unsubscribe();
        if (this.evalSubscription != null) {
            this.evalSubscription.unsubscribe();
        }
        this.executor.shutdown();
    }
}

