/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import net.querz.mcaselector.util.point.Point2i;

public class LocationInput
extends HBox {
    private Point2i value;
    private Integer x;
    private Integer z;
    private final TextField xValue;
    private final TextField zValue;
    private Consumer<Boolean> validityCheckAction;
    private final boolean emptyIsZero;

    public LocationInput(boolean emptyIsZero) {
        this.getStyleClass().add((Object)"location-input");
        this.getStylesheets().add((Object)Objects.requireNonNull(LocationInput.class.getClassLoader().getResource("style/component/location-input.css")).toExternalForm());
        this.emptyIsZero = emptyIsZero;
        if (emptyIsZero) {
            this.x = this.z = Integer.valueOf(0);
            this.value = new Point2i(0, 0);
        }
        this.xValue = new TextField();
        this.xValue.setPromptText("X");
        this.xValue.textProperty().addListener((a, o, n) -> this.onXInput((String)o, (String)n));
        this.zValue = new TextField();
        this.zValue.setPromptText("Z");
        this.zValue.textProperty().addListener((a, o, n) -> this.onZInput((String)o, (String)n));
        this.getChildren().addAll((Object[])new Node[]{this.xValue, this.zValue});
    }

    public boolean emptyIsZero() {
        return this.emptyIsZero;
    }

    public void setX(Integer x) {
        this.x = x;
        if (x != null) {
            this.xValue.setText(x.toString());
        }
        this.setValue();
    }

    public void setZ(Integer z) {
        this.z = z;
        if (z != null) {
            this.zValue.setText(z.toString());
        }
        this.setValue();
    }

    public void requestFocus() {
        this.xValue.requestFocus();
    }

    private void onXInput(String o, String n) {
        block3: {
            if (this.emptyIsZero && (n.isEmpty() || "-".equals(n) || "+".equals(n))) {
                this.x = 0;
                this.setValue();
                return;
            }
            try {
                this.x = Integer.parseInt(n);
            }
            catch (NumberFormatException ex) {
                this.x = null;
                if ("-".equals(n) || "+".equals(n) || "".equals(n)) break block3;
                this.xValue.setText(o);
            }
        }
        this.setValue();
    }

    private void onZInput(String o, String n) {
        block3: {
            if (this.emptyIsZero && (n.isEmpty() || "-".equals(n) || "+".equals(n))) {
                this.z = 0;
                this.setValue();
                return;
            }
            try {
                this.z = Integer.parseInt(n);
            }
            catch (NumberFormatException ex) {
                this.z = null;
                if ("-".equals(n) || "+".equals(n) || "".equals(n)) break block3;
                this.zValue.setText(o);
            }
        }
        this.setValue();
    }

    public Point2i getValue() {
        return this.value;
    }

    public void setOnValidityCheck(Consumer<Boolean> action) {
        this.validityCheckAction = action;
    }

    private void setValue() {
        if (this.x == null || this.z == null) {
            this.value = null;
            if (this.validityCheckAction != null) {
                this.validityCheckAction.accept(false);
            }
        } else {
            this.value = new Point2i(this.x, this.z);
            if (this.validityCheckAction != null) {
                this.validityCheckAction.accept(true);
            }
        }
    }
}

