/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CollectionTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.FloatTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.NumberTag;
import net.querz.nbt.ShortTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;

public class NBTTreeView
extends TreeView<NamedTag> {
    private ScrollBar verticalScrollBar = null;
    private NBTTreeItem dragItem;
    private Rectangle dropHighlight = null;
    private static final String dropHighlightCssClass = "drop-highlight";
    private NBTTreeItem dropTarget = null;
    private int dropTargetIndex = 0;
    private Tag copyItem;
    private String copyName;
    private Function<Object, Optional<EditArrayResult>> arrayEditor = null;

    public NBTTreeView() {
        this.getStyleClass().add((Object)"nbt-tree-view");
        this.getStylesheets().add((Object)Objects.requireNonNull(NBTTreeView.class.getClassLoader().getResource("style/component/nbt-tree-view.css")).toExternalForm());
        this.setCellFactory(tv -> new NBTTreeCell());
        this.setEditable(true);
        this.setOnKeyPressed(this::onKeyPressed);
    }

    public void load(CompoundTag root) {
        super.setRoot((TreeItem)this.toTreeItem(0, null, root, null));
        this.getRoot().setExpanded(true);
    }

    public void setArrayEditor(Function<Object, Optional<EditArrayResult>> arrayEditor) {
        this.arrayEditor = arrayEditor;
    }

    public void setOnSelectionChanged(Consumer<Boolean> onSelectionChanged) {
        this.getSelectionModel().selectedItemProperty().addListener((i, o, n) -> onSelectionChanged.accept(n == null));
    }

    public void deleteSelectedItem() {
        NBTTreeItem selectedItem = (NBTTreeItem)((Object)this.getSelectionModel().getSelectedItem());
        if (selectedItem.getParent() == null) {
            this.setRoot(null);
        } else {
            NBTTreeItem oldParent = (NBTTreeItem)selectedItem.getParent();
            if (((NamedTag)selectedItem.getValue()).parent.getType() == Tag.Type.COMPOUND) {
                ((CompoundTag)((NamedTag)selectedItem.getValue()).parent).remove(((NamedTag)selectedItem.getValue()).name);
                oldParent.getChildren().remove((Object)selectedItem);
            } else if (((NamedTag)selectedItem.getValue()).parent.getType() == Tag.Type.LIST) {
                ((ListTag)((NamedTag)selectedItem.getValue()).parent).remove(((NamedTag)selectedItem.getValue()).index);
                oldParent.getChildren().remove(((NamedTag)selectedItem.getValue()).index);
                oldParent.updateIndexes();
            }
        }
    }

    public boolean addItemAtSelected(String name, Tag tag, boolean forceEdit) {
        if (tag.getType() == Tag.Type.END) {
            return false;
        }
        if (this.getRoot() == null) {
            if (tag.getType() == Tag.Type.COMPOUND) {
                this.load((CompoundTag)tag);
                this.layout();
                this.getSelectionModel().select(0);
                return true;
            }
            return false;
        }
        NBTTreeItem target = (NBTTreeItem)((Object)this.getSelectionModel().getSelectedItem());
        NBTTreeItem newItem = null;
        if (((NamedTag)target.getValue()).ref.getType() == Tag.Type.LIST) {
            ListTag list = (ListTag)((NamedTag)target.getValue()).ref;
            if (list.getElementType() == null || list.getElementType() == tag.getType()) {
                list.addLast(tag);
                target.setExpanded(true);
                newItem = this.toTreeItem(list.size() - 1, null, tag, list);
                target.getChildren().addLast((Object)newItem);
            }
        } else if (((NamedTag)target.getValue()).ref.getType() == Tag.Type.COMPOUND) {
            newItem = this.toTreeItem(0, null, tag, ((NamedTag)target.getValue()).ref);
            ((NamedTag)newItem.getValue()).nextPossibleName((CompoundTag)((NamedTag)target.getValue()).ref, name);
            ((CompoundTag)((NamedTag)target.getValue()).ref).put(((NamedTag)newItem.getValue()).name, tag);
            target.setExpanded(true);
            target.getChildren().add((Object)newItem);
        } else if (((NamedTag)target.getValue()).parent.getType() == Tag.Type.LIST) {
            ListTag list = (ListTag)((NamedTag)target.getValue()).parent;
            if (list.getElementType() == null || list.getElementType() == tag.getType()) {
                int index = ((NamedTag)target.getValue()).index + 1;
                list.add(index, tag);
                newItem = this.toTreeItem(index, null, tag, list);
                target.getParent().getChildren().add(index, (Object)newItem);
                ((NBTTreeItem)target.getParent()).updateIndexes();
            }
        } else if (((NamedTag)target.getValue()).parent.getType() == Tag.Type.COMPOUND) {
            newItem = this.toTreeItem(0, null, tag, ((NamedTag)target.getValue()).parent);
            ((NamedTag)newItem.getValue()).nextPossibleName((CompoundTag)((NamedTag)target.getValue()).parent, name);
            ((CompoundTag)((NamedTag)target.getValue()).parent).put(((NamedTag)newItem.getValue()).name, tag);
            target.getParent().getChildren().add((Object)newItem);
        }
        if (newItem == null) {
            return false;
        }
        this.requestFocus();
        this.layout();
        this.getSelectionModel().select((Object)newItem);
        if (!((NBTTreeItem)((Object)this.getSelectionModel().getSelectedItem())).isVisibleOnScreen()) {
            this.scrollTo(this.getSelectionModel().getSelectedIndex());
        }
        this.layout();
        if ((((NamedTag)target.getValue()).ref.getType() == Tag.Type.LIST && !((NamedTag)newItem.getValue()).isContainerType() || ((NamedTag)target.getValue()).ref.getType() == Tag.Type.COMPOUND || !((NamedTag)target.getValue()).isContainerType() && ((NamedTag)target.getValue()).parent != null && (((NamedTag)target.getValue()).parent.getType() == Tag.Type.COMPOUND || ((NamedTag)target.getValue()).parent.getType() == Tag.Type.LIST && !((NamedTag)newItem.getValue()).isContainerType())) && (forceEdit || ((NamedTag)newItem.getValue()).name != null && !name.equals(((NamedTag)newItem.getValue()).name))) {
            this.edit(newItem);
        }
        return true;
    }

    public Tag.Type[] getPossibleChildTagTypesFromSelected() {
        Tag.Type elementType;
        NBTTreeItem target = (NBTTreeItem)((Object)this.getSelectionModel().getSelectedItem());
        if (target == null) {
            if (this.getRoot() == null) {
                return new Tag.Type[]{Tag.Type.COMPOUND};
            }
            return new Tag.Type[0];
        }
        if (((NamedTag)target.getValue()).ref.getType() == Tag.Type.LIST && (elementType = ((ListTag)((NamedTag)target.getValue()).ref).getElementType()) != null) {
            return new Tag.Type[]{elementType};
        }
        if (!((NamedTag)target.getValue()).isContainerType() && ((NamedTag)target.getValue()).parent.getType() == Tag.Type.LIST && (elementType = ((ListTag)((NamedTag)target.getValue()).parent).getElementType()) != null) {
            return new Tag.Type[]{elementType};
        }
        return new Tag.Type[]{Tag.Type.BYTE, Tag.Type.SHORT, Tag.Type.INT, Tag.Type.LONG, Tag.Type.FLOAT, Tag.Type.DOUBLE, Tag.Type.BYTE_ARRAY, Tag.Type.STRING, Tag.Type.LIST, Tag.Type.COMPOUND, Tag.Type.INT_ARRAY, Tag.Type.LONG_ARRAY};
    }

    private NBTTreeItem toTreeItem(int index, String name, Tag ref, Tag parent) {
        switch (ref.getType()) {
            case END: {
                throw new IllegalArgumentException("NBTTreeItem does not support END tag");
            }
            case LIST: {
                NBTTreeItem item = new NBTTreeItem(new NamedTag(index, name, ref, parent));
                ListTag list = (ListTag)ref;
                for (int i = 0; i < list.size(); ++i) {
                    item.getChildren().add((Object)this.toTreeItem(i, null, list.get(i), ref));
                }
                return item;
            }
            case COMPOUND: {
                NBTTreeItem item = new NBTTreeItem(new NamedTag(index, name, ref, parent));
                for (Map.Entry<String, Tag> child : (CompoundTag)ref) {
                    item.getChildren().add((Object)this.toTreeItem(0, child.getKey(), child.getValue(), ref));
                }
                return item;
            }
        }
        return new NBTTreeItem(new NamedTag(index, name, ref, parent));
    }

    private void onKeyPressed(KeyEvent e) {
        switch (e.getCode()) {
            case C: {
                if (!e.isShortcutDown()) break;
                this.copySelectedItem();
                break;
            }
            case V: {
                if (!e.isShortcutDown()) break;
            }
            case INSERT: {
                if (this.copyItem == null) break;
                this.addItemAtSelected(this.copyName == null ? "Unknown" : this.copyName, this.copyItem, false);
                break;
            }
            case X: {
                if (e.isShortcutDown()) {
                    this.copySelectedItem();
                }
            }
            case DELETE: {
                this.deleteSelectedItem();
            }
        }
    }

    private void copySelectedItem() {
        NBTTreeItem item = (NBTTreeItem)((Object)this.getSelectionModel().getSelectedItem());
        if (item != null) {
            this.copyItem = ((NamedTag)item.getValue()).ref.copy();
            this.copyName = ((NamedTag)item.getValue()).name;
        }
    }

    class NBTTreeItem
    extends TreeItem<NamedTag> {
        private static final DataFormat clipboardDataformat = new DataFormat(new String[]{"nbt-tree-item"});

        public NBTTreeItem(NamedTag tag) {
            super((Object)tag);
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean isLast() {
            if (this.getParent() == null) {
                return true;
            }
            ObservableList items = this.getParent().getChildren();
            return this == this.getParent().getChildren().get(items.size() - 1);
        }

        public int countExpandedItems() {
            if (!this.isExpanded()) {
                return 1;
            }
            int count = 1;
            for (TreeItem child : this.getChildren()) {
                count += ((NBTTreeItem)child).countExpandedItems();
            }
            return count;
        }

        public int getIndexInExpandedHierarchy(NBTTreeItem parent) {
            int count = 0;
            for (NBTTreeItem current = this; current != null && current != parent; current = current.getParent()) {
                for (int i = current.getParent().getChildren().indexOf((Object)current); i >= 0; --i) {
                    TreeItem sibling = (TreeItem)current.getParent().getChildren().get(i);
                    count += ((NBTTreeItem)sibling).countExpandedItems();
                }
            }
            return count;
        }

        public void updateIndexes() {
            if (((NamedTag)this.getValue()).ref.getType() != Tag.Type.LIST) {
                return;
            }
            int i = 0;
            for (TreeItem child : this.getChildren()) {
                ((NamedTag)child.getValue()).index = i++;
            }
        }

        public void moveHere(NBTTreeItem source, int dropTargetIndex) {
            NBTTreeItem oldParent = (NBTTreeItem)source.getParent();
            int oldIndex = source.getParent().getChildren().indexOf((Object)source);
            source.getParent().getChildren().remove(oldIndex);
            String oldName = ((NamedTag)source.getValue()).name;
            oldParent.updateIndexes();
            if (oldParent == this && oldIndex < dropTargetIndex) {
                --dropTargetIndex;
            }
            this.getChildren().add(dropTargetIndex >= 0 ? dropTargetIndex : this.getChildren().size(), (Object)source);
            boolean startEdit = false;
            if (((NamedTag)this.getValue()).ref.getType() == Tag.Type.LIST) {
                ((NamedTag)source.getValue()).name = null;
            } else if (((NamedTag)this.getValue()).ref.getType() == Tag.Type.COMPOUND && ((NamedTag)source.getValue()).name == null) {
                ((NamedTag)source.getValue()).nextPossibleName((CompoundTag)((NamedTag)this.getValue()).ref, "Unknown");
                startEdit = true;
            } else {
                startEdit = ((NamedTag)source.getValue()).nextPossibleName((CompoundTag)((NamedTag)this.getValue()).ref, ((NamedTag)source.getValue()).name);
            }
            if (((NamedTag)source.getValue()).parent.getType() == Tag.Type.LIST) {
                ((ListTag)((NamedTag)source.getValue()).parent).remove(((NamedTag)source.getValue()).ref);
            } else if (((NamedTag)source.getValue()).parent.getType() == Tag.Type.COMPOUND) {
                ((CompoundTag)((NamedTag)source.getValue()).parent).remove(oldName);
            }
            ((NamedTag)source.getValue()).parent = ((NamedTag)this.getValue()).ref;
            if (((NamedTag)this.getValue()).ref.getType() == Tag.Type.LIST) {
                ((ListTag)((NamedTag)this.getValue()).ref).add(dropTargetIndex, ((NamedTag)source.getValue()).ref);
                this.updateIndexes();
            } else if (((NamedTag)this.getValue()).ref.getType() == Tag.Type.COMPOUND) {
                ((CompoundTag)((NamedTag)this.getValue()).ref).put(((NamedTag)source.getValue()).name, ((NamedTag)source.getValue()).ref);
                ((NamedTag)source.getValue()).index = 0;
            }
            if (startEdit) {
                NBTTreeView.this.layout();
                NBTTreeView.this.scrollTo(NBTTreeView.this.getRow(source));
                NBTTreeView.this.getSelectionModel().select((Object)source);
                Platform.runLater(() -> NBTTreeView.this.edit(source));
            }
        }

        public boolean isVisibleOnScreen() {
            Set treeCells = NBTTreeView.this.lookupAll(".tree-cell");
            for (Node treeCell : treeCells) {
                if (((NBTTreeCell)treeCell).getTreeItem() != this) continue;
                return true;
            }
            return false;
        }
    }

    public static class NamedTag
    implements Serializable {
        private int index;
        private String name;
        private Tag ref;
        private Tag parent;

        public NamedTag(int index, String name, Tag ref, Tag parent) {
            this.index = index;
            this.name = name;
            this.ref = ref;
            this.parent = parent;
        }

        public Tag getRef() {
            return this.ref;
        }

        public boolean updateValue(String raw) {
            try {
                Consumer<Tag> c = t -> {
                    switch (this.parent.getType()) {
                        case COMPOUND: {
                            ((CompoundTag)this.parent).put(this.name, (Tag)t);
                            break;
                        }
                        case LIST: {
                            ((ListTag)this.parent).set(this.index, (Tag)t);
                        }
                    }
                    this.ref = t;
                };
                switch (this.ref.getType()) {
                    case BYTE: {
                        c.accept(ByteTag.valueOf(Byte.parseByte(raw)));
                        break;
                    }
                    case SHORT: {
                        c.accept(ShortTag.valueOf(Short.parseShort(raw)));
                        break;
                    }
                    case INT: {
                        c.accept(IntTag.valueOf(Integer.parseInt(raw)));
                        break;
                    }
                    case LONG: {
                        c.accept(LongTag.valueOf(Long.parseLong(raw)));
                        break;
                    }
                    case FLOAT: {
                        c.accept(FloatTag.valueOf(Float.parseFloat(raw)));
                        break;
                    }
                    case DOUBLE: {
                        c.accept(DoubleTag.valueOf(Double.parseDouble(raw)));
                        break;
                    }
                    case STRING: {
                        c.accept(StringTag.valueOf(raw));
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public boolean isArrayType() {
            return this.ref.getType() == Tag.Type.BYTE_ARRAY || this.ref.getType() == Tag.Type.INT_ARRAY || this.ref.getType() == Tag.Type.LONG_ARRAY;
        }

        public boolean isContainerType() {
            return this.ref.getType() == Tag.Type.COMPOUND || this.ref.getType() == Tag.Type.LIST;
        }

        public boolean isEmptyContainerType() {
            return this.ref.getType() == Tag.Type.COMPOUND && ((CompoundTag)this.ref).isEmpty() || this.ref.getType() == Tag.Type.LIST && ((ListTag)this.ref).isEmpty();
        }

        public boolean isNonEmptyContainerType() {
            return this.ref.getType() == Tag.Type.COMPOUND && !((CompoundTag)this.ref).isEmpty() || this.ref.getType() == Tag.Type.LIST && !((ListTag)this.ref).isEmpty();
        }

        public boolean isNumericType() {
            return this.ref.getType().isNumber;
        }

        public String getLabelString() {
            return switch (this.ref.getType()) {
                case Tag.Type.BYTE, Tag.Type.SHORT, Tag.Type.INT, Tag.Type.LONG, Tag.Type.FLOAT, Tag.Type.DOUBLE, Tag.Type.STRING -> (String)(this.name == null ? "" : this.name + ": ") + this.valueToString();
                case Tag.Type.LIST, Tag.Type.BYTE_ARRAY, Tag.Type.INT_ARRAY, Tag.Type.LONG_ARRAY -> (String)(this.name == null ? "(" : this.name + " (") + ((CollectionTag)this.ref).size() + ")";
                case Tag.Type.COMPOUND -> (String)(this.name == null ? "(" : this.name + " (") + ((CompoundTag)this.ref).size() + ")";
                default -> null;
            };
        }

        public String valueToString() {
            return switch (this.ref.getType()) {
                case Tag.Type.BYTE, Tag.Type.SHORT, Tag.Type.INT, Tag.Type.LONG, Tag.Type.FLOAT, Tag.Type.DOUBLE -> ((NumberTag)this.ref).asNumber().toString();
                case Tag.Type.STRING -> ((StringTag)this.ref).getValue();
                default -> null;
            };
        }

        public boolean nextPossibleName(CompoundTag target, String name) {
            if (target.containsKey(name)) {
                String numName;
                int num = 1;
                while (target.containsKey(numName = name + num)) {
                    ++num;
                }
                this.name = numName;
                return true;
            }
            this.name = name;
            return false;
        }

        public Object getArray() {
            return switch (this.ref.getType()) {
                case Tag.Type.BYTE_ARRAY -> ((ByteArrayTag)this.ref).getValue();
                case Tag.Type.INT_ARRAY -> (Object[])((IntArrayTag)this.ref).getValue();
                case Tag.Type.LONG_ARRAY -> (Object[])((LongArrayTag)this.ref).getValue();
                default -> throw new IllegalStateException("not an array tag: " + String.valueOf((Object)this.ref.getType()));
            };
        }

        public void setArray(Object array) {
            switch (this.ref.getType()) {
                case BYTE_ARRAY: {
                    ((ByteArrayTag)this.ref).setValue((byte[])array);
                    break;
                }
                case INT_ARRAY: {
                    ((IntArrayTag)this.ref).setValue((int[])array);
                    break;
                }
                case LONG_ARRAY: {
                    ((LongArrayTag)this.ref).setValue((long[])array);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("incompatible array types: " + String.valueOf((Object)this.ref.getType()) + " and " + String.valueOf(array.getClass()));
                }
            }
        }

        public String toString() {
            return String.format("index=%d, name=%s, ref=%s, parent=%s", new Object[]{this.index, this.name, this.ref.getType(), this.parent == null ? null : this.parent.getType()});
        }
    }

    public class NBTTreeCell
    extends TreeCell<NamedTag> {
        private HBox box;
        private TextField name;
        private TextField value;
        private Button edit;
        private static final boolean noDragviewOffset = System.getProperty("os.name").toLowerCase().contains("win");
        private static final String nameFieldCssClass = "name-text-field";
        private static final String valueFieldCssClass = "value-text-field";
        private static final String editButtonCssClass = "edit-button";
        private static final String expandDisclosureNodeCssClass = "expand";
        private static final String expandSquareDisclosureNodeCssClass = "expand-square";
        private static final Image[] icons = new Image[13];

        public NBTTreeCell() {
            this.getStyleClass().add((Object)"nbt-tree-cell");
            this.setOnDragDetected(this::onDragDetected);
            this.setOnDragOver(this::onDragOver);
            this.setOnDragEntered(this::onDragOver);
            this.setOnDragDropped(this::onDragDropped);
            this.setOnDragExited(this::onDragExited);
            this.setOnDragDone(this::onDragDone);
        }

        public static Image getIcon(Tag.Type type) {
            return icons[type.id];
        }

        public void startEdit() {
            if (!this.isEditable() || !this.getTreeView().isEditable()) {
                return;
            }
            super.startEdit();
            if (!this.isEditing()) {
                return;
            }
            if (this.box == null) {
                this.box = new HBox();
                this.box.setAlignment(Pos.CENTER_LEFT);
            }
            TextField focus = null;
            if (((NamedTag)this.getItem()).parent.getType() == Tag.Type.COMPOUND) {
                if (((NamedTag)this.getItem()).isArrayType()) {
                    Object[] objectArray = new Node[3];
                    objectArray[0] = this.getGraphic();
                    focus = this.nameField();
                    objectArray[1] = focus;
                    objectArray[2] = this.editButton();
                    this.box.getChildren().setAll(objectArray);
                } else if (((NamedTag)this.getItem()).isContainerType()) {
                    Object[] objectArray = new Node[2];
                    objectArray[0] = this.getGraphic();
                    focus = this.nameField();
                    objectArray[1] = focus;
                    this.box.getChildren().setAll(objectArray);
                } else {
                    Object[] objectArray = new Node[3];
                    objectArray[0] = this.getGraphic();
                    focus = this.nameField();
                    objectArray[1] = focus;
                    objectArray[2] = this.valueField();
                    this.box.getChildren().setAll(objectArray);
                }
            } else if (((NamedTag)this.getItem()).parent.getType() == Tag.Type.LIST) {
                if (((NamedTag)this.getItem()).isArrayType()) {
                    this.box.getChildren().setAll((Object[])new Node[]{this.getGraphic(), this.editButton()});
                } else if (!((NamedTag)this.getItem()).isContainerType()) {
                    Object[] objectArray = new Node[2];
                    objectArray[0] = this.getGraphic();
                    focus = this.valueField();
                    objectArray[1] = focus;
                    this.box.getChildren().setAll(objectArray);
                } else {
                    return;
                }
            }
            this.setGraphic((Node)this.box);
            this.setText(null);
            if (focus != null) {
                focus.requestFocus();
                focus.selectAll();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText(((NamedTag)this.getItem()).getLabelString());
            if (!this.box.getChildren().isEmpty()) {
                this.setGraphic((Node)this.box.getChildren().getFirst());
            }
        }

        public void commitEdit(NamedTag tag) {
            if (((NamedTag)this.getItem()).parent.getType() == Tag.Type.COMPOUND && this.name != null && this.name.getText() != null) {
                CompoundTag parent = (CompoundTag)tag.parent;
                if (parent.containsKey(this.name.getText()) && !this.name.getText().equals(tag.name)) {
                    return;
                }
                parent.remove(tag.name);
                parent.put(this.name.getText(), tag.ref);
                tag.name = this.name.getText();
            }
            if (this.value != null && this.value.getText() != null && !tag.updateValue(this.value.getText())) {
                this.value.setText(tag.valueToString());
            }
            super.commitEdit((Object)tag);
        }

        public void updateItem(NamedTag tag, boolean empty) {
            super.updateItem((Object)tag, empty);
            this.setDisclosureNode(null);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                return;
            }
            ImageView icon = new ImageView(icons[tag.ref.getType().id]);
            this.setGraphic((Node)icon);
            this.setText(tag.getLabelString());
            StackPane s = new StackPane();
            Region r = new Region();
            r.setPrefSize(11.0, 11.0);
            this.setMaxSize(11.0, 11.0);
            s.getChildren().add((Object)r);
            if (tag.isNonEmptyContainerType()) {
                r.getStyleClass().add((Object)expandSquareDisclosureNodeCssClass);
                s.getChildren().addAll((Object[])new Node[]{this.horizontal(2.0, 5.0, 7.0, expandDisclosureNodeCssClass), this.horizontal(11.0, 5.0, 3.0, new String[0])});
                if (!this.getTreeItem().isExpanded()) {
                    s.getChildren().add((Object)this.vertical(5.0, 2.0, 7.0, expandDisclosureNodeCssClass));
                    if (!((NBTTreeItem)this.getTreeItem()).isLast()) {
                        s.getChildren().add((Object)this.vertical(5.0, 11.0, 10.0, new String[0]));
                    }
                }
                if (this.getTreeItem().getParent() != null) {
                    s.getChildren().add((Object)this.vertical(5.0, -9.0, 10.0, new String[0]));
                }
            } else {
                s.getChildren().add((Object)this.horizontal(5.0, 5.0, 8.0, new String[0]));
                if (((NBTTreeItem)this.getTreeItem()).isLast()) {
                    s.getChildren().add((Object)this.vertical(5.0, -9.0, 15.0, new String[0]));
                } else {
                    s.getChildren().addAll((Object[])new Node[]{this.vertical(5.0, -9.0, 15.0, new String[0]), this.vertical(5.0, 5.0, 16.0, new String[0])});
                }
            }
            s.setAlignment(Pos.TOP_LEFT);
            StackPane disclosureNode = new StackPane(new Node[]{s});
            disclosureNode.getStyleClass().add((Object)"tree-disclosure-node");
            this.setDisclosureNode((Node)disclosureNode);
            this.setEditable(!tag.isRoot());
        }

        private Line horizontal(double tX, double tY, double length, String ... id) {
            Line l = new Line(0.0, 0.0, length - 1.0, 0.0);
            l.setTranslateX(tX);
            l.setTranslateY(tY);
            l.getStyleClass().addAll((Object[])id);
            return l;
        }

        private Line vertical(double tX, double tY, double length, String ... id) {
            Line l = new Line(0.0, 0.0, 0.0, length - 1.0);
            l.setTranslateX(tX);
            l.setTranslateY(tY);
            l.getStyleClass().addAll((Object[])id);
            return l;
        }

        private TextField nameField() {
            if (this.name == null) {
                this.name = new TextField();
                this.name.getStyleClass().add((Object)nameFieldCssClass);
                HBox.setHgrow((Node)this.name, (Priority)Priority.ALWAYS);
                this.name.setOnKeyPressed(this::onKeyPressed);
            }
            this.name.setText(((NamedTag)this.getItem()).name);
            return this.name;
        }

        private TextField valueField() {
            if (this.value == null) {
                this.value = new TextField();
                this.value.getStyleClass().add((Object)valueFieldCssClass);
                HBox.setHgrow((Node)this.value, (Priority)Priority.ALWAYS);
                this.value.setOnKeyPressed(this::onKeyPressed);
            }
            this.value.setText(((NamedTag)this.getItem()).valueToString());
            return this.value;
        }

        private Button editButton() {
            if (this.edit == null) {
                this.edit = new Button("edit");
                this.edit.getStyleClass().add((Object)editButtonCssClass);
            }
            this.edit.setOnAction(e -> {
                if (NBTTreeView.this.arrayEditor != null) {
                    Optional<EditArrayResult> result = NBTTreeView.this.arrayEditor.apply(((NamedTag)this.getItem()).getArray());
                    result.ifPresent(r -> ((NamedTag)this.getItem()).setArray(r.data));
                }
            });
            return this.edit;
        }

        private void onKeyPressed(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER && this.isEditing()) {
                this.commitEdit((NamedTag)this.getItem());
                this.updateItem((NamedTag)this.getItem(), false);
                event.consume();
            }
        }

        private void onDragDetected(MouseEvent event) {
            if (this.getItem() == null || ((NamedTag)this.getItem()).isRoot()) {
                return;
            }
            Dragboard dragboard = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            WritableImage writableImage = new WritableImage((int)this.getWidth(), (int)this.getHeight());
            WritableImage image = this.snapshot(null, writableImage);
            dragboard.setDragView((Image)image);
            double dX = (noDragviewOffset ? 0.0 : -this.getWidth() * 0.5) + event.getX();
            double dY = (noDragviewOffset ? 0.0 : -this.getHeight() * 0.5) + event.getY();
            dragboard.setDragViewOffsetX(Math.max(0.0, Math.min(this.getWidth(), dX)));
            dragboard.setDragViewOffsetY(Math.max(0.0, Math.min(this.getHeight(), dY)));
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.put((Object)NBTTreeItem.clipboardDataformat, (Object)true);
            dragboard.setContent((Map)clipboardContent);
            NBTTreeView.this.dragItem = (NBTTreeItem)this.getTreeItem();
            event.consume();
        }

        private void onDragOver(DragEvent event) {
            boolean scrollDown;
            if (!event.getDragboard().hasContent(NBTTreeItem.clipboardDataformat)) {
                event.consume();
                return;
            }
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            double minScreenY = this.getTreeView().localToScreen(this.getTreeView().getBoundsInLocal()).getMinY();
            boolean scrollUp = event.getScreenY() < minScreenY + 30.0;
            boolean bl = scrollDown = event.getScreenY() > minScreenY + this.getTreeView().getHeight() - 30.0;
            if (scrollUp || scrollDown) {
                if (NBTTreeView.this.verticalScrollBar == null) {
                    NBTTreeView.this.verticalScrollBar = (ScrollBar)this.getTreeView().lookup(".scroll-bar:vertical");
                }
                double offset = scrollUp ? -0.02 : 0.02;
                NBTTreeView.this.verticalScrollBar.setValue(Math.min(NBTTreeView.this.verticalScrollBar.getValue() + offset, NBTTreeView.this.verticalScrollBar.getMax()));
            }
            this.clearDropTarget();
            if (this.getTreeItem() == null || this.isInHierarchy(NBTTreeView.this.dragItem) || ((NamedTag)this.getItem()).ref == ((NamedTag)NBTTreeView.this.dragItem.getValue()).parent) {
                event.consume();
                return;
            }
            if (!((NamedTag)this.getItem()).isRoot() && !((NamedTag)this.getItem()).isContainerType() && ((NamedTag)this.getItem()).parent.getType() == Tag.Type.COMPOUND && ((NamedTag)this.getItem()).parent == ((NamedTag)NBTTreeView.this.dragItem.getValue()).parent) {
                event.consume();
                return;
            }
            if (((NamedTag)this.getItem()).ref.getType() == Tag.Type.LIST && ((ListTag)((NamedTag)this.getItem()).ref).getElementType() != null && ((ListTag)((NamedTag)this.getItem()).ref).getElementType() != ((NamedTag)NBTTreeView.this.dragItem.getValue()).ref.getType()) {
                event.consume();
                return;
            }
            boolean flag = true;
            if (!((NamedTag)this.getItem()).isRoot() && ((NamedTag)this.getItem()).parent.getType() == Tag.Type.LIST) {
                flag = false;
                if (((ListTag)((NamedTag)this.getItem()).parent).getElementType() != ((NamedTag)NBTTreeView.this.dragItem.getValue()).ref.getType()) {
                    flag = true;
                } else if (event.getY() > this.getHeight() * 0.75) {
                    this.dragHighlight((NBTTreeItem)this.getTreeItem(), 1);
                    NBTTreeView.this.dropTarget = (NBTTreeItem)this.getTreeItem().getParent();
                    NBTTreeView.this.dropTargetIndex = ((NamedTag)this.getItem()).index + 1;
                } else if (event.getY() < this.getHeight() * 0.25) {
                    this.dragHighlight((NBTTreeItem)this.getTreeItem(), -1);
                    NBTTreeView.this.dropTarget = (NBTTreeItem)this.getTreeItem().getParent();
                    NBTTreeView.this.dropTargetIndex = ((NamedTag)this.getItem()).index;
                } else {
                    flag = true;
                }
            }
            if (flag && ((NamedTag)this.getItem()).isContainerType()) {
                this.dragHighlight((NBTTreeItem)this.getTreeItem(), 0);
                NBTTreeView.this.dropTarget = (NBTTreeItem)this.getTreeItem();
                if (((NamedTag)this.getItem()).ref.getType() == Tag.Type.LIST) {
                    NBTTreeView.this.dropTargetIndex = ((ListTag)((NamedTag)this.getItem()).ref).size();
                }
            } else if (((NamedTag)this.getItem()).parent.getType() == Tag.Type.COMPOUND && !((NamedTag)this.getItem()).isContainerType()) {
                this.dragHighlight((NBTTreeItem)this.getTreeItem().getParent(), 0);
                NBTTreeView.this.dropTarget = (NBTTreeItem)this.getTreeItem().getParent();
            }
        }

        private void onDragDropped(DragEvent event) {
            Dragboard dragboard = event.getDragboard();
            if (!dragboard.hasContent(NBTTreeItem.clipboardDataformat)) {
                event.consume();
                return;
            }
            if (NBTTreeView.this.dropTarget == null) {
                event.consume();
                return;
            }
            NBTTreeView.this.dropTarget.moveHere(NBTTreeView.this.dragItem, NBTTreeView.this.dropTargetIndex);
            this.clearDropTarget();
        }

        private void onDragExited(DragEvent event) {
            this.clearDropTarget();
        }

        private void onDragDone(DragEvent event) {
            if (event.getDragboard().hasContent(NBTTreeItem.clipboardDataformat)) {
                NBTTreeView.this.dragItem = null;
                this.clearDropTarget();
            }
        }

        private void clearDropTarget() {
            if (NBTTreeView.this.dropHighlight != null) {
                ((Group)this.getParent()).getChildren().remove((Object)NBTTreeView.this.dropHighlight);
            }
            NBTTreeView.this.dropTarget = null;
            NBTTreeView.this.dropTargetIndex = -1;
        }

        private void dragHighlight(NBTTreeItem item, int offset) {
            double yLoc = this.getLayoutY();
            yLoc = offset > 0 ? (yLoc += this.getHeight() * 0.5) : (offset < 0 ? (yLoc -= this.getHeight() * 0.5) : (yLoc -= (double)((NBTTreeItem)this.getTreeItem()).getIndexInExpandedHierarchy(item) * this.getHeight()));
            double height = (double)item.countExpandedItems() * this.getHeight();
            NBTTreeView.this.dropHighlight = new Rectangle(this.getLayoutX(), yLoc, this.getWidth(), height);
            NBTTreeView.this.dropHighlight.getStyleClass().add((Object)NBTTreeView.dropHighlightCssClass);
            ((Group)this.getParent()).getChildren().addFirst((Object)NBTTreeView.this.dropHighlight);
        }

        private boolean isInHierarchy(NBTTreeItem source) {
            for (TreeItem current = this.getTreeItem(); current != null; current = current.getParent()) {
                if (source != current) continue;
                return true;
            }
            return false;
        }

        static {
            ClassLoader cl = NBTTreeCell.class.getClassLoader();
            Function<String, Image> f = s -> new Image(Objects.requireNonNull(cl.getResourceAsStream((String)s)));
            NBTTreeCell.icons[Tag.Type.BYTE.id] = f.apply("img/nbt/byte.png");
            NBTTreeCell.icons[Tag.Type.SHORT.id] = f.apply("img/nbt/short.png");
            NBTTreeCell.icons[Tag.Type.INT.id] = f.apply("img/nbt/int.png");
            NBTTreeCell.icons[Tag.Type.LONG.id] = f.apply("img/nbt/long.png");
            NBTTreeCell.icons[Tag.Type.FLOAT.id] = f.apply("img/nbt/float.png");
            NBTTreeCell.icons[Tag.Type.DOUBLE.id] = f.apply("img/nbt/double.png");
            NBTTreeCell.icons[Tag.Type.STRING.id] = f.apply("img/nbt/string.png");
            NBTTreeCell.icons[Tag.Type.LIST.id] = f.apply("img/nbt/list.png");
            NBTTreeCell.icons[Tag.Type.COMPOUND.id] = f.apply("img/nbt/compound.png");
            NBTTreeCell.icons[Tag.Type.BYTE_ARRAY.id] = f.apply("img/nbt/byte_array.png");
            NBTTreeCell.icons[Tag.Type.INT_ARRAY.id] = f.apply("img/nbt/int_array.png");
            NBTTreeCell.icons[Tag.Type.LONG_ARRAY.id] = f.apply("img/nbt/long_array.png");
        }
    }

    public record EditArrayResult(Object data) {
    }
}

