/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.scene.input.ScrollEvent;

public class NumberTextField
extends TextField {
    private final LongProperty valueProperty = new SimpleLongProperty();
    private EventHandler<? super ScrollEvent> onScroll;

    public NumberTextField(long min, long max) {
        this.textProperty().addListener((v, o, n) -> {
            if (!n.matches("-?\\d*")) {
                this.setText(n.replaceAll("[^\\-\\d]", ""));
            } else if (n.isEmpty()) {
                this.valueProperty.set(0L);
            } else {
                try {
                    long value = Integer.parseInt(n);
                    if (value < min) {
                        value = min;
                    } else if (value > max) {
                        value = max;
                    }
                    this.valueProperty.set(value);
                    this.setText("" + value);
                }
                catch (NumberFormatException ex) {
                    this.valueProperty.set(0L);
                }
            }
        });
        this.setOnScroll(e -> {
            if (e.getDeltaY() > 0.0) {
                this.setText("" + this.incrementAndGet(1L));
            } else if (e.getDeltaY() < 0.0) {
                this.setText("" + this.incrementAndGet(-1L));
            }
            if (this.onScroll != null) {
                this.onScroll.handle(e);
            }
        });
        this.valueProperty.addListener((v, o, n) -> {
            if (n.intValue() == 0) {
                this.setText("");
            } else {
                this.setText(String.valueOf(n));
            }
        });
    }

    public void setOnScrollEvent(EventHandler<? super ScrollEvent> value) {
        this.onScroll = value;
    }

    private long incrementAndGet(long inc) {
        long newValue = this.valueProperty.get() + inc;
        this.valueProperty.set(newValue);
        return newValue;
    }

    public LongProperty valueProperty() {
        return this.valueProperty;
    }

    public long getValue() {
        return this.valueProperty.get();
    }
}

