/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import net.querz.mcaselector.util.point.Point2f;

public class RangeSlider
extends Pane {
    private final Pane lowerThumb = new Pane();
    private final Pane upperThumb = new Pane();
    private final Pane range = new Pane();
    private final DoubleProperty minProperty = new SimpleDoubleProperty();
    private final DoubleProperty maxProperty = new SimpleDoubleProperty();
    private final DoubleProperty lowProperty = new SimpleDoubleProperty();
    private final DoubleProperty highProperty = new SimpleDoubleProperty();
    private Point2f previousMouseLocation;
    private Pane pressedPane;

    public RangeSlider(double min, double max, double low, double high) {
        if (min < 0.0) {
            this.setMin(min);
            this.setMax(max);
        } else {
            this.setMax(max);
            this.setMin(min);
        }
        if (low < 0.0) {
            this.setLow(low);
            this.setHigh(high);
        } else {
            this.setHigh(high);
            this.setLow(low);
        }
        this.setOnMousePressed(this::onMousePressed);
        this.setOnMouseReleased(this::onMouseReleased);
        this.setOnMouseDragged(this::onMouseDragged);
        this.widthProperty().addListener(n -> this.update());
        this.minProperty.addListener((v, o, n) -> this.update());
        this.maxProperty.addListener((v, o, n) -> this.update());
        this.lowProperty.addListener((v, o, n) -> this.update());
        this.highProperty.addListener((v, o, n) -> this.update());
        this.lowerThumb.setOnMousePressed(e -> this.lowerThumb.toFront());
        this.upperThumb.setOnMousePressed(e -> this.upperThumb.toFront());
        this.range.setId("range-bar");
        this.lowerThumb.setId("lower-thumb");
        this.upperThumb.setId("upper-thumb");
        this.getChildren().addAll((Object[])new Node[]{this.range, this.lowerThumb, this.upperThumb});
        Platform.runLater(this::update);
    }

    private void update() {
        double lowPercent = (this.getLow() - this.getMin()) / (this.getMax() - this.getMin());
        double highPercent = (this.getHigh() - this.getMin()) / (this.getMax() - this.getMin());
        this.range.setLayoutX(this.getWidth() * lowPercent);
        this.range.setPrefWidth(this.getWidth() * (highPercent - lowPercent));
        this.lowerThumb.setLayoutX(this.getWidth() * lowPercent - this.lowerThumb.getWidth() / 2.0);
        this.upperThumb.setLayoutX(this.getWidth() * highPercent - this.upperThumb.getWidth() / 2.0);
    }

    private void onMouseDragged(MouseEvent e) {
        double x = Math.max(Math.min(e.getX(), this.getWidth() + this.upperThumb.getWidth() / 2.0), -this.lowerThumb.getWidth() / 2.0);
        Point2f mouseLocation = new Point2f(x, e.getY());
        if (this.pressedPane == this.lowerThumb) {
            if (x > this.upperThumb.getLayoutX()) {
                this.setLow(this.getHigh());
                this.update();
                return;
            }
            double offset = x - (double)this.previousMouseLocation.getX();
            double rangeOffset = offset * ((this.getMax() - this.getMin()) / this.getWidth());
            this.setLow(this.getLow() + rangeOffset);
            this.update();
        } else if (this.pressedPane == this.upperThumb) {
            if (x < this.lowerThumb.getLayoutX() + this.lowerThumb.getWidth()) {
                this.setHigh(this.getLow());
                this.update();
                return;
            }
            double offset = x - (double)this.previousMouseLocation.getX();
            double rangeOffset = offset * ((this.getMax() - this.getMin()) / this.getWidth());
            this.setHigh(this.getHigh() + rangeOffset);
            this.update();
        } else if (this.pressedPane == this.range) {
            double offset = x - (double)this.previousMouseLocation.getX();
            double rangeOffset = offset * ((this.getMax() - this.getMin()) / this.getWidth());
            if (this.getLow() + rangeOffset < this.getMin()) {
                rangeOffset = this.getMin() - this.getLow();
            }
            if (this.getHigh() + rangeOffset > this.getMax()) {
                rangeOffset = this.getMax() - this.getHigh();
            }
            this.setLow(this.getLow() + rangeOffset);
            this.setHigh(this.getHigh() + rangeOffset);
            this.update();
        }
        this.previousMouseLocation = mouseLocation;
    }

    private void onMousePressed(MouseEvent e) {
        this.previousMouseLocation = new Point2f(e.getX(), e.getY());
        this.pressedPane = (Pane)e.getTarget();
    }

    private void onMouseReleased(MouseEvent e) {
        this.previousMouseLocation = null;
        this.pressedPane = null;
    }

    public DoubleProperty minProperty() {
        return this.minProperty;
    }

    public DoubleProperty maxProperty() {
        return this.maxProperty;
    }

    public DoubleProperty lowProperty() {
        return this.lowProperty;
    }

    public DoubleProperty highProperty() {
        return this.highProperty;
    }

    public double getMin() {
        return this.minProperty.get();
    }

    public double getMax() {
        return this.maxProperty.get();
    }

    public double getLow() {
        return this.lowProperty.get();
    }

    public double getHigh() {
        return this.highProperty.get();
    }

    public void setMin(double min) {
        this.minProperty.set(Math.min(min, this.getMax()));
    }

    public void setMax(double max) {
        this.maxProperty.set(Math.max(max, this.getMin()));
    }

    public void setLow(double low) {
        this.lowProperty.set(low > this.getHigh() ? this.getHigh() : Math.max(low, this.getMin()));
    }

    public void setHigh(double high) {
        this.highProperty.set(high < this.getLow() ? this.getLow() : Math.min(high, this.getMax()));
    }
}

