/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.tile.Tile;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.Color;

public class TileMapBox
extends HBox {
    private final StyleableObjectProperty<javafx.scene.paint.Color> regionGridColorProperty = new SimpleStyleableObjectProperty(regionGridColorMetaData, (Object)this, "regionGridColor");
    private static final CssMetaData<TileMapBox, javafx.scene.paint.Color> regionGridColorMetaData = new CssMetaData<TileMapBox, javafx.scene.paint.Color>("-region-grid-color", StyleConverter.getColorConverter()){

        public boolean isSettable(TileMapBox styleable) {
            return !styleable.regionGridColorProperty.isBound();
        }

        public StyleableProperty<javafx.scene.paint.Color> getStyleableProperty(TileMapBox styleable) {
            return styleable.regionGridColorProperty;
        }
    };
    private final StyleableObjectProperty<javafx.scene.paint.Color> chunkGridColorProperty = new SimpleStyleableObjectProperty(chunkGridColorMetaData, (Object)this, "chunkGridColor");
    private static final CssMetaData<TileMapBox, javafx.scene.paint.Color> chunkGridColorMetaData = new CssMetaData<TileMapBox, javafx.scene.paint.Color>("-chunk-grid-color", StyleConverter.getColorConverter()){

        public boolean isSettable(TileMapBox styleable) {
            return !styleable.chunkGridColorProperty.isBound();
        }

        public StyleableProperty<javafx.scene.paint.Color> getStyleableProperty(TileMapBox styleable) {
            return styleable.chunkGridColorProperty;
        }
    };
    private final StyleableObjectProperty<javafx.scene.paint.Color> coordinatesColorProperty = new SimpleStyleableObjectProperty(coordinatesColorMetaData, (Object)this, "coordinatesColor");
    private static final CssMetaData<TileMapBox, javafx.scene.paint.Color> coordinatesColorMetaData = new CssMetaData<TileMapBox, javafx.scene.paint.Color>("-coordinates-color", StyleConverter.getColorConverter()){

        public boolean isSettable(TileMapBox styleable) {
            return !styleable.coordinatesColorProperty.isBound();
        }

        public StyleableProperty<javafx.scene.paint.Color> getStyleableProperty(TileMapBox styleable) {
            return styleable.coordinatesColorProperty;
        }
    };
    private final StyleableDoubleProperty gridLineWidthProperty = new SimpleStyleableDoubleProperty(gridLineWidthMetaData, (Object)this, "gridLineWidth");
    private static final CssMetaData<TileMapBox, Number> gridLineWidthMetaData = new CssMetaData<TileMapBox, Number>("-grid-line-width", StyleConverter.getSizeConverter()){

        public boolean isSettable(TileMapBox styleable) {
            return !styleable.gridLineWidthProperty.isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(TileMapBox styleable) {
            return styleable.gridLineWidthProperty;
        }
    };
    private final StyleableObjectProperty<javafx.scene.paint.Color> emptyColorProperty = new SimpleStyleableObjectProperty(emptyColorMetaData, (Object)this, "emptyColor");
    private static final CssMetaData<TileMapBox, javafx.scene.paint.Color> emptyColorMetaData = new CssMetaData<TileMapBox, javafx.scene.paint.Color>("-empty-color", StyleConverter.getColorConverter()){

        public boolean isSettable(TileMapBox styleable) {
            return !styleable.emptyColorProperty.isBound();
        }

        public StyleableProperty<javafx.scene.paint.Color> getStyleableProperty(TileMapBox styleable) {
            return styleable.emptyColorProperty;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> CLASS_CSS_META_DATA;

    public TileMapBox(TileMap tileMap, Stage primaryStage) {
        this.getStyleClass().add((Object)"tile-map-box");
        this.getStylesheets().add((Object)Objects.requireNonNull(TileMapBox.class.getClassLoader().getResource("style/component/tile-map-box.css")).toExternalForm());
        ChangeListener sizeListener = (o, r, n) -> tileMap.resize(primaryStage.getWidth(), primaryStage.getHeight());
        primaryStage.widthProperty().addListener(sizeListener);
        primaryStage.heightProperty().addListener(sizeListener);
        this.setAlignment(Pos.TOP_LEFT);
        this.getChildren().add((Object)tileMap);
        this.bind();
        try {
            this.setBackground(TileMapBoxBackground.valueOf(ConfigProvider.WORLD == null ? "BLACK" : ConfigProvider.WORLD.getTileMapBackground()).getBackground());
        }
        catch (IllegalArgumentException ex) {
            this.setBackground(TileMapBoxBackground.valueOf("BLACK").getBackground());
        }
    }

    private void bind() {
        this.regionGridColorProperty.addListener((o, r, n) -> {
            Tile.REGION_GRID_COLOR = new Color((javafx.scene.paint.Color)this.regionGridColorProperty.get());
        });
        this.chunkGridColorProperty.addListener((o, r, n) -> {
            Tile.CHUNK_GRID_COLOR = new Color((javafx.scene.paint.Color)this.chunkGridColorProperty.get());
        });
        this.coordinatesColorProperty.addListener((o, r, n) -> {
            Tile.COORDINATES_COLOR = new Color((javafx.scene.paint.Color)this.coordinatesColorProperty.get());
        });
        this.gridLineWidthProperty.addListener((o, r, n) -> {
            Tile.GRID_LINE_WIDTH = this.gridLineWidthProperty.get();
        });
        this.emptyColorProperty.addListener((o, r, n) -> {
            Tile.EMPTY_COLOR = new Color((javafx.scene.paint.Color)this.emptyColorProperty.get());
            ImageHelper.reloadEmpty();
        });
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CLASS_CSS_META_DATA;
    }

    static {
        List parent = HBox.getClassCssMetaData();
        List<CssMetaData> additional = Arrays.asList(regionGridColorMetaData, chunkGridColorMetaData, coordinatesColorMetaData, gridLineWidthMetaData, emptyColorMetaData);
        ArrayList<CssMetaData> own = new ArrayList<CssMetaData>(parent.size() + additional.size());
        own.addAll(parent);
        own.addAll(additional);
        CLASS_CSS_META_DATA = Collections.unmodifiableList(own);
    }

    public static enum TileMapBoxBackground {
        GREY_CHECKERBOARD(TileMapBoxBackground.createBackgroundFromImage("img/background/grey_checkerboard")),
        PURPLE_CHECKERBOARD(TileMapBoxBackground.createBackgroundFromImage("img/background/purple_checkerboard")),
        BLUE_CHECKERBOARD(TileMapBoxBackground.createBackgroundFromImage("img/background/blue_checkerboard")),
        BLACK(new Background(new BackgroundFill[]{new BackgroundFill((Paint)javafx.scene.paint.Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)})),
        GREY(new Background(new BackgroundFill[]{new BackgroundFill((Paint)javafx.scene.paint.Color.GREY, CornerRadii.EMPTY, Insets.EMPTY)})),
        WHITE(new Background(new BackgroundFill[]{new BackgroundFill((Paint)javafx.scene.paint.Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));

        private final Background background;

        private static Background createBackgroundFromImage(String resource) {
            return new Background(new BackgroundImage[]{new BackgroundImage(FileHelper.getIconFromResources(resource), BackgroundRepeat.REPEAT, BackgroundRepeat.REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT)});
        }

        private TileMapBoxBackground(Background background) {
            this.background = background;
        }

        public Background getBackground() {
            return this.background;
        }
    }
}

