/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component.filter;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.NumberFilter;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.filter.filters.DataVersionFilter;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.filter.FileFilterBox;
import net.querz.mcaselector.ui.component.filter.GroupFilterBox;
import net.querz.mcaselector.ui.component.filter.NumberFilterBox;
import net.querz.mcaselector.ui.component.filter.TextFilterBox;

public abstract class FilterBox
extends BorderPane {
    private static final Image deleteIcon = FileHelper.getIconFromResources("img/delete");
    private static final Image addIcon = FileHelper.getIconFromResources("img/add");
    private static final Image burgerIcon = FileHelper.getIconFromResources("img/burger");
    private static final DataFormat filterBoxDataFormat = new DataFormat(new String[]{"filterbox-dataformat"});
    private Filter<?> filter;
    private FilterBox parent;
    protected Label delete = new Label("", (Node)new ImageView(deleteIcon));
    protected Label add = new Label("", (Node)new ImageView(addIcon));
    protected Label move = new Label("", (Node)new ImageView(burgerIcon));
    protected ComboBox<FilterType> type = new ComboBox();
    protected ComboBox<Operator> operator = new ComboBox();
    protected GridPane filterOperators = new GridPane();
    private Consumer<FilterBox> updateListener;
    private final boolean root;
    private static Filter<?> dragDropFilter;
    private static FilterBox dragDropFilterBox;
    private static GroupFilterBox lastFocusedGroupFilterBox;
    private static FilterBox currentDragDropTarget;
    private static int currentDragDropTargetDirection;
    private static final boolean USE_DRAGVIEW_OFFSET;
    private static final String stylesheet;

    public FilterBox(FilterBox parent, Filter<?> filter, boolean root) {
        this.parent = parent;
        this.root = root;
        if (root) {
            this.getStyleClass().add((Object)"filter-box-root");
        }
        this.getStyleClass().add((Object)"filter-box");
        this.add.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_FILTER_ADD_TOOLTIP));
        this.add.getStyleClass().add((Object)"control-label");
        this.delete.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_FILTER_DELETE_TOOLTIP));
        this.delete.getStyleClass().add((Object)"control-label");
        GridPane controls = new GridPane();
        controls.getStyleClass().add((Object)"filter-controls-grid");
        controls.setAlignment(Pos.TOP_RIGHT);
        controls.add((Node)this.add, 0, 0, 1, 1);
        controls.add((Node)this.delete, 1, 0, 1, 1);
        controls.add((Node)this.move, 2, 0, 1, 1);
        this.setOnDragDetected(this::onDragDetected);
        this.setOnDragOver(this::onDragOver);
        this.setOnDragDone(this::onDragDone);
        this.setOnDragDropped(this::onDragDropped);
        this.setOnDragExited(this::onDragExited);
        this.setOnDragEntered(this::onDragEntered);
        this.setRight((Node)controls);
        this.filterOperators.getStyleClass().add((Object)"filter-operators-grid");
        this.type.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_FILTER_TYPE_TOOLTIP));
        this.type.getItems().addAll((Object[])FilterType.queryable());
        this.type.getSelectionModel().select((Object)filter.getType());
        this.type.setOnAction(e -> this.update((FilterType)((Object)((Object)this.type.getSelectionModel().getSelectedItem()))));
        this.type.getStyleClass().add((Object)"filter-type-combo-box");
        this.filterOperators.add(this.type, 1, 0, 1, 1);
        this.operator.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_FILTER_OPERATOR_TOOLTIP));
        this.operator.getItems().addAll((Object[])Operator.values());
        this.operator.setOnAction(e -> this.onOperator(this.filter));
        this.operator.getStyleClass().add((Object)"filter-operator-combo-box");
        this.filterOperators.add(this.operator, 0, 0, 1, 1);
        this.filterOperators.setAlignment(Pos.TOP_LEFT);
        this.setLeft((Node)this.filterOperators);
        this.add.setOnMouseReleased(e -> this.onAdd(this.filter));
        this.delete.setOnMouseReleased(e -> this.onDelete(this.filter));
        this.setFilter(filter);
        this.getStylesheets().add((Object)stylesheet);
    }

    private void onDragDetected(MouseEvent e) {
        if (e.getTarget() == this.move) {
            Dragboard db = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
            WritableImage wi = new WritableImage((int)this.getWidth(), (int)this.getHeight());
            WritableImage dbImg = this.snapshot(null, wi);
            db.setDragView((Image)dbImg);
            if (USE_DRAGVIEW_OFFSET) {
                db.setDragViewOffsetX(e.getX());
                db.setDragViewOffsetY(e.getY());
            }
            ClipboardContent content = new ClipboardContent();
            content.put((Object)filterBoxDataFormat, this.filter);
            db.setContent((Map)content);
            dragDropFilter = this.filter;
            dragDropFilterBox = this;
            e.consume();
        }
    }

    private void onDragOver(DragEvent e) {
        if (e.getDragboard().hasContent(filterBoxDataFormat) && !this.isChildOf((Node)dragDropFilterBox) && this != dragDropFilterBox && this.filter.getParent() != null) {
            e.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            currentDragDropTarget = this;
            if (this instanceof GroupFilterBox) {
                double dropCheckHeight;
                lastFocusedGroupFilterBox = (GroupFilterBox)this;
                lastFocusedGroupFilterBox.setInsertCssClass("filter-drop-target", null);
                double d = dropCheckHeight = ((GroupFilterBox)this).filters.getChildren().isEmpty() ? 12.0 : 18.0;
                if (e.getY() < dropCheckHeight) {
                    currentDragDropTargetDirection = -1;
                    this.setInsertCssClass("filter-drop-target", "before");
                } else if (e.getY() >= this.getHeight() - dropCheckHeight) {
                    currentDragDropTargetDirection = 1;
                    this.setInsertCssClass("filter-drop-target", "after");
                } else {
                    this.setInsertCssClass("filter-drop-target", "into");
                    currentDragDropTargetDirection = 0;
                }
            } else if (e.getY() < this.getHeight() / 2.0) {
                this.setInsertCssClass("filter-drop-target", "before");
                currentDragDropTargetDirection = -1;
            } else {
                this.setInsertCssClass("filter-drop-target", "after");
                currentDragDropTargetDirection = 1;
            }
        }
        e.consume();
    }

    private void onDragEntered(DragEvent e) {
        if (lastFocusedGroupFilterBox != null && this != lastFocusedGroupFilterBox) {
            lastFocusedGroupFilterBox.setInsertCssClass("filter-drop-target", null);
            lastFocusedGroupFilterBox = null;
        }
    }

    private void onDragExited(DragEvent e) {
        this.setInsertCssClass("filter-drop-target", null);
        currentDragDropTarget = null;
    }

    private void onDragDone(DragEvent e) {
        Dragboard db = e.getDragboard();
        if (db.hasContent(filterBoxDataFormat)) {
            dragDropFilter = null;
            dragDropFilterBox = null;
            currentDragDropTarget = null;
            currentDragDropTargetDirection = 0;
        }
        e.consume();
    }

    private void onDragDropped(DragEvent e) {
        Dragboard db = e.getDragboard();
        if (db.hasContent(filterBoxDataFormat)) {
            if (currentDragDropTarget == null) {
                e.consume();
                return;
            }
            if (dragDropFilter != this.filter) {
                GroupFilter oldParent = (GroupFilter)dragDropFilter.getParent();
                oldParent.removeFilter(dragDropFilter);
                GroupFilterBox oldParentBox = (GroupFilterBox)FilterBox.dragDropFilterBox.parent;
                oldParentBox.filters.getChildren().remove((Object)dragDropFilterBox);
                if (currentDragDropTargetDirection == 0) {
                    FilterBox.dragDropFilterBox.parent = currentDragDropTarget;
                    dragDropFilter.setParent(FilterBox.currentDragDropTarget.filter);
                } else {
                    FilterBox.dragDropFilterBox.parent = this.parent;
                    dragDropFilter.setParent(this.filter.getParent());
                }
                FilterBox.dragDropFilterBox.operator.setVisible(true);
                FilterBox.currentDragDropTarget.operator.setVisible(true);
                if (currentDragDropTargetDirection == 0) {
                    ((GroupFilterBox)FilterBox.currentDragDropTarget).filters.getChildren().add((Object)dragDropFilterBox);
                    ((GroupFilter)FilterBox.currentDragDropTarget.filter).addFilter(dragDropFilter);
                    ((FilterBox)((Object)((GroupFilterBox)FilterBox.currentDragDropTarget).filters.getChildren().getFirst())).operator.setVisible(false);
                } else {
                    int targetIndex = ((GroupFilterBox)FilterBox.currentDragDropTarget.parent).filters.getChildren().indexOf((Object)currentDragDropTarget);
                    if (currentDragDropTargetDirection == 1) {
                        ++targetIndex;
                    }
                    ((GroupFilterBox)FilterBox.currentDragDropTarget.parent).filters.getChildren().add(targetIndex, (Object)dragDropFilterBox);
                    ((GroupFilter)FilterBox.currentDragDropTarget.filter.getParent()).getFilterValue().add(targetIndex, dragDropFilter);
                    ((FilterBox)((Object)((GroupFilterBox)FilterBox.currentDragDropTarget.parent).filters.getChildren().getFirst())).operator.setVisible(false);
                }
                if (!oldParentBox.filters.getChildren().isEmpty()) {
                    ((FilterBox)((Object)oldParentBox.filters.getChildren().getFirst())).operator.setVisible(false);
                }
                this.callUpdateEvent();
            }
        }
        e.consume();
    }

    private boolean isChildOf(Node node) {
        Parent parent = this.getParent();
        while (parent != null) {
            if ((parent = parent.getParent()) != node) continue;
            return true;
        }
        return false;
    }

    protected void setInsertCssClass(String prefix, String name) {
        String c = prefix + "-" + name;
        for (int i = 0; i < this.getStyleClass().size(); ++i) {
            if (!((String)this.getStyleClass().get(i)).startsWith(prefix)) continue;
            if (name == null) {
                this.getStyleClass().remove(i);
            } else if (!((String)this.getStyleClass().get(i)).equals(c)) {
                this.getStyleClass().set(i, (Object)c);
            }
            return;
        }
        this.getStyleClass().add((Object)c);
    }

    public void setOnUpdate(Consumer<FilterBox> listener) {
        this.updateListener = listener;
    }

    protected void onAdd(Filter<?> filter) {
        DataVersionFilter f = new DataVersionFilter(Operator.AND, Comparator.EQUAL, 0);
        int index = filter.getParent() == null || filter instanceof GroupFilter ? ((GroupFilter)filter).addFilter(f) : ((GroupFilter)filter.getParent()).addFilterAfter(f, filter);
        if (this instanceof GroupFilterBox) {
            ((GroupFilterBox)this).filters.getChildren().add(index, (Object)new NumberFilterBox(this, f, false));
            this.type.getItems().clear();
            this.type.getItems().addAll((Object[])new FilterType[]{FilterType.GROUP, FilterType.NOT_GROUP});
            this.type.getSelectionModel().select((Object)filter.getType());
        } else if (this.parent instanceof GroupFilterBox) {
            ((GroupFilterBox)this.parent).filters.getChildren().add(index, (Object)new NumberFilterBox(this.parent, f, this.root));
        }
        this.callUpdateEvent();
    }

    protected void onDelete(Filter<?> filter) {
        ((GroupFilter)filter.getParent()).removeFilter(filter);
        if (this.parent instanceof GroupFilterBox) {
            ((GroupFilterBox)this.parent).filters.getChildren().remove((Object)this);
            if (!((GroupFilterBox)this.parent).filters.getChildren().isEmpty()) {
                if (this.parent.parent != null) {
                    this.parent.type.getItems().clear();
                    this.parent.type.getItems().addAll((Object[])FilterType.values());
                    this.parent.type.getSelectionModel().select((Object)this.parent.filter.getType());
                }
                ((FilterBox)((Object)((GroupFilterBox)this.parent).filters.getChildren().getFirst())).operator.setVisible(false);
            }
        }
        this.callUpdateEvent();
    }

    protected void update(FilterType type) {
        if (type == null) {
            return;
        }
        if (type != this.filter.getType()) {
            GroupFilter parent = (GroupFilter)this.filter.getParent();
            Filter<?> f = null;
            if (this.filter.getType().getFormat() == FilterType.Format.GROUP && type.getFormat() == FilterType.Format.GROUP) {
                ((GroupFilter)this.filter).setNegated(type == FilterType.NOT_GROUP);
                f = this.filter;
            } else if (parent != null) {
                f = type.create();
                parent.addFilterAfter(Objects.requireNonNull(f), this.filter);
                parent.getFilterValue().remove(this.filter);
                if (this.filter.getType().getFormat() == type.getFormat() && this.filter.getType().getFormat() != FilterType.Format.TEXT) {
                    f.setFilterValue(this.filter.getRawValue());
                    f.setComparator(this.filter.getComparator());
                }
                f.setOperator(this.filter.getOperator());
            }
            FilterBox newBox = switch (type.getFormat()) {
                case FilterType.Format.GROUP -> new GroupFilterBox(this.parent, (GroupFilter)f, false);
                case FilterType.Format.TEXT -> new TextFilterBox(this.parent, (TextFilter)f, false);
                case FilterType.Format.NUMBER -> new NumberFilterBox(this.parent, (NumberFilter)f, false);
                case FilterType.Format.FILE -> new FileFilterBox(this.parent, (TextFilter)f, false);
                default -> throw new RuntimeException("unknown FilterType format: " + String.valueOf((Object)type.getFormat()));
            };
            if (this.parent != null) {
                int index = ((GroupFilterBox)this.parent).filters.getChildren().indexOf((Object)this);
                ((GroupFilterBox)this.parent).filters.getChildren().remove(index);
                ((GroupFilterBox)this.parent).filters.getChildren().add(index, (Object)newBox);
            }
        }
        this.callUpdateEvent();
    }

    protected void setFilter(Filter<?> filter) {
        this.filter = filter;
        this.operator.getSelectionModel().select((Object)filter.getOperator());
        if (filter.getParent() == null || ((GroupFilter)filter.getParent()).getFilterValue().getFirst() == filter) {
            this.operator.setVisible(false);
        }
    }

    private void onOperator(Filter<?> filter) {
        filter.setOperator((Operator)((Object)this.operator.getSelectionModel().getSelectedItem()));
        this.callUpdateEvent();
    }

    protected void callUpdateEvent() {
        FilterBox p = this;
        while (p != null) {
            if (p.updateListener != null) {
                p.updateListener.accept(this);
            }
            p = p.parent;
        }
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        USE_DRAGVIEW_OFFSET = osName.contains("windows");
        stylesheet = Objects.requireNonNull(FilterBox.class.getClassLoader().getResource("style/component/filter-box.css")).toExternalForm();
    }
}

