/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component.filter;

import java.util.Iterator;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.NumberFilter;
import net.querz.mcaselector.filter.TextFilter;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.filter.FileFilterBox;
import net.querz.mcaselector.ui.component.filter.FilterBox;
import net.querz.mcaselector.ui.component.filter.NumberFilterBox;
import net.querz.mcaselector.ui.component.filter.TextFilterBox;

public class GroupFilterBox
extends FilterBox {
    protected VBox filters = new VBox();
    private static final String stylesheet = Objects.requireNonNull(GroupFilterBox.class.getClassLoader().getResource("style/component/group-filter-box.css")).toExternalForm();

    public GroupFilterBox(FilterBox parent, GroupFilter filter, boolean root) {
        super(parent, filter, root);
        this.setFilter(parent, filter, root);
        this.getStylesheets().add((Object)stylesheet);
    }

    public void setFilter(GroupFilter filter) {
        this.setFilter(null, filter, true);
        this.getStylesheets().add((Object)stylesheet);
    }

    private void setFilter(FilterBox parent, GroupFilter filter, boolean root) {
        super.setFilter(filter);
        this.filters.getChildren().clear();
        this.add.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_FILTER_ADD_TOOLTIP));
        this.delete.setVisible(!root);
        this.move.setVisible(!root);
        if (root) {
            this.getStyleClass().add((Object)"group-filter-box-root");
        } else {
            this.getStyleClass().add((Object)"group-filter-box");
        }
        if (!filter.getFilterValue().isEmpty() || root && parent == null) {
            this.type.getItems().clear();
            this.type.getItems().addAll((Object[])new FilterType[]{FilterType.GROUP, FilterType.NOT_GROUP});
            this.type.getSelectionModel().select((Object)filter.getType());
        }
        Iterator iterator = filter.getFilterValue().iterator();
        block6: while (iterator.hasNext()) {
            Filter f = (Filter)iterator.next();
            switch (f.getType().getFormat()) {
                case NUMBER: {
                    this.filters.getChildren().add((Object)new NumberFilterBox((FilterBox)this, (NumberFilter)f, root));
                    continue block6;
                }
                case TEXT: {
                    this.filters.getChildren().add((Object)new TextFilterBox((FilterBox)this, (TextFilter)f, root));
                    continue block6;
                }
                case FILE: {
                    this.filters.getChildren().add((Object)new FileFilterBox((FilterBox)this, (TextFilter)f, root));
                    continue block6;
                }
                case GROUP: {
                    this.filters.getChildren().add((Object)new GroupFilterBox((FilterBox)this, (GroupFilter)f, false));
                    continue block6;
                }
            }
            throw new RuntimeException("failed to display filter " + f.getClass().getSimpleName());
        }
        this.setBottom((Node)this.filters);
    }
}

