/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.component.filter;

import java.util.Objects;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.NumberFilter;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.filter.FilterBox;

public class NumberFilterBox
extends FilterBox {
    private final TextField input = new TextField();
    private final ComboBox<Comparator> comparator = new ComboBox();
    private static final PseudoClass invalid = PseudoClass.getPseudoClass((String)"invalid");
    private static final String stylesheet = Objects.requireNonNull(NumberFilterBox.class.getClassLoader().getResource("style/component/number-filter-box.css")).toExternalForm();

    public NumberFilterBox(FilterBox parent, NumberFilter<?> filter, boolean root) {
        super(parent, filter, root);
        this.getStyleClass().add((Object)"number-filter-box");
        this.input.setPromptText(filter.getFormatText());
        this.input.textProperty().addListener((a, b, c) -> this.onTextInput((Filter<?>)filter, (String)c));
        this.input.setAlignment(Pos.CENTER);
        this.comparator.setTooltip(UIFactory.tooltip(Translation.DIALOG_FILTER_CHUNKS_FILTER_COMPARATOR_TOOLTIP));
        this.comparator.getItems().addAll((Object[])filter.getComparators());
        this.comparator.getSelectionModel().select((Object)filter.getComparator());
        this.comparator.setOnAction(e -> this.onComparator(filter));
        this.comparator.getStyleClass().add((Object)"filter-comparator-combo-box");
        this.filterOperators.add(this.comparator, 2, 0, 1, 1);
        this.setCenter((Node)this.input);
        this.setText(filter.getRawValue());
        this.onTextInput(filter, filter.getRawValue());
        this.getStylesheets().add((Object)stylesheet);
    }

    public void setText(String text) {
        this.input.setText(text);
    }

    private void onTextInput(Filter<?> filter, String newValue) {
        filter.setFilterValue(newValue);
        this.pseudoClassStateChanged(invalid, !filter.isValid());
        this.callUpdateEvent();
    }

    private void onComparator(NumberFilter<?> filter) {
        filter.setComparator((Comparator)((Object)this.comparator.getSelectionModel().getSelectedItem()));
        this.callUpdateEvent();
    }
}

