/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.util.github.VersionChecker;

public class AboutDialog
extends Alert {
    private static final Image githubMark = FileHelper.getIconFromResources("img/GitHub-Mark-Light-32px");
    private static Node persistentVersionCheckResult = new HBox();

    public AboutDialog(Stage primaryStage) {
        super(Alert.AlertType.INFORMATION, null, new ButtonType[]{ButtonType.OK});
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStylesheets().add((Object)Objects.requireNonNull(AboutDialog.class.getClassLoader().getResource("style/component/about-dialog.css")).toExternalForm());
        this.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        this.getDialogPane().getStyleClass().add((Object)"about-dialog-pane");
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_ABOUT_TITLE.getProperty());
        this.headerTextProperty().bind((ObservableValue)Translation.DIALOG_ABOUT_HEADER.getProperty());
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"about-dialog-grid-pane");
        grid.add((Node)UIFactory.label(Translation.DIALOG_ABOUT_VERSION), 0, 0);
        HBox versionLabel = new HBox();
        versionLabel.setAlignment(Pos.CENTER_LEFT);
        String applicationVersion = "0";
        try {
            applicationVersion = FileHelper.getManifestAttributes().getValue("Application-Version");
            versionLabel.getChildren().add((Object)new Label(applicationVersion));
        }
        catch (IOException ex) {
            versionLabel.getChildren().add((Object)UIFactory.label(Translation.DIALOG_ABOUT_VERSION_UNKNOWN));
        }
        Button checkForUpdates = UIFactory.button(Translation.DIALOG_ABOUT_VERSION_CHECK);
        String finalApplicationVersion = applicationVersion;
        checkForUpdates.setOnAction(e -> this.handleCheckUpdate(finalApplicationVersion, b -> versionLabel.getChildren().set(versionLabel.getChildren().size() - 1, b)));
        String copyright = "\u00a9 Querz";
        try {
            copyright = FileHelper.getManifestAttributes().getValue("Copyright");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        versionLabel.getChildren().add((Object)checkForUpdates);
        versionLabel.getChildren().add((Object)persistentVersionCheckResult);
        grid.add((Node)versionLabel, 1, 0);
        grid.add((Node)UIFactory.label(Translation.DIALOG_ABOUT_LICENSE), 0, 1);
        grid.add((Node)new Label("MIT"), 1, 1);
        grid.add((Node)UIFactory.label(Translation.DIALOG_ABOUT_COPYRIGHT), 0, 2);
        grid.add((Node)new Label(copyright), 1, 2);
        grid.add((Node)UIFactory.label(Translation.DIALOG_ABOUT_SOURCE), 0, 3);
        ImageView imgView = new ImageView(githubMark);
        imgView.setScaleX(0.5);
        imgView.setScaleY(0.5);
        Hyperlink source = UIFactory.hyperlink("GitHub", "https://github.com/Querz/mcaselector", (Node)imgView);
        grid.add((Node)source, 1, 3);
        this.getDialogPane().setContent((Node)grid);
        this.getDialogPane().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
    }

    private void handleCheckUpdate(String applicationVersion, Consumer<Node> resultUIHandler) {
        Label checking = UIFactory.label(Translation.DIALOG_ABOUT_VERSION_CHECKING);
        checking.getStyleClass().add((Object)"label-hint");
        resultUIHandler.accept((Node)checking);
        Thread lookup = new Thread(() -> {
            VersionChecker checker = new VersionChecker("Querz", "mcaselector");
            try {
                VersionChecker.VersionData version = checker.fetchLatestVersion();
                if (version != null && version.isNewerThan(applicationVersion)) {
                    HBox box = new HBox();
                    String hyperlinkText = version.getTag() + (version.isPrerelease() ? " (pre)" : "");
                    Hyperlink download = UIFactory.hyperlink(hyperlinkText, version.getLink(), null);
                    download.getStyleClass().add((Object)"hyperlink-update");
                    Label arrow = new Label("\u2192");
                    arrow.getStyleClass().add((Object)"label-hint");
                    box.getChildren().addAll((Object[])new Node[]{arrow, download});
                    persistentVersionCheckResult = box;
                    Platform.runLater(() -> resultUIHandler.accept((Node)box));
                } else {
                    Label upToDate = UIFactory.label(Translation.DIALOG_ABOUT_VERSION_UP_TO_DATE);
                    upToDate.getStyleClass().add((Object)"label-hint");
                    persistentVersionCheckResult = upToDate;
                    Platform.runLater(() -> resultUIHandler.accept((Node)upToDate));
                }
            }
            catch (Exception ex) {
                Label error = UIFactory.label(Translation.DIALOG_ABOUT_VERSION_ERROR);
                error.getStyleClass().add((Object)"label-hint");
                Platform.runLater(() -> resultUIHandler.accept((Node)error));
            }
        });
        lookup.setDaemon(true);
        lookup.start();
    }
}

