/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import javafx.application.Platform;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.dialog.ProgressDialog;

public class CancellableProgressDialog
extends ProgressDialog {
    private boolean cancelled = false;

    public CancellableProgressDialog(Translation title, Stage primaryStage) {
        super(title, (Window)primaryStage);
        HBox cancelBox = new HBox();
        cancelBox.getStyleClass().add((Object)"cancel-box");
        Button cancel = UIFactory.button(Translation.BUTTON_CANCEL);
        cancelBox.getChildren().add((Object)cancel);
        this.getBox().getChildren().add((Object)cancelBox);
        cancel.setOnAction(e -> {
            cancel.setDisable(true);
            this.cancelled = true;
            this.getCurrentTask().setLocked(true);
            this.getCurrentTask().setIndeterminate(Translation.DIALOG_PROGRESS_CANCELLING.toString());
            JobHandler.cancelAllJobsAndFlushAsync(() -> Platform.runLater(() -> {
                this.getCurrentTask().cancelTask();
                this.getCurrentTask().done(Translation.DIALOG_PROGRESS_DONE.toString());
                this.close();
            }));
        });
    }

    public boolean cancelled() {
        return this.cancelled;
    }
}

