/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.util.Objects;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.TransparentStage;

public class ColorPicker
extends TransparentStage {
    private final Slider red = this.createSlider(0, 255, 1, 0);
    private final Slider green = this.createSlider(0, 255, 1, 0);
    private final Slider blue = this.createSlider(0, 255, 1, 0);
    private final Slider opacity = this.createSlider(0, 255, 1, 0);
    private final StackPane preview = new StackPane();
    private final Button ok = UIFactory.button(Translation.BUTTON_OK);
    private final Button cancel = UIFactory.button(Translation.BUTTON_CANCEL);
    private Color result;

    public ColorPicker(Window stage, Color color) {
        super(stage);
        this.cancel.setOnAction(e -> {
            this.result = null;
            this.close();
        });
        this.ok.setOnAction(e -> this.close());
        this.red.setValue(color.getRed() * 255.0);
        this.green.setValue(color.getGreen() * 255.0);
        this.blue.setValue(color.getBlue() * 255.0);
        this.opacity.setValue(color.getOpacity() * 255.0);
        this.red.valueProperty().addListener((l, o, n) -> this.onValueChange());
        this.green.valueProperty().addListener((l, o, n) -> this.onValueChange());
        this.blue.valueProperty().addListener((l, o, n) -> this.onValueChange());
        this.opacity.valueProperty().addListener((l, o, n) -> this.onValueChange());
        this.preview.getStyleClass().add((Object)"color-picker-preview");
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"color-picker-sliders");
        grid.add((Node)this.label("R", "color-picker-slider-label"), 0, 0, 1, 1);
        grid.add((Node)this.label("G", "color-picker-slider-label"), 0, 1, 1, 1);
        grid.add((Node)this.label("B", "color-picker-slider-label"), 0, 2, 1, 1);
        grid.add((Node)this.label("A", "color-picker-slider-label"), 0, 3, 1, 1);
        grid.add((Node)this.red, 1, 0, 1, 1);
        grid.add((Node)this.green, 1, 1, 1, 1);
        grid.add((Node)this.blue, 1, 2, 1, 1);
        grid.add((Node)this.opacity, 1, 3, 1, 1);
        grid.add((Node)UIFactory.attachTextFieldToSlider(this.red), 2, 0, 1, 1);
        grid.add((Node)UIFactory.attachTextFieldToSlider(this.green), 2, 1, 1, 1);
        grid.add((Node)UIFactory.attachTextFieldToSlider(this.blue), 2, 2, 1, 1);
        grid.add((Node)UIFactory.attachTextFieldToSlider(this.opacity), 2, 3, 1, 1);
        HBox buttonBox = new HBox();
        buttonBox.getChildren().addAll((Object[])new Node[]{this.ok, this.cancel});
        buttonBox.getStyleClass().add((Object)"color-picker-button-box");
        BorderPane borderPane = new BorderPane();
        borderPane.getStyleClass().add((Object)"color-picker");
        borderPane.setTop((Node)grid);
        borderPane.setCenter((Node)this.preview);
        borderPane.setBottom((Node)buttonBox);
        borderPane.setLeft((Node)this.borderElement("border-element-vertical"));
        borderPane.setRight((Node)this.borderElement("border-element-vertical"));
        this.setContent((Node)borderPane);
        this.getScene().getStylesheets().add((Object)Objects.requireNonNull(ColorPicker.class.getClassLoader().getResource("style/component/color-picker.css")).toExternalForm());
    }

    public Optional<Color> showColorPicker() {
        this.showAndWait();
        return Optional.ofNullable(this.result);
    }

    private Label label(String name, String styleClass) {
        Label label = new Label(name);
        label.getStyleClass().add((Object)styleClass);
        return label;
    }

    private Region borderElement(String styleClass) {
        Region border = new Region();
        border.getStyleClass().add((Object)styleClass);
        return border;
    }

    private void onValueChange() {
        this.result = new Color(this.red.getValue() / 255.0, this.green.getValue() / 255.0, this.blue.getValue() / 255.0, this.opacity.getValue() / 255.0);
        this.preview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.result, CornerRadii.EMPTY, Insets.EMPTY)}));
    }

    private Slider createSlider(int min, int max, int steps, int init) {
        Slider slider = new Slider((double)min, (double)max, (double)init);
        slider.setMajorTickUnit((double)steps);
        slider.setMinorTickCount(0);
        slider.setBlockIncrement((double)steps);
        return slider;
    }
}

