/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.StringConverter;
import javafx.util.converter.ByteStringConverter;
import javafx.util.converter.IntegerStringConverter;
import javafx.util.converter.LongStringConverter;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.component.NBTTreeView;
import net.querz.mcaselector.ui.dialog.RequestNumberDialog;
import net.querz.mcaselector.util.math.Bits;

public class EditArrayDialog
extends Dialog<NBTTreeView.EditArrayResult> {
    private final TableView<Row> table = new TableView();
    private final ComboBox<BitCount> bits = new ComboBox();
    private final CheckBox overlapping = new CheckBox();
    private static final Image editIcon = FileHelper.getIconFromResources("img/edit");
    private final Object handle;
    private int[] values;

    public EditArrayDialog(Object array, Stage stage) {
        Class<?> clazz = array.getClass();
        if (clazz != long[].class && clazz != int[].class && clazz != byte[].class) {
            throw new IllegalArgumentException("invalid or unsupported array type: " + String.valueOf(clazz));
        }
        this.handle = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array));
        System.arraycopy(array, 0, this.handle, 0, Array.getLength(array));
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStyleClass().add((Object)"edit-array-dialog-pane");
        this.getDialogPane().getStyleClass().addAll((Collection)stage.getScene().getStylesheets());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        this.setResizable(true);
        this.setResultConverter(a -> a == ButtonType.APPLY ? new NBTTreeView.EditArrayResult(this.handle) : null);
        this.table.setPlaceholder((Node)new Label());
        this.table.getStyleClass().add((Object)"edit-array-table-view");
        this.table.setEditable(true);
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.table.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        TableColumn indexColumn = new TableColumn();
        indexColumn.textProperty().bind((ObservableValue)Translation.DIALOG_EDIT_ARRAY_INDEX.getProperty());
        TableColumn<Row, ? extends Number> valueColumn = this.createValueColumn();
        if (valueColumn == null) {
            throw new IllegalArgumentException("invalid array type, could not create column");
        }
        indexColumn.setSortable(false);
        valueColumn.setSortable(false);
        indexColumn.setResizable(false);
        valueColumn.setResizable(false);
        valueColumn.setEditable(true);
        valueColumn.prefWidthProperty().bind((ObservableValue)this.table.widthProperty().subtract(70));
        indexColumn.setPrefWidth(50.0);
        this.table.getColumns().addAll((Object[])new TableColumn[]{indexColumn, valueColumn});
        indexColumn.setCellValueFactory(c -> new ReadOnlyObjectWrapper((Object)((Row)c.getValue()).index));
        BorderPane content = new BorderPane();
        BorderPane.setAlignment(this.table, (Pos)Pos.TOP_LEFT);
        content.setCenter(this.table);
        Button editButton = new Button(null, (Node)new ImageView(editIcon));
        editButton.setOnAction(e -> {
            if (this.table.getSelectionModel().getSelectedItems() != null) {
                if (this.table.getSelectionModel().getSelectedItems().size() > 1) {
                    long min = 0L;
                    long max = 0L;
                    BitCount b = (BitCount)((Object)((Object)this.bits.getSelectionModel().getSelectedItem()));
                    if (b == null || b == BitCount.NONE) {
                        if (this.handle instanceof byte[]) {
                            min = -128L;
                            max = 127L;
                        } else if (this.handle instanceof int[]) {
                            min = Integer.MIN_VALUE;
                            max = Integer.MAX_VALUE;
                        } else if (this.handle instanceof long[]) {
                            min = Long.MIN_VALUE;
                            max = Long.MAX_VALUE;
                        }
                    } else {
                        max = b.bits == 1 ? 1L : (long)Math.pow(2.0, b.bits);
                    }
                    Optional n = new RequestNumberDialog(stage, Translation.DIALOG_REQUEST_NUMBER_TITLE_ENTER_NUMBER, min, max).showAndWait();
                    n.ifPresent(v -> this.table.getSelectionModel().getSelectedItems().forEach(r -> r.setValue((Number)v)));
                    this.table.refresh();
                } else {
                    this.table.edit(this.table.getSelectionModel().getSelectedIndex(), valueColumn);
                }
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> editButton.setDisable(n == null));
        editButton.setDisable(true);
        HBox options = new HBox();
        options.getStyleClass().add((Object)"edit-array-options");
        options.getChildren().add((Object)editButton);
        if (this.handle instanceof long[]) {
            this.bits.getItems().addAll((Object[])BitCount.values());
            this.bits.setPromptText("bits");
            this.bits.valueProperty().addListener((v, o, n) -> {
                if (n == null) {
                    return;
                }
                if (n == BitCount.NONE) {
                    Platform.runLater(() -> this.bits.getSelectionModel().clearSelection());
                    this.overlapping.setDisable(true);
                } else {
                    this.overlapping.setDisable(64 % n.bits == 0);
                }
                this.loadBitValues((BitCount)((Object)n));
                this.table.getItems().clear();
                this.createRows();
            });
            Label overlap = new Label("overlapping:");
            overlap.getStyleClass().add((Object)"overlap-label");
            this.overlapping.selectedProperty().addListener((v, o, n) -> {
                this.loadBitValues((BitCount)((Object)((Object)this.bits.getValue())));
                this.table.getItems().clear();
                this.createRows();
            });
            this.overlapping.setDisable(true);
            options.getChildren().addAll((Object[])new Node[]{new Separator(), this.bits, new Separator(), overlap, this.overlapping});
        }
        content.setBottom((Node)options);
        this.createRows();
        this.getDialogPane().setContent((Node)content);
        this.getDialogPane().getStylesheets().addAll((Collection)stage.getScene().getStylesheets());
        this.getDialogPane().getStylesheets().add((Object)Objects.requireNonNull(EditArrayDialog.class.getClassLoader().getResource("style/component/edit-array-dialog.css")).toExternalForm());
    }

    private TableColumn<Row, ? extends Number> createValueColumn() {
        if (this.handle instanceof byte[]) {
            ByteStringConverter converter = new ByteStringConverter(this){

                public Byte fromString(String s) {
                    try {
                        return super.fromString(s);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            };
            TableColumn column = new TableColumn();
            column.textProperty().bind((ObservableValue)Translation.DIALOG_EDIT_ARRAY_VALUE.getProperty());
            column.setCellFactory(t -> {
                TextFieldTableCell<Row, Byte> cell = new TextFieldTableCell<Row, Byte>(){

                    public void commitEdit(Byte b) {
                        if (b == null) {
                            return;
                        }
                        super.commitEdit((Object)b);
                        ((Row)EditArrayDialog.this.table.getItems().get((int)((Byte)this.getItem()).byteValue())).setValue(b);
                    }
                };
                cell.setConverter((StringConverter)converter);
                return cell;
            });
            column.setCellValueFactory(c -> new ReadOnlyObjectWrapper((Object)((Row)c.getValue()).value.byteValue()));
            return column;
        }
        if (this.handle instanceof int[]) {
            IntegerStringConverter converter = new IntegerStringConverter(this){

                public Integer fromString(String s) {
                    try {
                        return super.fromString(s);
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                }
            };
            TableColumn column = new TableColumn();
            column.textProperty().bind((ObservableValue)Translation.DIALOG_EDIT_ARRAY_VALUE.getProperty());
            column.setCellFactory(t -> {
                TextFieldTableCell<Row, Integer> cell = new TextFieldTableCell<Row, Integer>(){

                    public void commitEdit(Integer b) {
                        if (b == null) {
                            return;
                        }
                        super.commitEdit((Object)b);
                        ((Row)EditArrayDialog.this.table.getItems().get(this.getIndex())).setValue(b);
                    }
                };
                cell.setConverter((StringConverter)converter);
                return cell;
            });
            column.setCellValueFactory(c -> new ReadOnlyObjectWrapper((Object)((Row)c.getValue()).value.intValue()));
            return column;
        }
        if (this.handle instanceof long[]) {
            LongStringConverter converter = new LongStringConverter(){

                public Long fromString(String s) {
                    try {
                        long l = super.fromString(s);
                        if (EditArrayDialog.this.bits.getValue() != BitCount.NONE) {
                            int max = (int)Math.pow(2.0, ((BitCount)((Object)EditArrayDialog.this.bits.getValue())).bits);
                            if (l < (long)max && l >= 0L) {
                                return l;
                            }
                            return null;
                        }
                        return l;
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                }
            };
            TableColumn column = new TableColumn();
            column.textProperty().bind((ObservableValue)Translation.DIALOG_EDIT_ARRAY_VALUE.getProperty());
            column.setCellFactory(t -> {
                TextFieldTableCell<Row, Long> cell = new TextFieldTableCell<Row, Long>(){

                    public void commitEdit(Long b) {
                        if (b == null) {
                            return;
                        }
                        super.commitEdit((Object)b);
                        ((Row)EditArrayDialog.this.table.getItems().get(this.getIndex())).setValue(b);
                    }
                };
                cell.setConverter((StringConverter)converter);
                return cell;
            });
            column.setCellValueFactory(c -> new ReadOnlyObjectWrapper((Object)((Row)c.getValue()).value.longValue()));
            return column;
        }
        return null;
    }

    private void loadBitValues(BitCount bits) {
        if (bits != BitCount.NONE) {
            if (this.overlapping.isSelected()) {
                long[] la = (long[])this.handle;
                int bitValuesLength = (int)(64.0 / (double)bits.bits * (double)la.length);
                this.values = new int[bitValuesLength];
                for (int i = 0; i < bitValuesLength; ++i) {
                    double blockStatesIndex = (double)i / ((double)bitValuesLength / (double)la.length);
                    int longIndex = (int)blockStatesIndex;
                    int startBit = (int)((blockStatesIndex - Math.floor(blockStatesIndex)) * 64.0);
                    if (startBit + bits.bits > 64) {
                        long prev = Bits.bitRange(la[longIndex], startBit, 64);
                        long next = Bits.bitRange(la[longIndex + 1], 0, startBit + bits.bits - 64);
                        this.values[i] = (int)((next << 64 - startBit) + prev);
                        continue;
                    }
                    this.values[i] = (int)Bits.bitRange(la[longIndex], startBit, startBit + bits.bits);
                }
            } else {
                long[] la = (long[])this.handle;
                int indicesPerLong = Math.floorDiv(64, bits.bits);
                int bitValuesLength = la.length * indicesPerLong;
                this.values = new int[bitValuesLength];
                for (int i = 0; i < bitValuesLength; ++i) {
                    int blockStatesIndex = i / indicesPerLong;
                    int startBit = i % indicesPerLong * bits.bits;
                    this.values[i] = (int)Bits.bitRange(la[blockStatesIndex], startBit, startBit + bits.bits);
                }
            }
        } else {
            this.values = null;
        }
    }

    private void createRows() {
        block7: {
            Object i2;
            block8: {
                block6: {
                    Object object = this.handle;
                    if (!(object instanceof byte[])) break block6;
                    byte[] ba = (byte[])object;
                    for (int i2 = 0; i2 < ba.length; ++i2) {
                        this.table.getItems().add((Object)new Row(i2, ba[i2]));
                    }
                    break block7;
                }
                i2 = this.handle;
                if (!(i2 instanceof int[])) break block8;
                int[] ia = (int[])i2;
                for (int i3 = 0; i3 < ia.length; ++i3) {
                    this.table.getItems().add((Object)new Row(i3, ia[i3]));
                }
                break block7;
            }
            i2 = this.handle;
            if (!(i2 instanceof long[])) break block7;
            long[] la = (long[])i2;
            if (this.bits.getValue() == BitCount.NONE || this.bits.getValue() == null) {
                for (int i4 = 0; i4 < la.length; ++i4) {
                    this.table.getItems().add((Object)new Row(i4, la[i4]));
                }
            } else {
                for (int i5 = 0; i5 < this.values.length; ++i5) {
                    this.table.getItems().add((Object)new Row(i5, this.values[i5]));
                }
            }
        }
    }

    static enum BitCount {
        NONE(-1, ""),
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5),
        SIX(6),
        SEVEN(7),
        EIGHT(8),
        NINE(9),
        TEN(10),
        ELEVEN(11),
        TWELVE(12),
        THIRTY_TWO(32);

        final int bits;
        final String string;

        private BitCount(int bits) {
            this(bits, "" + bits);
        }

        private BitCount(int bits, String string2) {
            this.bits = bits;
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    class Row {
        int index;
        Number value;

        Row(int index, Number value) {
            this.index = index;
            this.value = value;
        }

        /*
         * Enabled aggressive block sorting
         */
        void setValue(Number value) {
            this.value = value;
            Object object = EditArrayDialog.this.handle;
            if (object instanceof long[]) {
                long[] hndl = (long[])object;
                if (EditArrayDialog.this.bits.getValue() != BitCount.NONE && EditArrayDialog.this.bits.getValue() != null) {
                    if (EditArrayDialog.this.overlapping.isSelected()) {
                        double blockStatesIndex = (double)this.index / ((double)EditArrayDialog.this.values.length / (double)hndl.length);
                        int longIndex = (int)blockStatesIndex;
                        int startBit = (int)((blockStatesIndex - (double)longIndex) * 64.0);
                        int bits = ((BitCount)((Object)EditArrayDialog.this.bits.getValue())).bits;
                        if (startBit + bits > 64) {
                            hndl[longIndex] = Bits.setBits(value.shortValue(), hndl[longIndex], startBit, 64);
                            hndl[longIndex + 1] = Bits.setBits(value.shortValue() >> 64 - startBit, hndl[longIndex + 1], 0, startBit + bits - 64);
                        } else {
                            hndl[longIndex] = Bits.setBits(value.shortValue(), hndl[longIndex], startBit, startBit + bits);
                        }
                    } else {
                        int bits = ((BitCount)((Object)EditArrayDialog.this.bits.getValue())).bits;
                        int indicesPerLong = (int)(64.0 / (double)bits);
                        int blockStatesIndex = this.index / indicesPerLong;
                        int startBit = this.index % indicesPerLong * bits;
                        hndl[blockStatesIndex] = Bits.setBits(value.longValue(), hndl[blockStatesIndex], startBit, startBit + bits);
                    }
                    EditArrayDialog.this.values[this.index] = value.shortValue();
                    return;
                }
            }
            Object object2 = EditArrayDialog.this.handle;
            Objects.requireNonNull(object2);
            object = object2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{long[].class, int[].class, byte[].class}, (Object)object, n)) {
                case 0: {
                    long[] longs = (long[])object;
                    longs[this.index] = value.longValue();
                    return;
                }
                case 1: {
                    int[] ints = (int[])object;
                    ints[this.index] = value.intValue();
                    return;
                }
                case 2: {
                    byte[] bytes = (byte[])object;
                    bytes[this.index] = value.byteValue();
                    return;
                }
            }
            throw new IllegalStateException("unexpected value: " + String.valueOf(EditArrayDialog.this.handle.getClass()));
        }
    }
}

