/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Collection;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.querz.mcaselector.text.TextHelper;
import net.querz.mcaselector.text.Translation;

public class ErrorDialog
extends Alert {
    private final VBox content = new VBox();
    private boolean showingCopiedToClipboardText = false;

    public ErrorDialog(Window owner, String errorMessage) {
        super(Alert.AlertType.ERROR, null, new ButtonType[]{ButtonType.CLOSE});
        this.init(owner);
        this.setContentText(errorMessage);
        this.showAndWait();
    }

    public ErrorDialog(Window owner, Exception ex) {
        super(Alert.AlertType.ERROR, null, new ButtonType[]{ButtonType.CLOSE});
        this.init(owner);
        this.getDialogPane().getStylesheets().add((Object)Objects.requireNonNull(ErrorDialog.class.getClassLoader().getResource("style/component/error-dialog.css")).toExternalForm());
        String errorMessage = TextHelper.getStacktraceAsString(ex);
        ButtonType copyToClipboard = new ButtonType(Translation.DIALOG_ERROR_BUTTON_COPY_TO_CLIPBOARD.toString(), ButtonBar.ButtonData.BACK_PREVIOUS);
        this.getDialogPane().getButtonTypes().addFirst((Object)copyToClipboard);
        TextArea errorText = new TextArea();
        errorText.setEditable(false);
        errorText.setText(errorMessage);
        Label copiedToClipboard = new Label();
        copiedToClipboard.getStyleClass().add((Object)"copied-to-clipboard-label");
        this.getDialogPane().lookupButton(copyToClipboard).addEventFilter(ActionEvent.ACTION, e -> {
            this.copyTextToClipboard(errorMessage);
            this.showLabelTextForXSeconds(copiedToClipboard, Translation.DIALOG_ERROR_COPIED_TO_CLIPBOARD.toString(), 3);
            e.consume();
        });
        this.content.getChildren().addAll((Object[])new Node[]{errorText, copiedToClipboard});
        this.getDialogPane().setContent((Node)this.content);
        this.showAndWait();
    }

    private void init(Window primaryStage) {
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStyleClass().add((Object)"error-dialog-pane");
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_ERROR_TITLE.getProperty());
        this.headerTextProperty().bind((ObservableValue)Translation.DIALOG_ERROR_HEADER.getProperty());
        this.getDialogPane().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
    }

    private void copyTextToClipboard(String text) {
        StringSelection stringSelection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, null);
    }

    private void showLabelTextForXSeconds(Label label, String text, int seconds) {
        if (this.showingCopiedToClipboardText) {
            return;
        }
        this.showingCopiedToClipboardText = true;
        label.setText(text);
        Thread t = new Thread(() -> {
            try {
                Thread.sleep((long)seconds * 1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Platform.runLater(() -> {
                label.setText(null);
                this.showingCopiedToClipboardText = false;
            });
        });
        t.start();
    }
}

