/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;

public class ImportSelectionDialog
extends Dialog<Result> {
    private final RadioButton overwrite = UIFactory.radio(Translation.DIALOG_IMPORT_SELECTION_OVERWRITE);
    private final RadioButton merge = UIFactory.radio(Translation.DIALOG_IMPORT_SELECTION_MERGE);

    public ImportSelectionDialog(Stage primaryStage) {
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStyleClass().add((Object)"import-selection-dialog-pane");
        this.getDialogPane().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_IMPORT_SELECTION_TITLE.getProperty());
        this.headerTextProperty().bind((ObservableValue)Translation.DIALOG_IMPORT_SELECTION_HEADER.getProperty());
        this.setResultConverter(p -> p == ButtonType.OK ? (this.overwrite.isSelected() ? Result.OVERWRITE : Result.MERGE) : null);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{this.overwrite, this.merge});
        this.merge.fire();
        HBox choices = new HBox();
        choices.getChildren().addAll((Object[])new Node[]{this.overwrite, this.merge});
        this.getDialogPane().setContent((Node)choices);
    }

    public static enum Result {
        OVERWRITE,
        MERGE;

    }
}

