/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Slider;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.StringConverter;
import net.querz.mcaselector.config.Config;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.config.GlobalConfig;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.BorderedTitledPane;
import net.querz.mcaselector.ui.component.FileTextField;
import net.querz.mcaselector.ui.component.HeightSlider;
import net.querz.mcaselector.ui.component.TileMapBox;
import net.querz.mcaselector.ui.dialog.ColorPicker;
import net.querz.mcaselector.util.property.DataProperty;

public class SettingsDialog
extends Dialog<Result> {
    private static final int processorCount = Runtime.getRuntime().availableProcessors();
    private static final long maxMemory = Runtime.getRuntime().maxMemory();
    private final TabPane tabPane = new TabPane();
    private final ToggleGroup toggleGroup = new ToggleGroup();
    private final BorderPane tabBox = new BorderPane();
    private final ComboBox<Locale> languages = new ComboBox();
    private final Slider processThreadsSlider = this.createSlider(1, processorCount * 2, 1, ConfigProvider.GLOBAL.getProcessThreads());
    private final Slider writeThreadsSlider = this.createSlider(1, processorCount, 1, ConfigProvider.GLOBAL.getWriteThreads());
    private final Slider maxLoadedFilesSlider = this.createSlider(1, (int)Math.max(Math.ceil((double)maxMemory / 1.0E9) * 6.0, 4.0), 1, ConfigProvider.GLOBAL.getMaxLoadedFiles());
    private final HeightSlider hSlider = new HeightSlider(ConfigProvider.WORLD.getRenderHeight(), false);
    private final CheckBox layerOnly = new CheckBox();
    private final CheckBox caves = new CheckBox();
    private final Button regionSelectionColorPreview = new Button();
    private final Button chunkSelectionColorPreview = new Button();
    private final Button pasteChunksColorPreview = new Button();
    private final CheckBox shadeCheckBox = new CheckBox();
    private final CheckBox shadeWaterCheckBox = new CheckBox();
    private final CheckBox shadeAltitudeCheckBox = new CheckBox();
    private final CheckBox showNonexistentRegionsCheckBox = new CheckBox();
    private final CheckBox smoothRendering = new CheckBox();
    private final CheckBox smoothOverlays = new CheckBox();
    private final ComboBox<TileMapBox.TileMapBoxBackground> tileMapBackgrounds = new ComboBox();
    private final FileTextField mcSavesDir = new FileTextField();
    private final CheckBox debugCheckBox = new CheckBox();
    private final FileTextField poiField = new FileTextField();
    private final FileTextField entitiesField = new FileTextField();
    private Color regionSelectionColor = ConfigProvider.GLOBAL.getRegionSelectionColor().makeJavaFXColor();
    private Color chunkSelectionColor = ConfigProvider.GLOBAL.getChunkSelectionColor().makeJavaFXColor();
    private Color pasteChunksColor = ConfigProvider.GLOBAL.getPasteChunksColor().makeJavaFXColor();
    private final ButtonType reset = new ButtonType(Translation.DIALOG_SETTINGS_RESET.toString(), ButtonBar.ButtonData.LEFT);

    public SettingsDialog(Stage primaryStage, boolean renderSettings) {
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_SETTINGS_TITLE.getProperty());
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStyleClass().add((Object)"settings-dialog-pane");
        this.getDialogPane().getScene().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL, this.reset});
        this.getDialogPane().lookupButton(this.reset).addEventFilter(ActionEvent.ACTION, e -> {
            e.consume();
            this.languages.setValue((Object)GlobalConfig.DEFAULT_LOCALE);
            this.processThreadsSlider.setValue((double)GlobalConfig.DEFAULT_PROCESS_THREADS);
            this.writeThreadsSlider.setValue((double)GlobalConfig.DEFAULT_WRITE_THREADS);
            this.maxLoadedFilesSlider.setValue(1.0);
            this.regionSelectionColor = GlobalConfig.DEFAULT_REGION_SELECTION_COLOR.makeJavaFXColor();
            this.regionSelectionColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)GlobalConfig.DEFAULT_REGION_SELECTION_COLOR.makeJavaFXColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
            this.chunkSelectionColor = GlobalConfig.DEFAULT_CHUNK_SELECTION_COLOR.makeJavaFXColor();
            this.chunkSelectionColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)GlobalConfig.DEFAULT_CHUNK_SELECTION_COLOR.makeJavaFXColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
            this.pasteChunksColor = GlobalConfig.DEFAULT_PASTE_CHUNKS_COLOR.makeJavaFXColor();
            this.pasteChunksColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)GlobalConfig.DEFAULT_PASTE_CHUNKS_COLOR.makeJavaFXColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
            this.shadeCheckBox.setSelected(true);
            this.shadeWaterCheckBox.setSelected(true);
            this.shadeAltitudeCheckBox.setSelected(true);
            this.showNonexistentRegionsCheckBox.setSelected(true);
            this.smoothRendering.setSelected(false);
            this.smoothOverlays.setSelected(true);
            this.hSlider.valueProperty().set(this.hSlider.getValue());
            this.caves.setSelected(false);
            this.tileMapBackgrounds.setValue((Object)TileMapBox.TileMapBoxBackground.valueOf("BLACK"));
            this.mcSavesDir.setFile(GlobalConfig.DEFAULT_MC_SAVES_DIR == null ? null : new File(GlobalConfig.DEFAULT_MC_SAVES_DIR));
            this.debugCheckBox.setSelected(false);
        });
        this.languages.getItems().addAll(Translation.getAvailableLanguages());
        this.languages.setValue((Object)ConfigProvider.GLOBAL.getLocale());
        this.languages.setConverter((StringConverter)new StringConverter<Locale>(this){
            final Map<String, Locale> cache = new HashMap<String, Locale>();

            public String toString(Locale locale) {
                String display = locale.getDisplayName(locale);
                this.cache.put(display, locale);
                return display;
            }

            public Locale fromString(String string) {
                return this.cache.get(string);
            }
        });
        this.languages.getStyleClass().add((Object)"languages-combo-box");
        this.regionSelectionColorPreview.getStyleClass().clear();
        this.chunkSelectionColorPreview.getStyleClass().clear();
        this.pasteChunksColorPreview.getStyleClass().clear();
        this.regionSelectionColorPreview.getStyleClass().add((Object)"color-preview-button");
        this.chunkSelectionColorPreview.getStyleClass().add((Object)"color-preview-button");
        this.pasteChunksColorPreview.getStyleClass().add((Object)"color-preview-button");
        this.regionSelectionColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.regionSelectionColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.chunkSelectionColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.chunkSelectionColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.pasteChunksColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.pasteChunksColor, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.shadeCheckBox.setSelected(ConfigProvider.WORLD.getShade());
        this.shadeWaterCheckBox.setSelected(ConfigProvider.WORLD.getShadeWater());
        this.shadeAltitudeCheckBox.setSelected(ConfigProvider.WORLD.getShadeAltitude());
        this.showNonexistentRegionsCheckBox.setSelected(ConfigProvider.WORLD.getShowNonexistentRegions());
        this.smoothRendering.setSelected(ConfigProvider.WORLD.getSmoothRendering());
        this.smoothOverlays.setSelected(ConfigProvider.WORLD.getSmoothOverlays());
        this.hSlider.valueProperty().set(ConfigProvider.WORLD.getRenderHeight());
        this.layerOnly.setSelected(ConfigProvider.WORLD.getRenderLayerOnly());
        this.caves.setSelected(ConfigProvider.WORLD.getRenderCaves());
        this.tileMapBackgrounds.getItems().addAll((Object[])TileMapBox.TileMapBoxBackground.values());
        this.tileMapBackgrounds.setCellFactory(listView -> {
            ListCell<TileMapBox.TileMapBoxBackground> cell = new ListCell<TileMapBox.TileMapBoxBackground>(this){

                public void updateIndex(int i) {
                    super.updateIndex(i);
                    TileMapBox.TileMapBoxBackground[] values = TileMapBox.TileMapBoxBackground.values();
                    if (i < 0 || i >= values.length) {
                        return;
                    }
                    this.setBackground(values[i].getBackground());
                }
            };
            cell.getStyleClass().clear();
            return cell;
        });
        this.tileMapBackgrounds.setButtonCell((ListCell)this.tileMapBackgrounds.getCellFactory().call(null));
        this.tileMapBackgrounds.getStyleClass().add((Object)"tilemap-backgrounds-combo-box");
        this.tileMapBackgrounds.setValue((Object)TileMapBox.TileMapBoxBackground.valueOf(ConfigProvider.WORLD.getTileMapBackground()));
        this.mcSavesDir.setFile(ConfigProvider.GLOBAL.getMcSavesDir() == null ? null : new File(ConfigProvider.GLOBAL.getMcSavesDir()));
        this.debugCheckBox.setSelected(ConfigProvider.GLOBAL.getDebug());
        this.regionSelectionColorPreview.setOnMousePressed(e -> {
            Optional<Color> result = new ColorPicker(this.getDialogPane().getScene().getWindow(), this.regionSelectionColor).showColorPicker();
            result.ifPresent(c -> {
                this.regionSelectionColor = c;
                this.regionSelectionColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)c, CornerRadii.EMPTY, Insets.EMPTY)}));
            });
        });
        this.chunkSelectionColorPreview.setOnMousePressed(e -> {
            Optional<Color> result = new ColorPicker(this.getDialogPane().getScene().getWindow(), this.chunkSelectionColor).showColorPicker();
            result.ifPresent(c -> {
                this.chunkSelectionColor = c;
                this.chunkSelectionColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)c, CornerRadii.EMPTY, Insets.EMPTY)}));
            });
        });
        this.pasteChunksColorPreview.setOnMousePressed(e -> {
            Optional<Color> result = new ColorPicker(this.getDialogPane().getScene().getWindow(), this.pasteChunksColor).showColorPicker();
            result.ifPresent(c -> {
                this.pasteChunksColor = c;
                this.pasteChunksColorPreview.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)c, CornerRadii.EMPTY, Insets.EMPTY)}));
            });
        });
        this.shadeCheckBox.setOnAction(e -> {
            this.shadeWaterCheckBox.setDisable(!this.shadeCheckBox.isSelected());
            this.shadeAltitudeCheckBox.setDisable(!this.shadeCheckBox.isSelected());
        });
        this.shadeWaterCheckBox.setDisable(!this.shadeCheckBox.isSelected() || this.caves.isSelected() || this.layerOnly.isSelected());
        this.shadeAltitudeCheckBox.setDisable(!this.shadeCheckBox.isSelected() || this.caves.isSelected() || this.layerOnly.isSelected());
        this.shadeCheckBox.setDisable(this.caves.isSelected() || this.layerOnly.isSelected());
        this.layerOnly.setOnAction(e -> this.caves.setDisable(this.layerOnly.isSelected()));
        this.caves.setDisable(this.layerOnly.isSelected());
        this.layerOnly.setDisable(this.caves.isSelected());
        this.caves.setOnAction(e -> {
            this.layerOnly.setDisable(this.caves.isSelected());
            this.shadeCheckBox.setDisable(this.caves.isSelected());
            this.shadeWaterCheckBox.setDisable(!this.shadeCheckBox.isSelected() || this.caves.isSelected() || this.layerOnly.isSelected());
            this.shadeAltitudeCheckBox.setDisable(!this.shadeCheckBox.isSelected() || this.caves.isSelected() || this.layerOnly.isSelected());
        });
        this.layerOnly.setOnAction(e -> {
            this.caves.setDisable(this.layerOnly.isSelected());
            this.shadeCheckBox.setDisable(this.layerOnly.isSelected());
            this.shadeWaterCheckBox.setDisable(!this.shadeCheckBox.isSelected() || this.caves.isSelected() || this.layerOnly.isSelected());
            this.shadeAltitudeCheckBox.setDisable(!this.shadeCheckBox.isSelected() || this.caves.isSelected() || this.layerOnly.isSelected());
        });
        HBox debugBox = new HBox();
        debugBox.getStyleClass().add((Object)"debug-box");
        Hyperlink logFileLink = UIFactory.explorerLink(Translation.DIALOG_SETTINGS_GLOBAL_MISC_SHOW_LOG_FILE, Config.BASE_LOG_DIR, null);
        debugBox.getChildren().addAll((Object[])new Node[]{this.debugCheckBox, logFileLink});
        if (ConfigProvider.WORLD.getWorldDirs() != null) {
            WorldDirectories worldDirectories = ConfigProvider.WORLD.getWorldDirs().clone();
            this.poiField.setFile(worldDirectories.getPoi());
            this.entitiesField.setFile(worldDirectories.getEntities());
        }
        this.hSlider.setMajorTickUnit(64);
        this.hSlider.setAlignment(Pos.CENTER_LEFT);
        this.toggleGroup.selectedToggleProperty().addListener((v, o, n) -> {
            if (n == null) {
                this.toggleGroup.selectToggle(o);
            } else {
                this.tabPane.getSelectionModel().select((Object)((Tab)n.getUserData()));
            }
        });
        HBox leftTabs = new HBox();
        leftTabs.getStyleClass().add((Object)"tab-box");
        HBox rightTabs = new HBox();
        rightTabs.getStyleClass().add((Object)"tab-box");
        Tab globalTab = UIFactory.tab(Translation.DIALOG_SETTINGS_TAB_GLOBAL);
        VBox globalBox = new VBox();
        GridPane languageGrid = this.createGrid();
        this.addPairToGrid(languageGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_GLOBAL_LANGUAGE_LANGUAGE), new Node[]{this.languages});
        BorderedTitledPane lang = new BorderedTitledPane(Translation.DIALOG_SETTINGS_GLOBAL_LANGUAGE, (Node)languageGrid);
        GridPane selectionsGrid = this.createGrid();
        this.addPairToGrid(selectionsGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_GLOBAL_SELECTION_REGION_COLOR), new Node[]{this.regionSelectionColorPreview});
        this.addPairToGrid(selectionsGrid, 1, UIFactory.label(Translation.DIALOG_SETTINGS_GLOBAL_SELECTION_CHUNK_COLOR), new Node[]{this.chunkSelectionColorPreview});
        this.addPairToGrid(selectionsGrid, 2, UIFactory.label(Translation.DIALOG_SETTINGS_GLOBAL_SELECTION_PASTED_CHUNKS_COLOR), new Node[]{this.pasteChunksColorPreview});
        BorderedTitledPane selections = new BorderedTitledPane(Translation.DIALOG_SETTINGS_GLOBAL_SELECTION, (Node)selectionsGrid);
        GridPane miscGrid = this.createGrid();
        this.addPairToGrid(miscGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_GLOBAL_MISC_MC_SAVES_DIR), new Node[]{this.mcSavesDir});
        this.addPairToGrid(miscGrid, 1, UIFactory.label(Translation.DIALOG_SETTINGS_GLOBAL_MISC_PRINT_DEBUG), new Node[]{debugBox});
        BorderedTitledPane misc = new BorderedTitledPane(Translation.DIALOG_SETTINGS_GLOBAL_MISC, (Node)miscGrid);
        globalBox.getChildren().addAll((Object[])new Node[]{lang, selections, misc});
        globalTab.setContent((Node)globalBox);
        ToggleButton globalToggleButton = this.createToggleButton(globalTab, Translation.DIALOG_SETTINGS_TAB_GLOBAL);
        leftTabs.getChildren().add((Object)globalToggleButton);
        Tab processingTab = UIFactory.tab(Translation.DIALOG_SETTINGS_TAB_PROCESSING);
        VBox processingBox = new VBox();
        GridPane threadGrid = this.createGrid();
        this.addPairToGrid(threadGrid, 1, UIFactory.label(Translation.DIALOG_SETTINGS_PROCESSING_PROCESS_PROCESS_THREADS), new Node[]{this.processThreadsSlider, UIFactory.attachTextFieldToSlider(this.processThreadsSlider)});
        this.addPairToGrid(threadGrid, 2, UIFactory.label(Translation.DIALOG_SETTINGS_PROCESSING_PROCESS_WRITE_THREADS), new Node[]{this.writeThreadsSlider, UIFactory.attachTextFieldToSlider(this.writeThreadsSlider)});
        BorderedTitledPane threads = new BorderedTitledPane(Translation.DIALOG_SETTINGS_PROCESSING_PROCESS, (Node)threadGrid);
        GridPane filesGrid = this.createGrid();
        this.addPairToGrid(filesGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_PROCESSING_FILES_MAX_FILES), new Node[]{this.maxLoadedFilesSlider, UIFactory.attachTextFieldToSlider(this.maxLoadedFilesSlider)});
        BorderedTitledPane files = new BorderedTitledPane(Translation.DIALOG_SETTINGS_PROCESSING_FILES, (Node)filesGrid);
        processingBox.getChildren().addAll((Object[])new Node[]{threads, files});
        processingTab.setContent((Node)processingBox);
        leftTabs.getChildren().add((Object)this.createToggleButton(processingTab, Translation.DIALOG_SETTINGS_TAB_PROCESSING));
        Tab renderingTab = UIFactory.tab(Translation.DIALOG_SETTINGS_TAB_RENDERING);
        VBox renderingBox = new VBox();
        HBox shadingAndSmooth = new HBox();
        GridPane shadingGrid = this.createGrid();
        this.addPairToGrid(shadingGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_SHADE_SHADE), new Node[]{this.shadeCheckBox});
        this.addPairToGrid(shadingGrid, 1, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_SHADE_SHADE_WATER), new Node[]{this.shadeWaterCheckBox});
        this.addPairToGrid(shadingGrid, 2, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_SHADE_SHADE_ALTITUDE), new Node[]{this.shadeAltitudeCheckBox});
        BorderedTitledPane shade = new BorderedTitledPane(Translation.DIALOG_SETTINGS_RENDERING_SHADE, (Node)shadingGrid);
        GridPane smoothGrid = this.createGrid();
        this.addPairToGrid(smoothGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_SMOOTH_SMOOTH_RENDERING), new Node[]{this.smoothRendering});
        this.addPairToGrid(smoothGrid, 1, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_SMOOTH_SMOOTH_OVERLAYS), new Node[]{this.smoothOverlays});
        BorderedTitledPane smooth = new BorderedTitledPane(Translation.DIALOG_SETTINGS_RENDERING_SMOOTH, (Node)smoothGrid);
        HBox.setHgrow((Node)shade, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)smooth, (Priority)Priority.ALWAYS);
        shadingAndSmooth.getChildren().addAll((Object[])new Node[]{shade, smooth});
        GridPane layerGrid = this.createGrid();
        this.addPairToGrid(layerGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_LAYERS_RENDER_HEIGHT), new Node[]{this.hSlider});
        this.addPairToGrid(layerGrid, 1, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_LAYERS_RENDER_LAYER_ONLY), new Node[]{this.layerOnly});
        this.addPairToGrid(layerGrid, 2, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_LAYERS_RENDER_CAVES), new Node[]{this.caves});
        BorderedTitledPane layers = new BorderedTitledPane(Translation.DIALOG_SETTINGS_RENDERING_LAYERS, (Node)layerGrid);
        GridPane backgroundGrid = this.createGrid();
        this.addPairToGrid(backgroundGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_BACKGROUND_BACKGROUND_PATTERN), new Node[]{this.tileMapBackgrounds});
        this.addPairToGrid(backgroundGrid, 1, UIFactory.label(Translation.DIALOG_SETTINGS_RENDERING_BACKGROUND_SHOW_NONEXISTENT_REGIONS), new Node[]{this.showNonexistentRegionsCheckBox});
        BorderedTitledPane background = new BorderedTitledPane(Translation.DIALOG_SETTINGS_RENDERING_BACKGROUND, (Node)backgroundGrid);
        renderingBox.getChildren().addAll((Object[])new Node[]{shadingAndSmooth, layers, background});
        renderingTab.setContent((Node)renderingBox);
        ToggleButton renderingToggleButton = this.createToggleButton(renderingTab, Translation.DIALOG_SETTINGS_TAB_RENDERING);
        rightTabs.getChildren().add((Object)renderingToggleButton);
        Tab worldTab = UIFactory.tab(Translation.DIALOG_SETTINGS_TAB_WORLD);
        VBox worldBox = new VBox();
        GridPane worldGrid = this.createGrid();
        this.addPairToGrid(worldGrid, 0, UIFactory.label(Translation.DIALOG_SETTINGS_WORLD_PATHS_POI), new Node[]{this.poiField});
        this.addPairToGrid(worldGrid, 1, UIFactory.label(Translation.DIALOG_SETTINGS_WORLD_PATHS_ENTITIES), new Node[]{this.entitiesField});
        BorderedTitledPane world = new BorderedTitledPane(Translation.DIALOG_SETTINGS_WORLD_PATHS, (Node)worldGrid);
        worldBox.getChildren().addAll((Object[])new Node[]{world});
        worldTab.setContent((Node)worldBox);
        ToggleButton worldToggleButton = this.createToggleButton(worldTab, Translation.DIALOG_SETTINGS_TAB_WORLD);
        rightTabs.getChildren().add((Object)worldToggleButton);
        renderingTab.setDisable(ConfigProvider.WORLD.getWorldDirs() == null);
        worldTab.setDisable(ConfigProvider.WORLD.getWorldDirs() == null);
        renderingToggleButton.setDisable(ConfigProvider.WORLD.getWorldDirs() == null);
        worldToggleButton.setDisable(ConfigProvider.WORLD.getWorldDirs() == null);
        this.tabPane.getTabs().addAll((Object[])new Tab[]{globalTab, processingTab, renderingTab, worldTab});
        DataProperty<Tab> focusedTab = new DataProperty<Tab>(globalTab);
        if (ConfigProvider.WORLD.getWorldDirs() != null && renderSettings) {
            focusedTab.set(renderingTab);
            this.toggleGroup.selectToggle((Toggle)renderingToggleButton);
        } else {
            this.toggleGroup.selectToggle((Toggle)globalToggleButton);
        }
        Platform.runLater(() -> ((Tab)focusedTab.get()).getContent().requestFocus());
        this.tabBox.setLeft((Node)leftTabs);
        this.tabBox.setRight((Node)rightTabs);
        VBox content = new VBox();
        content.getChildren().addAll((Object[])new Node[]{this.tabBox, this.tabPane});
        this.getDialogPane().setContent((Node)content);
        this.setResultConverter(c -> {
            if (c.getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                return new Result((Locale)this.languages.getSelectionModel().getSelectedItem(), (int)this.processThreadsSlider.getValue(), (int)this.writeThreadsSlider.getValue(), (int)this.maxLoadedFilesSlider.getValue(), this.regionSelectionColor, this.chunkSelectionColor, this.pasteChunksColor, this.shadeCheckBox.isSelected(), this.shadeWaterCheckBox.isSelected(), this.shadeAltitudeCheckBox.isSelected(), this.showNonexistentRegionsCheckBox.isSelected(), this.smoothRendering.isSelected(), this.smoothOverlays.isSelected(), (TileMapBox.TileMapBoxBackground)((Object)((Object)this.tileMapBackgrounds.getSelectionModel().getSelectedItem())), this.mcSavesDir.getFile(), this.debugCheckBox.isSelected(), this.hSlider.getValue(), this.layerOnly.isSelected(), this.caves.isSelected(), this.poiField.getFile(), this.entitiesField.getFile());
            }
            return null;
        });
        this.getDialogPane().getStylesheets().add((Object)Objects.requireNonNull(SettingsDialog.class.getClassLoader().getResource("style/component/settings-dialog.css")).toExternalForm());
    }

    private <T extends Node> T withAlignment(T node) {
        GridPane.setFillWidth(node, (Boolean)true);
        return node;
    }

    private ToggleButton createToggleButton(Tab tab, Translation name) {
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.textProperty().bind((ObservableValue)name.getProperty());
        toggleButton.setToggleGroup(this.toggleGroup);
        toggleButton.setUserData((Object)tab);
        return toggleButton;
    }

    private GridPane createGrid() {
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"slider-grid-pane");
        return grid;
    }

    private void addPairToGrid(GridPane grid, int y, Label key, Node ... value) {
        if (value.length == 0 || value.length > 2) {
            throw new IllegalArgumentException("invalid number of arguments (" + value.length + ") for addPairToGrid");
        }
        grid.add((Node)key, 0, y, 1, 1);
        for (int i = 0; i < value.length; ++i) {
            grid.add(this.withAlignment(value[i]), i + 1, y, value.length == 1 ? 2 : 1, 1);
        }
    }

    private Slider createSlider(int min, int max, int steps, int init) {
        if (max < min) {
            max = min;
        }
        Slider slider = new Slider((double)min, (double)max, (double)init);
        int majorTicks = Math.max((max - min) / 5, 1);
        slider.setMajorTickUnit((double)majorTicks);
        slider.setMinorTickCount(majorTicks - 1);
        slider.setBlockIncrement((double)steps);
        return slider;
    }

    public static class Result {
        public final int processThreads;
        public final int writeThreads;
        public final int maxLoadedFiles;
        public final Color regionColor;
        public final Color chunkColor;
        public final Color pasteColor;
        public final boolean shade;
        public final boolean shadeWater;
        public final boolean shadeAltitude;
        public final boolean showNonexistentRegions;
        public final boolean smoothRendering;
        public final boolean smoothOverlays;
        public final TileMapBox.TileMapBoxBackground tileMapBackground;
        public final File mcSavesDir;
        public final boolean debug;
        public final Locale locale;
        public final int height;
        public final boolean layerOnly;
        public final boolean caves;
        public final File poi;
        public final File entities;

        public Result(Locale locale, int processThreads, int writeThreads, int maxLoadedFiles, Color regionColor, Color chunkColor, Color pasteColor, boolean shade, boolean shadeWater, boolean shadeAltitude, boolean showNonexistentRegions, boolean smoothRendering, boolean smoothOverlays, TileMapBox.TileMapBoxBackground tileMapBackground, File mcSavesDir, boolean debug, int height, boolean layerOnly, boolean caves, File poi, File entities) {
            this.locale = locale;
            this.processThreads = processThreads;
            this.writeThreads = writeThreads;
            this.maxLoadedFiles = maxLoadedFiles;
            this.regionColor = regionColor;
            this.chunkColor = chunkColor;
            this.pasteColor = pasteColor;
            this.shade = shade;
            this.shadeWater = shadeWater;
            this.shadeAltitude = shadeAltitude;
            this.showNonexistentRegions = showNonexistentRegions;
            this.smoothRendering = smoothRendering;
            this.smoothOverlays = smoothOverlays;
            this.tileMapBackground = tileMapBackground;
            this.mcSavesDir = Objects.requireNonNullElseGet(mcSavesDir, () -> new File(GlobalConfig.DEFAULT_MC_SAVES_DIR));
            this.debug = debug;
            this.height = height;
            this.layerOnly = layerOnly;
            this.caves = caves;
            this.poi = poi;
            this.entities = entities;
        }
    }
}

