/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.util.range;

import java.util.function.Consumer;

public class Range {
    private int from;
    private int to;

    public Range(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setTo(int to) {
        this.to = to;
    }

    public int num() {
        return this.to - this.from + 1;
    }

    public Range limit(Range range) {
        if (this.from > this.to) {
            this.from = range.from;
            this.to = range.to;
        } else {
            this.from = Math.max(this.from, range.from);
            this.to = Math.min(this.to, range.to);
        }
        return this;
    }

    public boolean contains(int value) {
        return this.from <= value && this.to >= value;
    }

    public boolean isMaxRange() {
        return this.from == Integer.MIN_VALUE && this.to == Integer.MAX_VALUE;
    }

    public void forEach(Consumer<Integer> iteration, int min, int max) {
        int m = Math.min(this.to, max);
        for (int i = Math.max(this.from, min); i < m; ++i) {
            iteration.accept(i);
        }
    }

    public String toString() {
        if (this.from == this.to) {
            return "" + this.from;
        }
        return String.valueOf(this.from == Integer.MIN_VALUE ? "" : Integer.valueOf(this.from)) + ":" + String.valueOf(this.to == Integer.MAX_VALUE ? "" : Integer.valueOf(this.to));
    }
}

