/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_13;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.math.Bits;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.Tag;

public class ChunkFilter_17w47a {

    @MCVersionImplementation(value=1451)
    public static class Heightmap
    implements ChunkFilter.Heightmap {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        private static final Set<String> heightmapData = FileHelper.loadFromResource("mapping/java_1_13/heightmaps_legacy.json", r -> GSON.fromJson((Reader)r, new TypeToken<Set<String>>(){}));

        @Override
        public void worldSurface(ChunkData data) {
            this.setHeightMap(Helper.getRegion(data), this.getHeightMap(Helper.getRegion(data), b -> {
                String name = Helper.stringFromCompound(b, "Name");
                return name == null || !heightmapData.contains(name);
            }));
        }

        @Override
        public void oceanFloor(ChunkData data) {
        }

        @Override
        public void motionBlocking(ChunkData data) {
        }

        @Override
        public void motionBlockingNoLeaves(ChunkData data) {
        }

        protected void setHeightMap(CompoundTag data, int[] heightmap) {
            if (data == null) {
                return;
            }
            CompoundTag level = data.getCompoundTag("Level");
            if (level == null) {
                return;
            }
            level.putIntArray("HeightMap", heightmap);
        }

        protected int[] getHeightMap(CompoundTag data, Predicate<CompoundTag> matcher) {
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(data, "Sections");
            if (sections == null) {
                return new int[256];
            }
            ListTag[] palettes = new ListTag[16];
            long[][] blockStatesArray = new long[16][];
            sections.forEach(s -> {
                ListTag p = (ListTag)Helper.tagFromCompound(s, "Palette");
                long[] b = Helper.longArrayFromCompound(s, "BlockStates");
                int y = Helper.numberFromCompound(s, "Y", -1).intValue();
                if (y >= 0 && y <= 15 && p != null && b != null) {
                    palettes[y] = p;
                    blockStatesArray[y] = b;
                }
            });
            int[] heightmap = new int[256];
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (int i = 15; i >= 0; --i) {
                        ListTag palette = palettes[i];
                        if (palette == null) continue;
                        long[] blockStates = blockStatesArray[i];
                        for (int cy = 15; cy >= 0; --cy) {
                            int blockIndex = cy * 256 + cz * 16 + cx;
                            if (!matcher.test(this.getBlockAt(blockIndex, blockStates, palette))) continue;
                            heightmap[cz * 16 + cx] = (short)(i * 16 + cy + 1);
                            continue block1;
                        }
                    }
                }
            }
            return heightmap;
        }

        protected CompoundTag getBlockAt(int index, long[] blockStates, ListTag palette) {
            return palette.getCompound(this.getPaletteIndex(index, blockStates));
        }

        protected int getPaletteIndex(int blockIndex, long[] blockStates) {
            int bits = blockStates.length >> 6;
            double blockStatesIndex = (double)blockIndex / (4096.0 / (double)blockStates.length);
            int longIndex = (int)blockStatesIndex;
            int startBit = (int)((blockStatesIndex - Math.floor(blockStatesIndex)) * 64.0);
            if (startBit + bits > 64) {
                long prev = Bits.bitRange(blockStates[longIndex], startBit, 64);
                long next = Bits.bitRange(blockStates[longIndex + 1], 0, startBit + bits - 64);
                return (int)((next << 64 - startBit) + prev);
            }
            return (int)Bits.bitRange(blockStates[longIndex], startBit, startBit + bits);
        }
    }

    @MCVersionImplementation(value=1451)
    public static class Palette
    implements ChunkFilter.Palette {
        @Override
        public boolean paletteEquals(ChunkData data, Collection<String> names) {
            ListTag sections = Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections", null);
            if (sections == null) {
                return false;
            }
            HashSet<String> blocks = new HashSet<String>();
            for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                ListTag palette = Helper.tagFromCompound(t, "Palette", null);
                if (palette == null) continue;
                for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                    String n = Helper.stringFromCompound(p, "Name");
                    if (n == null) continue;
                    if (!names.contains(n)) {
                        return false;
                    }
                    blocks.add(n);
                }
            }
            if (blocks.size() != names.size()) {
                return false;
            }
            for (String name : names) {
                if (blocks.contains(name)) continue;
                return false;
            }
            return true;
        }
    }

    @MCVersionImplementation(value=1451)
    public static class Blocks
    implements ChunkFilter.Blocks {
        @Override
        public boolean matchBlockNames(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            int c = 0;
            block0: for (String name : names) {
                for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                    ListTag palette = (ListTag)Helper.tagFromCompound(t, "Palette");
                    if (palette == null) continue;
                    for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                        if (!name.equals(Helper.stringFromCompound(p, "Name"))) continue;
                        ++c;
                        continue block0;
                    }
                }
            }
            return names.size() == c;
        }

        @Override
        public boolean matchAnyBlockName(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            for (String name : names) {
                for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                    ListTag palette = (ListTag)Helper.tagFromCompound(t, "Palette");
                    if (palette == null) continue;
                    for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                        if (!name.equals(Helper.stringFromCompound(p, "Name"))) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void replaceBlocks(ChunkData data, Map<String, ChunkFilter.BlockReplaceData> replace) {
            ListTag tileEntities;
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            ListTag sections = (ListTag)Helper.tagFromCompound(level, "Sections");
            if (sections == null) {
                return;
            }
            Point2i pos = Helper.point2iFromCompound(level, "xPos", "zPos");
            if (pos == null) {
                return;
            }
            pos = pos.chunkToBlock();
            if (replace.containsKey("minecraft:air")) {
                HashMap<Integer, CompoundTag> sectionMap = new HashMap<Integer, CompoundTag>();
                ArrayList<Integer> heights = new ArrayList<Integer>(18);
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    sectionMap.put(section.getInt("Y"), section);
                    heights.add(section.getInt("Y"));
                }
                for (int y = 0; y < 16; ++y) {
                    CompoundTag section;
                    if (!sectionMap.containsKey(y)) {
                        sectionMap.put(y, this.createEmptySection(y));
                        heights.add(y);
                        continue;
                    }
                    section = (CompoundTag)sectionMap.get(y);
                    if (section.containsKey("BlockStates") && section.containsKey("Palette")) continue;
                    sectionMap.put(y, this.createEmptySection(y));
                }
                heights.sort(Integer::compareTo);
                sections.clear();
                Iterator y = heights.iterator();
                while (y.hasNext()) {
                    int height = (Integer)y.next();
                    sections.add((Tag)sectionMap.get(height));
                }
            }
            if ((tileEntities = (ListTag)Helper.tagFromCompound(level, "TileEntities", null)) == null) {
                tileEntities = new ListTag();
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                int y;
                long[] blockStates;
                ListTag palette = Helper.tagFromCompound(section, "Palette", null);
                if (palette == null || (blockStates = Helper.longArrayFromCompound(section, "BlockStates")) == null || (y = Helper.numberFromCompound(section, "Y", -1).intValue()) < 0 || y > 15) continue;
                section.remove("BlockLight");
                section.remove("SkyLight");
                for (int i = 0; i < 4096; ++i) {
                    CompoundTag blockState = this.getBlockAt(i, blockStates, palette);
                    block9: for (Map.Entry<String, ChunkFilter.BlockReplaceData> entry : replace.entrySet()) {
                        if (!blockState.getString("Name").matches(entry.getKey())) continue;
                        ChunkFilter.BlockReplaceData replacement = entry.getValue();
                        try {
                            blockStates = this.setBlockAt(i, replacement.getState(), blockStates, palette);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("failed to set block in section " + y, ex);
                        }
                        Point3i location = this.indexToLocation(i).add(pos.getX(), y * 16, pos.getZ());
                        if (replacement.getTile() != null) {
                            CompoundTag tile = replacement.getTile().copy();
                            tile.putInt("x", location.getX());
                            tile.putInt("y", location.getY());
                            tile.putInt("z", location.getZ());
                            tileEntities.add(tile);
                            continue;
                        }
                        if (tileEntities.isEmpty()) continue;
                        for (int t = 0; t < tileEntities.size(); ++t) {
                            CompoundTag tile = tileEntities.getCompound(t);
                            if (tile.getInt("x") != location.getX() || tile.getInt("y") != location.getY() || tile.getInt("z") != location.getZ()) continue;
                            tileEntities.remove(t);
                            continue block9;
                        }
                    }
                }
                try {
                    blockStates = this.cleanupPalette(blockStates, palette);
                }
                catch (Exception ex) {
                    throw new RuntimeException("failed to cleanup section " + y, ex);
                }
                section.putLongArray("BlockStates", blockStates);
            }
            level.put("TileEntities", tileEntities);
        }

        protected Point3i indexToLocation(int i) {
            int x = i & 0xF;
            int z = i - x >> 4 & 0xF;
            int y = i - z * 16 - x >> 8;
            return new Point3i(x, y, z);
        }

        protected CompoundTag getBlockAt(int index, long[] blockStates, ListTag palette) {
            return palette.getCompound(this.getPaletteIndex(index, blockStates));
        }

        protected long[] setBlockAt(int index, CompoundTag blockState, long[] blockStates, ListTag palette) {
            int paletteIndex = -1;
            for (int i = 0; i < palette.size(); ++i) {
                if (!palette.get(i).equals(blockState)) continue;
                paletteIndex = i;
                break;
            }
            if (paletteIndex == -1) {
                palette.add(blockState);
                paletteIndex = palette.size() - 1;
                if ((paletteIndex & paletteIndex - 1) == 0) {
                    blockStates = this.adjustBlockStateBits(palette, blockStates, null);
                }
            }
            this.setPaletteIndex(index, paletteIndex, blockStates);
            return blockStates;
        }

        protected int getPaletteIndex(int blockIndex, long[] blockStates) {
            int bits = blockStates.length >> 6;
            double blockStatesIndex = (double)blockIndex / (4096.0 / (double)blockStates.length);
            int longIndex = (int)blockStatesIndex;
            int startBit = (int)((blockStatesIndex - Math.floor(blockStatesIndex)) * 64.0);
            if (startBit + bits > 64) {
                long prev = Bits.bitRange(blockStates[longIndex], startBit, 64);
                long next = Bits.bitRange(blockStates[longIndex + 1], 0, startBit + bits - 64);
                return (int)((next << 64 - startBit) + prev);
            }
            return (int)Bits.bitRange(blockStates[longIndex], startBit, startBit + bits);
        }

        protected void setPaletteIndex(int blockIndex, int paletteIndex, long[] blockStates) {
            double blockStatesIndex = (double)blockIndex / (4096.0 / (double)blockStates.length);
            int longIndex = (int)blockStatesIndex;
            int startBit = (int)((blockStatesIndex - (double)longIndex) * 64.0);
            int bits = blockStates.length >> 6;
            if (startBit + bits > 64) {
                blockStates[longIndex] = Bits.setBits(paletteIndex, blockStates[longIndex], startBit, 64);
                blockStates[longIndex + 1] = Bits.setBits(paletteIndex >> 64 - startBit, blockStates[longIndex + 1], 0, startBit + bits - 64);
            } else {
                blockStates[longIndex] = Bits.setBits(paletteIndex, blockStates[longIndex], startBit, startBit + bits);
            }
        }

        protected long[] adjustBlockStateBits(ListTag palette, long[] blockStates, Map<Integer, Integer> oldToNewMapping) {
            int newBits = 32 - Integer.numberOfLeadingZeros(palette.size() - 1);
            long[] newBlockStates = (newBits = Math.max(newBits, 4)) == blockStates.length / 64 ? blockStates : new long[newBits * 64];
            if (oldToNewMapping != null) {
                for (int i = 0; i < 4096; ++i) {
                    this.setPaletteIndex(i, oldToNewMapping.get(this.getPaletteIndex(i, blockStates)), newBlockStates);
                }
            } else {
                for (int i = 0; i < 4096; ++i) {
                    this.setPaletteIndex(i, this.getPaletteIndex(i, blockStates), newBlockStates);
                }
            }
            return newBlockStates;
        }

        protected long[] cleanupPalette(long[] blockStates, ListTag palette) {
            HashMap<Integer, Integer> allIndices = new HashMap<Integer, Integer>(palette.size());
            for (int i = 0; i < 4096; ++i) {
                int paletteIndex = this.getPaletteIndex(i, blockStates);
                allIndices.put(paletteIndex, paletteIndex);
            }
            int oldIndex = 0;
            for (int i = 0; i < palette.size(); ++i) {
                if (!allIndices.containsKey(oldIndex)) {
                    palette.remove(i);
                    --i;
                } else {
                    allIndices.put(oldIndex, i);
                }
                ++oldIndex;
            }
            if (!this.paletteContainsAir(palette)) {
                CompoundTag air = new CompoundTag();
                air.putString("Name", "minecraft:air");
                palette.add(air);
            }
            return this.adjustBlockStateBits(palette, blockStates, allIndices);
        }

        protected boolean paletteContainsAir(ListTag palette) {
            for (int i = 0; i < palette.size(); ++i) {
                if (!palette.getCompound(i).getString("Name").equals("minecraft:air")) continue;
                return true;
            }
            return false;
        }

        protected CompoundTag createEmptySection(int y) {
            CompoundTag newSection = new CompoundTag();
            newSection.putByte("Y", (byte)y);
            newSection.putLongArray("BlockStates", new long[256]);
            ListTag newPalette = new ListTag();
            CompoundTag newBlockState = new CompoundTag();
            newBlockState.putString("Name", "minecraft:air");
            newPalette.add(newBlockState);
            newSection.put("Palette", newPalette);
            return newSection;
        }

        @Override
        public int getBlockAmount(ChunkData data, String[] blocks) {
            ListTag sections = Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections", null);
            if (sections == null) {
                return 0;
            }
            int result = 0;
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                ListTag palette = Helper.tagFromCompound(section, "Palette", null);
                if (palette == null) continue;
                block1: for (int i = 0; i < palette.size(); ++i) {
                    CompoundTag blockState = palette.getCompound(i);
                    String name = Helper.stringFromCompound(blockState, "Name");
                    if (name == null) continue;
                    for (String block : blocks) {
                        if (!name.equals(block)) continue;
                        long[] blockStates = Helper.longArrayFromCompound(section, "BlockStates");
                        if (blockStates == null) continue block1;
                        for (int k = 0; k < 4096; ++k) {
                            if (blockState != this.getBlockAt(k, blockStates, palette)) continue;
                            ++result;
                        }
                        continue block1;
                    }
                }
            }
            return result;
        }

        @Override
        public int getAverageHeight(ChunkData data) {
            ListTag sections = Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections", null);
            if (sections == null) {
                return 0;
            }
            sections.sort(this::filterSections);
            int totalHeight = 0;
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                        Number height;
                        long[] blockStates;
                        ListTag palette = Helper.tagFromCompound(section, "Palette", null);
                        if (palette == null || (blockStates = Helper.longArrayFromCompound(section, "BlockStates")) == null || (height = Helper.numberFromCompound(section, "Y", null)) == null) continue;
                        for (int cy = 15; cy >= 0; --cy) {
                            int index = cy * 256 + cz * 16 + cx;
                            CompoundTag block = this.getBlockAt(index, blockStates, palette);
                            if (this.isEmpty(block)) continue;
                            totalHeight += height.intValue() * 16 + cy;
                            continue block1;
                        }
                    }
                }
            }
            return totalHeight / 256;
        }

        protected boolean isEmpty(CompoundTag blockData) {
            return switch (Helper.stringFromCompound(blockData, "Name", "")) {
                case "minecraft:air", "minecraft:cave_air", "minecraft:barrier", "minecraft:structure_void" -> {
                    if (blockData.size() == 1) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        protected int filterSections(Tag sectionA, Tag sectionB) {
            return Helper.numberFromCompound(sectionB, "Y", -1).intValue() - Helper.numberFromCompound(sectionA, "Y", -1).intValue();
        }
    }
}

