/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_13;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.math.Bits;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.validation.ValidationHelper;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.mapping.registry.BiomeRegistry;
import net.querz.mcaselector.version.mapping.registry.StatusRegistry;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;

public class ChunkFilter_18w06a {

    @MCVersionImplementation(value=1466)
    public static class Heightmap
    implements ChunkFilter.Heightmap {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        private HeightmapData heightmaps;

        public Heightmap() {
            this.loadCfg();
        }

        protected void loadCfg() {
            this.heightmaps = FileHelper.loadFromResource("mapping/java_1_13/heightmaps_18w06a.json", r -> GSON.fromJson((Reader)r, new TypeToken<HeightmapData>(this){}));
        }

        @Override
        public void worldSurface(ChunkData data) {
            this.setHeightMap(Helper.getRegion(data), "LIGHT", this.getHeightMap(Helper.getRegion(data), b -> {
                String name = Helper.stringFromCompound(b, "Name");
                return name != null && this.heightmaps.light.contains(name);
            }));
        }

        @Override
        public void oceanFloor(ChunkData data) {
        }

        @Override
        public void motionBlocking(ChunkData data) {
            this.setHeightMap(Helper.getRegion(data), "RAIN", this.getHeightMap(Helper.getRegion(data), b -> {
                String name = Helper.stringFromCompound(b, "Name");
                return name != null && this.heightmaps.rain.contains(name);
            }));
        }

        @Override
        public void motionBlockingNoLeaves(ChunkData data) {
        }

        protected void setHeightMap(CompoundTag root, String name, long[] heightmap) {
            if (root == null) {
                return;
            }
            CompoundTag level = Helper.levelFromRoot(root);
            if (level == null) {
                return;
            }
            CompoundTag heightmapTag = (CompoundTag)level.computeIfAbsent("Heightmaps", k -> new CompoundTag());
            heightmapTag.putLongArray(name, heightmap);
        }

        protected long[] getHeightMap(CompoundTag root, Predicate<CompoundTag> matcher) {
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(root, "Sections");
            if (sections == null) {
                return new long[36];
            }
            ListTag[] palettes = new ListTag[16];
            long[][] blockStatesArray = new long[16][];
            sections.forEach(s -> {
                ListTag p = (ListTag)Helper.tagFromCompound(s, "Palette");
                long[] b = Helper.longArrayFromCompound(s, "BlockStates");
                int y = Helper.numberFromCompound(s, "Y", -1).intValue();
                if (y >= 0 && y <= 15 && p != null && b != null) {
                    palettes[y] = p;
                    blockStatesArray[y] = b;
                }
            });
            short[] heightmap = new short[256];
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (int i = 15; i >= 0; --i) {
                        ListTag palette = palettes[i];
                        if (palette == null) continue;
                        long[] blockStates = blockStatesArray[i];
                        for (int cy = 15; cy >= 0; --cy) {
                            int blockIndex = cy * 256 + cz * 16 + cx;
                            if (!matcher.test(this.getBlockAt(blockIndex, blockStates, palette))) continue;
                            heightmap[cz * 16 + cx] = (short)(i * 16 + cy + 1);
                            continue block1;
                        }
                    }
                }
            }
            return this.applyHeightMap(heightmap);
        }

        protected long[] applyHeightMap(short[] rawHeightmap) {
            long[] data = new long[36];
            int offset = 0;
            int index = 0;
            for (int i = 0; i < 36; ++i) {
                long l = 0L;
                for (int j = 0; j < 8 && index < 256; ++j, ++index) {
                    int shift = 9 * j - offset;
                    if (shift < 0) {
                        l += (long)rawHeightmap[index] >> -shift;
                        continue;
                    }
                    l += (long)rawHeightmap[index] << shift;
                }
                if (++offset == 9) {
                    offset = 0;
                } else {
                    --index;
                }
                data[i] = l;
            }
            return data;
        }

        protected CompoundTag getBlockAt(int index, long[] blockStates, ListTag palette) {
            return palette.getCompound(this.getPaletteIndex(index, blockStates));
        }

        protected int getPaletteIndex(int blockIndex, long[] blockStates) {
            int bits = blockStates.length >> 6;
            double blockStatesIndex = (double)blockIndex / (4096.0 / (double)blockStates.length);
            int longIndex = (int)blockStatesIndex;
            int startBit = (int)((blockStatesIndex - Math.floor(blockStatesIndex)) * 64.0);
            if (startBit + bits > 64) {
                long prev = Bits.bitRange(blockStates[longIndex], startBit, 64);
                long next = Bits.bitRange(blockStates[longIndex + 1], 0, startBit + bits - 64);
                return (int)((next << 64 - startBit) + prev);
            }
            return (int)Bits.bitRange(blockStates[longIndex], startBit, startBit + bits);
        }

        private record HeightmapData(@SerializedName(value="rain") Set<String> rain, @SerializedName(value="light") Set<String> light) {
        }
    }

    @MCVersionImplementation(value=1466)
    public static class Relocate
    implements ChunkFilter.Relocate {
        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            CompoundTag structures;
            ListTag tileTicks;
            ListTag tileEntities;
            CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
            if (level == null) {
                return false;
            }
            level.putInt("xPos", level.getInt("xPos") + offset.blockToChunk().getX());
            level.putInt("zPos", level.getInt("zPos") + offset.blockToChunk().getZ());
            ListTag entities = (ListTag)Helper.tagFromCompound(level, "Entities");
            if (entities != null) {
                entities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToEntity((CompoundTag)v, offset)));
            }
            if ((tileEntities = (ListTag)Helper.tagFromCompound(level, "TileEntities")) != null) {
                tileEntities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTileEntity((CompoundTag)v, offset)));
            }
            if ((tileTicks = (ListTag)Helper.tagFromCompound(level, "TileTicks")) != null) {
                tileTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((structures = (CompoundTag)Helper.tagFromCompound(level, "Structures")) != null) {
                ValidationHelper.catchAndLog(() -> this.applyOffsetToStructures(structures, offset));
            }
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "Lights", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "ToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "PostProcessing", offset.blockToSection()));
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(root, "Sections");
            if (sections != null) {
                ListTag newSections = new ListTag();
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    if (!this.applyOffsetToSection(section, offset.blockToSection(), new Range(0, 15))) continue;
                    newSections.add(section);
                }
                level.put("Sections", newSections);
            }
            return true;
        }

        protected void applyOffsetToEntity(CompoundTag entity, Point3i offset) {
            String id;
            if (entity == null) {
                return;
            }
            ListTag entityPos = (ListTag)Helper.tagFromCompound(entity, "Pos");
            if (entityPos != null && entityPos.size() == 3) {
                entityPos.set(0, DoubleTag.valueOf(entityPos.getDouble(0) + (double)offset.getX()));
                entityPos.set(1, DoubleTag.valueOf(entityPos.getDouble(1) + (double)offset.getY()));
                entityPos.set(2, DoubleTag.valueOf(entityPos.getDouble(2) + (double)offset.getZ()));
            }
            CompoundTag leash = (CompoundTag)Helper.tagFromCompound(entity, "Leash");
            Helper.applyIntOffsetIfRootPresent(leash, "X", "Y", "Z", offset);
            if (ValidationHelper.attempt(() -> Helper.applyIntOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset))) {
                ValidationHelper.attempt(() -> Helper.applyShortOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset));
            }
            Helper.applyIntOffsetIfRootPresent(entity, "SleepingX", "SleepingY", "SleepingZ", offset);
            switch (id = Helper.stringFromCompound(entity, "id", "")) {
                case "minecraft:dolphin": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TreasurePosX", "TreasurePosY", "TreasurePosZ", offset);
                    break;
                }
                case "minecraft:phantom": {
                    Helper.applyIntOffsetIfRootPresent(entity, "AX", "AY", "AZ", offset);
                    break;
                }
                case "minecraft:shulker": {
                    Helper.applyIntOffsetIfRootPresent(entity, "APX", "APY", "APZ", offset);
                    break;
                }
                case "minecraft:turtle": {
                    Helper.applyIntOffsetIfRootPresent(entity, "HomePosX", "HomePosY", "HomePosZ", offset);
                    Helper.applyIntOffsetIfRootPresent(entity, "TravelPosX", "TravelPosY", "TravelPosZ", offset);
                    break;
                }
                case "minecraft:vex": {
                    Helper.applyIntOffsetIfRootPresent(entity, "BoundX", "BoundY", "BoundZ", offset);
                    break;
                }
                case "minecraft:shulker_bullet": {
                    CompoundTag owner = (CompoundTag)Helper.tagFromCompound(entity, "Owner");
                    Helper.applyIntOffsetIfRootPresent(owner, "X", "Y", "Z", offset);
                    CompoundTag target = (CompoundTag)Helper.tagFromCompound(entity, "Target");
                    Helper.applyIntOffsetIfRootPresent(target, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:end_crystal": {
                    CompoundTag beamTarget = (CompoundTag)Helper.tagFromCompound(entity, "BeamTarget");
                    Helper.applyIntOffsetIfRootPresent(beamTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:item_frame": 
                case "minecraft:painting": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TileX", "TileY", "TileZ", offset);
                    break;
                }
                case "minecraft:witch": 
                case "minecraft:vindicator": 
                case "minecraft:illusioner": 
                case "minecraft:evoker": {
                    CompoundTag patrolTarget = (CompoundTag)Helper.tagFromCompound(entity, "PatrolTarget");
                    Helper.applyIntOffsetIfRootPresent(patrolTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:falling_block": {
                    CompoundTag tileEntityData = (CompoundTag)Helper.tagFromCompound(entity, "TileEntityData");
                    this.applyOffsetToTileEntity(tileEntityData, offset);
                }
            }
            ListTag passengers = (ListTag)Helper.tagFromCompound(entity, "Passengers");
            if (passengers != null) {
                passengers.forEach(p -> this.applyOffsetToEntity((CompoundTag)p, offset));
            }
            Helper.fixEntityUUID(entity);
        }

        protected void applyOffsetToStructures(CompoundTag structures, Point3i offset) {
            CompoundTag starts;
            Point3i chunkOffset = offset.blockToChunk();
            CompoundTag references = (CompoundTag)Helper.tagFromCompound(structures, "References");
            if (references != null) {
                for (Map.Entry<String, Tag> entry : references) {
                    long[] reference = ValidationHelper.silent(() -> ((LongArrayTag)entry.getValue()).getValue(), null);
                    if (reference == null) continue;
                    for (int i = 0; i < reference.length; ++i) {
                        int x = (int)reference[i];
                        int z = (int)(reference[i] >> 32);
                        reference[i] = ((long)(z + chunkOffset.getZ()) & 0xFFFFFFFFL) << 32 | (long)(x + chunkOffset.getX()) & 0xFFFFFFFFL;
                    }
                }
            }
            if ((starts = (CompoundTag)Helper.tagFromCompound(structures, "Starts")) != null) {
                for (Map.Entry<String, Tag> entry : starts) {
                    ListTag children;
                    CompoundTag structure = ValidationHelper.silent(() -> (CompoundTag)entry.getValue(), null);
                    if ("INVALID".equals(Helper.stringFromCompound(structure, "id"))) continue;
                    Helper.applyIntIfPresent(structure, "ChunkX", chunkOffset.getX());
                    Helper.applyIntIfPresent(structure, "ChunkZ", chunkOffset.getZ());
                    Helper.applyOffsetToBB(Helper.intArrayFromCompound(structure, "BB"), offset);
                    ListTag processed = (ListTag)Helper.tagFromCompound(structure, "Processed");
                    if (processed != null) {
                        for (CompoundTag chunk : processed.iterateType(CompoundTag.class)) {
                            Helper.applyIntIfPresent(chunk, "X", chunkOffset.getX());
                            Helper.applyIntIfPresent(chunk, "Z", chunkOffset.getZ());
                        }
                    }
                    if ((children = (ListTag)Helper.tagFromCompound(structure, "Children")) == null) continue;
                    for (CompoundTag child : children.iterateType(CompoundTag.class)) {
                        ListTag junctions;
                        Helper.applyIntOffsetIfRootPresent(child, "TPX", "TPY", "TPZ", offset);
                        Helper.applyIntOffsetIfRootPresent(child, "PosX", "PosY", "PosZ", offset);
                        Helper.applyOffsetToBB(Helper.intArrayFromCompound(child, "BB"), offset);
                        ListTag entrances = (ListTag)Helper.tagFromCompound(child, "Entrances");
                        if (entrances != null) {
                            entrances.forEach(e -> Helper.applyOffsetToBB(((IntArrayTag)e).getValue(), offset));
                        }
                        if ((junctions = (ListTag)Helper.tagFromCompound(child, "junctions")) == null) continue;
                        for (CompoundTag junction : junctions.iterateType(CompoundTag.class)) {
                            Helper.applyIntOffsetIfRootPresent(junction, "source_x", "source_y", "source_z", offset);
                        }
                    }
                }
            }
        }

        protected void applyOffsetToTick(CompoundTag tick, Point3i offset) {
            Helper.applyIntOffsetIfRootPresent(tick, "x", "y", "z", offset);
        }

        protected void applyOffsetToTileEntity(CompoundTag tileEntity, Point3i offset) {
            String id;
            if (tileEntity == null) {
                return;
            }
            Helper.applyIntOffsetIfRootPresent(tileEntity, "x", "y", "z", offset);
            switch (id = Helper.stringFromCompound(tileEntity, "id", "")) {
                case "minecraft:end_gateway": {
                    CompoundTag exitPortal = (CompoundTag)Helper.tagFromCompound(tileEntity, "ExitPortal");
                    Helper.applyIntOffsetIfRootPresent(exitPortal, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:structure_block": {
                    Helper.applyIntOffsetIfRootPresent(tileEntity, "posX", "posY", "posZ", offset);
                    break;
                }
                case "minecraft:mob_spawner": {
                    ListTag spawnPotentials = (ListTag)Helper.tagFromCompound(tileEntity, "SpawnPotentials");
                    if (spawnPotentials == null) break;
                    for (CompoundTag spawnPotential : spawnPotentials.iterateType(CompoundTag.class)) {
                        CompoundTag entity = (CompoundTag)Helper.tagFromCompound(spawnPotential, "Entity");
                        this.applyOffsetToEntity(entity, offset);
                    }
                    break;
                }
            }
        }
    }

    @MCVersionImplementation(value=1466)
    public static class Merge
    implements ChunkFilter.Merge {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Sections", c -> ((CompoundTag)c).getInt("Y"));
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Entities", c -> ((CompoundTag)c).getList("Pos").getInt(1) >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileEntities", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeListTagLists(source, destination, ranges, yOffset, "Lights");
            this.mergeListTagLists(source, destination, ranges, yOffset, "ToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "PostProcessing");
            this.mergeStructures(source, destination, ranges, yOffset);
            this.fixEntityUUIDs(Helper.levelFromRoot(destination));
        }

        protected void mergeStructures(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            int[] bb;
            Object child;
            int i;
            ListTag children;
            CompoundTag sourceStarts = Helper.tagFromCompound(Helper.tagFromLevelFromRoot(source, "Structures", new CompoundTag()), "Starts", new CompoundTag());
            CompoundTag destinationStarts = Helper.tagFromCompound(Helper.tagFromLevelFromRoot(destination, "Structures", new CompoundTag()), "Starts", new CompoundTag());
            if (!destinationStarts.isEmpty()) {
                block0: for (Map.Entry<String, Tag> start : destinationStarts) {
                    int[] bb2;
                    children = Helper.tagFromCompound(start.getValue(), "Children", null);
                    if (children != null) {
                        block1: for (i = 0; i < children.size(); ++i) {
                            child = children.getCompound(i);
                            bb = Helper.intArrayFromCompound((Tag)child, "BB");
                            if (bb == null || bb.length != 6) continue;
                            for (Range range : ranges) {
                                if (!range.contains(bb[1] >> 4) || !range.contains(bb[4] >> 4)) continue;
                                children.remove(i);
                                --i;
                                continue block1;
                            }
                        }
                    }
                    if (children != null && !children.isEmpty() || (bb2 = Helper.intArrayFromCompound(start.getValue(), "BB")) == null || bb2.length != 6) continue;
                    for (Range range : ranges) {
                        if (!range.contains(bb2[1] >> 4) || !range.contains(bb2[4] >> 4)) continue;
                        CompoundTag emptyStart = new CompoundTag();
                        emptyStart.putString("id", "INVALID");
                        destinationStarts.put(start.getKey(), emptyStart);
                        continue block0;
                    }
                }
            }
            for (Map.Entry<String, Tag> start : sourceStarts) {
                children = Helper.tagFromCompound(start.getValue(), "Children", null);
                if (children == null) continue;
                block5: for (i = 0; i < children.size(); ++i) {
                    child = children.getCompound(i);
                    bb = Helper.intArrayFromCompound((Tag)child, "BB");
                    if (bb == null) continue;
                    for (Range range : ranges) {
                        ListTag destinationChildren;
                        if (!range.contains(bb[1] >> 4 - yOffset) && !range.contains(bb[4] >> 4 - yOffset)) continue;
                        CompoundTag destinationStart = Helper.tagFromCompound(destinationStarts, start.getKey(), null);
                        if (destinationStart == null || "INVALID".equals(destinationStart.getString("id"))) {
                            destinationStart = ((CompoundTag)start.getValue()).copy();
                            ListTag clonedDestinationChildren = Helper.tagFromCompound(destinationStart, "Children", null);
                            if (clonedDestinationChildren != null) {
                                clonedDestinationChildren.clear();
                            }
                            destinationStarts.put(start.getKey(), destinationStart);
                        }
                        if ((destinationChildren = (ListTag)Helper.tagFromCompound(destinationStarts.get(start.getKey()), "Children", null)) == null) {
                            destinationChildren = new ListTag();
                            destinationStart.put("Children", destinationChildren);
                        }
                        destinationChildren.add(children.get(i));
                        continue block5;
                    }
                }
            }
        }

        @Override
        public CompoundTag newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
            CompoundTag root = new CompoundTag();
            CompoundTag level = new CompoundTag();
            level.putInt("xPos", absoluteLocation.getX());
            level.putInt("zPos", absoluteLocation.getZ());
            level.putString("Status", "postprocessed");
            root.put("Level", level);
            root.putInt("DataVersion", dataVersion);
            return root;
        }
    }

    @MCVersionImplementation(value=1466)
    public static class Status
    implements ChunkFilter.Status {
        @Override
        public StringTag getStatus(ChunkData data) {
            return (StringTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Status");
        }

        @Override
        public void setStatus(ChunkData data, StatusRegistry.StatusIdentifier status) {
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            if (level != null) {
                level.putString("Status", status.getStatus());
            }
        }

        @Override
        public boolean matchStatus(ChunkData data, StatusRegistry.StatusIdentifier status) {
            StringTag tag = this.getStatus(data);
            if (tag == null) {
                return false;
            }
            return status.getStatus().equals(tag.getValue());
        }
    }

    @MCVersionImplementation(value=1466)
    public static class LightPopulated
    implements ChunkFilter.LightPopulated {
        @Override
        public ByteTag getLightPopulated(ChunkData data) {
            return null;
        }

        @Override
        public void setLightPopulated(ChunkData data, byte lightPopulated) {
        }
    }

    @MCVersionImplementation(value=1466)
    public static class Biomes
    implements ChunkFilter.Biomes {
        @Override
        public boolean matchBiomes(ChunkData data, Collection<BiomeRegistry.BiomeIdentifier> biomes) {
            IntArrayTag biomesTag = (IntArrayTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Biomes");
            if (biomesTag == null) {
                return false;
            }
            block0: for (BiomeRegistry.BiomeIdentifier identifier : biomes) {
                for (int dataID : biomesTag.getValue()) {
                    if (identifier.matches(dataID)) continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean matchAnyBiome(ChunkData data, Collection<BiomeRegistry.BiomeIdentifier> biomes) {
            IntArrayTag biomesTag = (IntArrayTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Biomes");
            if (biomesTag == null) {
                return false;
            }
            for (BiomeRegistry.BiomeIdentifier identifier : biomes) {
                for (int dataID : biomesTag.getValue()) {
                    if (!identifier.matches(dataID)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void changeBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            IntArrayTag biomesTag = (IntArrayTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Biomes");
            if (biomesTag != null) {
                Arrays.fill(biomesTag.getValue(), biome.getID());
            }
        }

        @Override
        public void forceBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            if (level != null) {
                int[] biomes = new int[256];
                Arrays.fill(biomes, (int)((byte)biome.getID()));
                level.putIntArray("Biomes", biomes);
            }
        }
    }
}

