/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_13;

import java.util.List;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.validation.ValidationHelper;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.java_1_13.ChunkFilter_18w06a;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;

public class ChunkFilter_18w16a {

    @MCVersionImplementation(value=1483)
    public static class Relocate
    extends ChunkFilter_18w06a.Relocate {
        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            CompoundTag structures;
            ListTag liquidTicks;
            ListTag tileTicks;
            ListTag tileEntities;
            CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
            if (level == null) {
                return false;
            }
            level.putInt("xPos", level.getInt("xPos") + offset.blockToChunk().getX());
            level.putInt("zPos", level.getInt("zPos") + offset.blockToChunk().getZ());
            ListTag entities = (ListTag)Helper.tagFromCompound(level, "Entities");
            if (entities != null) {
                entities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToEntity((CompoundTag)v, offset)));
            }
            if ((tileEntities = (ListTag)Helper.tagFromCompound(level, "TileEntities")) != null) {
                tileEntities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTileEntity((CompoundTag)v, offset)));
            }
            if ((tileTicks = (ListTag)Helper.tagFromCompound(level, "TileTicks")) != null) {
                tileTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((liquidTicks = (ListTag)Helper.tagFromCompound(level, "LiquidTicks")) != null) {
                liquidTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((structures = (CompoundTag)Helper.tagFromCompound(level, "Structures")) != null) {
                ValidationHelper.catchAndLog(() -> this.applyOffsetToStructures(structures, offset));
            }
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "Lights", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "LiquidsToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "ToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "PostProcessing", offset.blockToSection()));
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(root, "Sections");
            if (sections != null) {
                ListTag newSections = new ListTag();
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    if (!this.applyOffsetToSection(section, offset.blockToSection(), new Range(0, 15))) continue;
                    newSections.add(section);
                }
                level.put("Sections", newSections);
            }
            return true;
        }
    }

    @MCVersionImplementation(value=1483)
    public static class Merge
    extends ChunkFilter_18w06a.Merge {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Sections", c -> ((CompoundTag)c).getInt("Y"));
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Entities", c -> ((CompoundTag)c).getList("Pos").getInt(1) >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileEntities", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "LiquidTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeListTagLists(source, destination, ranges, yOffset, "Lights");
            this.mergeListTagLists(source, destination, ranges, yOffset, "LiquidsToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "ToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "PostProcessing");
            this.mergeStructures(source, destination, ranges, yOffset);
            this.fixEntityUUIDs(Helper.levelFromRoot(destination));
        }
    }
}

