/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_13;

import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.java_1_13.ChunkFilter_18w06a;
import net.querz.mcaselector.version.mapping.generator.HeightmapConfig;

public class ChunkFilter_18w19a {

    @MCVersionImplementation(value=1484)
    public static class Heightmap
    extends ChunkFilter_18w06a.Heightmap {
        protected HeightmapConfig cfg;

        @Override
        protected void loadCfg() {
            this.cfg = FileHelper.loadFromResource("mapping/java_1_13/heightmaps_18w19a.json", HeightmapConfig::load);
        }

        @Override
        public void worldSurface(ChunkData data) {
            this.setHeightMap(Helper.getRegion(data), "LIGHT_BLOCKING", this.getHeightMap(Helper.getRegion(data), b -> {
                String name = Helper.stringFromCompound(b, "Name");
                return name != null && this.cfg.lightBlocking.contains(name);
            }));
        }

        @Override
        public void oceanFloor(ChunkData data) {
            this.setHeightMap(Helper.getRegion(data), "OCEAN_FLOOR", this.getHeightMap(Helper.getRegion(data), b -> {
                String name = Helper.stringFromCompound(b, "Name");
                return name != null && this.cfg.oceanFloor.contains(name);
            }));
        }

        @Override
        public void motionBlocking(ChunkData data) {
            this.setHeightMap(Helper.getRegion(data), "MOTION_BLOCKING", this.getHeightMap(Helper.getRegion(data), b -> {
                String name = Helper.stringFromCompound(b, "Name");
                return name != null && this.cfg.motionBlocking.contains(name);
            }));
        }

        @Override
        public void motionBlockingNoLeaves(ChunkData data) {
            this.setHeightMap(Helper.getRegion(data), "MOTION_BLOCKING_NO_LEAVES", this.getHeightMap(Helper.getRegion(data), b -> {
                String name = Helper.stringFromCompound(b, "Name");
                return name != null && this.cfg.motionBlocking.contains(name) && !this.cfg.leaves.contains(name);
            }));
        }
    }
}

