/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_15;

import java.util.Arrays;
import java.util.List;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.validation.ValidationHelper;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.java_1_13.ChunkFilter_18w06a;
import net.querz.mcaselector.version.java_1_14.ChunkFilter_19w02a;
import net.querz.mcaselector.version.java_1_14.ChunkFilter_19w11a;
import net.querz.mcaselector.version.mapping.registry.BiomeRegistry;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.ListTag;

public class ChunkFilter_19w36a {

    @MCVersionImplementation(value=2203)
    public static class Relocate
    extends ChunkFilter_19w11a.Relocate {
        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            CompoundTag structures;
            ListTag liquidTicks;
            ListTag tileTicks;
            ListTag tileEntities;
            CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
            if (level == null) {
                return false;
            }
            level.putInt("xPos", level.getInt("xPos") + offset.blockToChunk().getX());
            level.putInt("zPos", level.getInt("zPos") + offset.blockToChunk().getZ());
            ListTag entities = (ListTag)Helper.tagFromCompound(level, "Entities");
            if (entities != null) {
                entities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToEntity((CompoundTag)v, offset)));
            }
            if ((tileEntities = (ListTag)Helper.tagFromCompound(level, "TileEntities")) != null) {
                tileEntities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTileEntity((CompoundTag)v, offset)));
            }
            if ((tileTicks = (ListTag)Helper.tagFromCompound(level, "TileTicks")) != null) {
                tileTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((liquidTicks = (ListTag)Helper.tagFromCompound(level, "LiquidTicks")) != null) {
                liquidTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((structures = (CompoundTag)Helper.tagFromCompound(level, "Structures")) != null) {
                ValidationHelper.catchAndLog(() -> this.applyOffsetToStructures(structures, offset));
            }
            ValidationHelper.catchAndLog(() -> this.applyOffsetToBiomes((IntArrayTag)Helper.tagFromCompound(level, "Biomes"), offset.blockToSection(), 16));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "Lights", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "LiquidsToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "ToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "PostProcessing", offset.blockToSection()));
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(root, "Sections");
            if (sections != null) {
                ListTag newSections = new ListTag();
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    if (!this.applyOffsetToSection(section, offset.blockToSection(), new Range(0, 15))) continue;
                    newSections.add(section);
                }
                level.put("Sections", newSections);
            }
            return true;
        }

        protected void applyOffsetToBiomes(IntArrayTag biomes, Point3i offset, int numSections) {
            if (biomes == null || biomes.getValue() == null || biomes.getValue().length != 1024) {
                return;
            }
            int[] biomesArray = biomes.getValue();
            int[] newBiomes = new int[1024];
            for (int x = 0; x < 4; ++x) {
                for (int z = 0; z < 4; ++z) {
                    for (int y = 0; y < 64 && y + offset.getY() * 4 >= 0 && y + offset.getY() * 4 <= 63; ++y) {
                        int biome;
                        newBiomes[(y + offset.getY() * 4) * 16 + z * 4 + x] = biome = biomesArray[y * 16 + z * 4 + x];
                    }
                }
            }
            biomes.setValue(newBiomes);
        }

        @Override
        protected void applyOffsetToEntity(CompoundTag entity, Point3i offset) {
            String id;
            if (entity == null) {
                return;
            }
            ListTag entityPos = (ListTag)Helper.tagFromCompound(entity, "Pos");
            if (entityPos != null && entityPos.size() == 3) {
                entityPos.set(0, DoubleTag.valueOf(entityPos.getDouble(0) + (double)offset.getX()));
                entityPos.set(1, DoubleTag.valueOf(entityPos.getDouble(1) + (double)offset.getY()));
                entityPos.set(2, DoubleTag.valueOf(entityPos.getDouble(2) + (double)offset.getZ()));
            }
            CompoundTag leash = (CompoundTag)Helper.tagFromCompound(entity, "Leash");
            Helper.applyIntOffsetIfRootPresent(leash, "X", "Y", "Z", offset);
            if (ValidationHelper.attempt(() -> Helper.applyIntOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset))) {
                ValidationHelper.attempt(() -> Helper.applyShortOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset));
            }
            Helper.applyIntOffsetIfRootPresent(entity, "SleepingX", "SleepingY", "SleepingZ", offset);
            switch (id = Helper.stringFromCompound(entity, "id", "")) {
                case "minecraft:dolphin": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TreasurePosX", "TreasurePosY", "TreasurePosZ", offset);
                    break;
                }
                case "minecraft:phantom": {
                    Helper.applyIntOffsetIfRootPresent(entity, "AX", "AY", "AZ", offset);
                    break;
                }
                case "minecraft:shulker": {
                    Helper.applyIntOffsetIfRootPresent(entity, "APX", "APY", "APZ", offset);
                    break;
                }
                case "minecraft:turtle": {
                    Helper.applyIntOffsetIfRootPresent(entity, "HomePosX", "HomePosY", "HomePosZ", offset);
                    Helper.applyIntOffsetIfRootPresent(entity, "TravelPosX", "TravelPosY", "TravelPosZ", offset);
                    break;
                }
                case "minecraft:vex": {
                    Helper.applyIntOffsetIfRootPresent(entity, "BoundX", "BoundY", "BoundZ", offset);
                    break;
                }
                case "minecraft:wandering_trader": {
                    CompoundTag wanderTarget = (CompoundTag)Helper.tagFromCompound(entity, "WanderTarget");
                    Helper.applyIntOffsetIfRootPresent(wanderTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:shulker_bullet": {
                    CompoundTag owner = (CompoundTag)Helper.tagFromCompound(entity, "Owner");
                    Helper.applyIntOffsetIfRootPresent(owner, "X", "Y", "Z", offset);
                    CompoundTag target = (CompoundTag)Helper.tagFromCompound(entity, "Target");
                    Helper.applyIntOffsetIfRootPresent(target, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:end_crystal": {
                    CompoundTag beamTarget = (CompoundTag)Helper.tagFromCompound(entity, "BeamTarget");
                    Helper.applyIntOffsetIfRootPresent(beamTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:item_frame": 
                case "minecraft:painting": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TileX", "TileY", "TileZ", offset);
                    break;
                }
                case "minecraft:villager": {
                    CompoundTag memories = (CompoundTag)Helper.tagFromCompound(Helper.tagFromCompound(entity, "Brain"), "memories");
                    if (memories == null || memories.isEmpty()) break;
                    this.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:meeting_point"), offset);
                    this.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:home"), offset);
                    this.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:job_site"), offset);
                    break;
                }
                case "minecraft:pillager": 
                case "minecraft:witch": 
                case "minecraft:vindicator": 
                case "minecraft:ravager": 
                case "minecraft:illusioner": 
                case "minecraft:evoker": {
                    CompoundTag patrolTarget = (CompoundTag)Helper.tagFromCompound(entity, "PatrolTarget");
                    Helper.applyIntOffsetIfRootPresent(patrolTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:falling_block": {
                    CompoundTag tileEntityData = (CompoundTag)Helper.tagFromCompound(entity, "TileEntityData");
                    this.applyOffsetToTileEntity(tileEntityData, offset);
                }
            }
            ListTag passengers = (ListTag)Helper.tagFromCompound(entity, "Passengers");
            if (passengers != null) {
                passengers.forEach(p -> this.applyOffsetToEntity((CompoundTag)p, offset));
            }
            Helper.fixEntityUUID(entity);
        }

        @Override
        protected void applyOffsetToTileEntity(CompoundTag tileEntity, Point3i offset) {
            String id;
            if (tileEntity == null) {
                return;
            }
            Helper.applyIntOffsetIfRootPresent(tileEntity, "x", "y", "z", offset);
            switch (id = Helper.stringFromCompound(tileEntity, "id", "")) {
                case "minecraft:bee_nest": 
                case "minecraft:beehive": {
                    CompoundTag flowerPos = (CompoundTag)Helper.tagFromCompound(tileEntity, "FlowerPos");
                    Helper.applyIntOffsetIfRootPresent(flowerPos, "X", "Y", "Z", offset);
                    ListTag bees = (ListTag)Helper.tagFromCompound(tileEntity, "Bees");
                    if (bees == null) break;
                    for (CompoundTag bee : bees.iterateType(CompoundTag.class)) {
                        this.applyOffsetToEntity((CompoundTag)Helper.tagFromCompound(bee, "EntityData"), offset);
                    }
                    break;
                }
                case "minecraft:end_gateway": {
                    CompoundTag exitPortal = (CompoundTag)Helper.tagFromCompound(tileEntity, "ExitPortal");
                    Helper.applyIntOffsetIfRootPresent(exitPortal, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:structure_block": {
                    Helper.applyIntOffsetIfRootPresent(tileEntity, "posX", "posY", "posZ", offset);
                    break;
                }
                case "minecraft:mob_spawner": {
                    ListTag spawnPotentials = (ListTag)Helper.tagFromCompound(tileEntity, "SpawnPotentials");
                    if (spawnPotentials == null) break;
                    for (CompoundTag spawnPotential : spawnPotentials.iterateType(CompoundTag.class)) {
                        CompoundTag entity = (CompoundTag)Helper.tagFromCompound(spawnPotential, "Entity");
                        this.applyOffsetToEntity(entity, offset);
                    }
                    break;
                }
            }
        }
    }

    @MCVersionImplementation(value=2203)
    public static class Merge
    extends ChunkFilter_19w02a.Merge {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Sections", c -> ((CompoundTag)c).getInt("Y"));
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Entities", c -> ((CompoundTag)c).getList("Pos").getInt(1) >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileEntities", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "LiquidTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeListTagLists(source, destination, ranges, yOffset, "Lights");
            this.mergeListTagLists(source, destination, ranges, yOffset, "LiquidsToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "ToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "PostProcessing");
            this.mergeStructures(source, destination, ranges, yOffset);
            this.fixEntityUUIDs(Helper.levelFromRoot(destination));
            this.mergeBiomes(source, destination, ranges, yOffset);
        }

        protected void mergeBiomes(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            IntArrayTag sourceBiomes = (IntArrayTag)Helper.tagFromLevelFromRoot(source, "Biomes");
            IntArrayTag destinationBiomes = (IntArrayTag)Helper.tagFromLevelFromRoot(destination, "Biomes");
            if (destinationBiomes == null) {
                destinationBiomes = new IntArrayTag(new int[1024]);
                Arrays.fill(destinationBiomes.getValue(), -1);
            }
            if (sourceBiomes == null) {
                for (Range range : ranges) {
                    int m = Math.min(range.getTo() + yOffset, 15);
                    for (int i = Math.max(range.getFrom() + yOffset, 0); i <= m; ++i) {
                        this.setSectionBiomes(-1, destinationBiomes.getValue(), i);
                    }
                }
            } else {
                for (Range range : ranges) {
                    int m = Math.min(range.getTo() - yOffset, 15);
                    for (int i = Math.max(range.getFrom() - yOffset, 0); i <= m; ++i) {
                        this.copySectionBiomes(sourceBiomes.getValue(), destinationBiomes.getValue(), i);
                    }
                }
            }
        }

        protected void copySectionBiomes(int[] sourceBiomes, int[] destinationBiomes, int sectionY) {
            for (int y = 0; y < 4; ++y) {
                int biomeY = sectionY * 4 + y;
                for (int x = 0; x < 4; ++x) {
                    for (int z = 0; z < 4; ++z) {
                        this.setBiomeAt(destinationBiomes, x, biomeY, z, this.getBiomeAt(sourceBiomes, x, biomeY, z));
                    }
                }
            }
        }

        protected void setSectionBiomes(int biome, int[] destinationBiomes, int sectionY) {
            for (int y = 0; y < 4; ++y) {
                int biomeY = sectionY * 4 + y;
                for (int x = 0; x < 4; ++x) {
                    for (int z = 0; z < 4; ++z) {
                        this.setBiomeAt(destinationBiomes, x, biomeY, z, biome);
                    }
                }
            }
        }

        protected int getBiomeAt(int[] biomes, int biomeX, int biomeY, int biomeZ) {
            if (biomes == null || biomes.length != 1024) {
                return -1;
            }
            return biomes[this.getBiomeIndex(biomeX, biomeY, biomeZ)];
        }

        protected void setBiomeAt(int[] biomes, int biomeX, int biomeY, int biomeZ, int biomeID) {
            if (biomes == null || biomes.length != 1024) {
                biomes = new int[1024];
                Arrays.fill(biomes, -1);
            }
            biomes[this.getBiomeIndex((int)biomeX, (int)biomeY, (int)biomeZ)] = biomeID;
        }

        protected int getBiomeIndex(int x, int y, int z) {
            return y * 16 + z * 4 + x;
        }
    }

    @MCVersionImplementation(value=2203)
    public static class Biomes
    extends ChunkFilter_18w06a.Biomes {
        @Override
        public void forceBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            if (level != null) {
                int[] biomes = new int[1024];
                Arrays.fill(biomes, (int)((byte)biome.getID()));
                level.putIntArray("Biomes", biomes);
            }
        }
    }
}

