/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_16;

import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.validation.ValidationHelper;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.java_1_15.ChunkFilter_19w36a;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.ListTag;

public class ChunkFilter_20w13a {

    @MCVersionImplementation(value=2520)
    public static class Relocate
    extends ChunkFilter_19w36a.Relocate {
        @Override
        protected void applyOffsetToEntity(CompoundTag entity, Point3i offset) {
            ListTag armorItems;
            ListTag handItems;
            String id;
            if (entity == null) {
                return;
            }
            ListTag entityPos = (ListTag)Helper.tagFromCompound(entity, "Pos");
            if (entityPos != null && entityPos.size() == 3) {
                entityPos.set(0, DoubleTag.valueOf(entityPos.getDouble(0) + (double)offset.getX()));
                entityPos.set(1, DoubleTag.valueOf(entityPos.getDouble(1) + (double)offset.getY()));
                entityPos.set(2, DoubleTag.valueOf(entityPos.getDouble(2) + (double)offset.getZ()));
            }
            CompoundTag leash = (CompoundTag)Helper.tagFromCompound(entity, "Leash");
            Helper.applyIntOffsetIfRootPresent(leash, "X", "Y", "Z", offset);
            if (ValidationHelper.attempt(() -> Helper.applyIntOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset))) {
                ValidationHelper.attempt(() -> Helper.applyShortOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset));
            }
            Helper.applyIntOffsetIfRootPresent(entity, "SleepingX", "SleepingY", "SleepingZ", offset);
            switch (id = Helper.stringFromCompound(entity, "id", "")) {
                case "minecraft:dolphin": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TreasurePosX", "TreasurePosY", "TreasurePosZ", offset);
                    break;
                }
                case "minecraft:phantom": {
                    Helper.applyIntOffsetIfRootPresent(entity, "AX", "AY", "AZ", offset);
                    break;
                }
                case "minecraft:shulker": {
                    Helper.applyIntOffsetIfRootPresent(entity, "APX", "APY", "APZ", offset);
                    break;
                }
                case "minecraft:turtle": {
                    Helper.applyIntOffsetIfRootPresent(entity, "HomePosX", "HomePosY", "HomePosZ", offset);
                    Helper.applyIntOffsetIfRootPresent(entity, "TravelPosX", "TravelPosY", "TravelPosZ", offset);
                    break;
                }
                case "minecraft:vex": {
                    Helper.applyIntOffsetIfRootPresent(entity, "BoundX", "BoundY", "BoundZ", offset);
                    break;
                }
                case "minecraft:wandering_trader": {
                    CompoundTag wanderTarget = (CompoundTag)Helper.tagFromCompound(entity, "WanderTarget");
                    Helper.applyIntOffsetIfRootPresent(wanderTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:shulker_bullet": {
                    CompoundTag owner = (CompoundTag)Helper.tagFromCompound(entity, "Owner");
                    Helper.applyIntOffsetIfRootPresent(owner, "X", "Y", "Z", offset);
                    CompoundTag target = (CompoundTag)Helper.tagFromCompound(entity, "Target");
                    Helper.applyIntOffsetIfRootPresent(target, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:end_crystal": {
                    CompoundTag beamTarget = (CompoundTag)Helper.tagFromCompound(entity, "BeamTarget");
                    Helper.applyIntOffsetIfRootPresent(beamTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:item_frame": 
                case "minecraft:painting": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TileX", "TileY", "TileZ", offset);
                    break;
                }
                case "minecraft:villager": {
                    CompoundTag memories = (CompoundTag)Helper.tagFromCompound(Helper.tagFromCompound(entity, "Brain"), "memories");
                    if (memories == null || memories.isEmpty()) break;
                    this.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:meeting_point"), offset);
                    this.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:home"), offset);
                    this.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:job_site"), offset);
                    break;
                }
                case "minecraft:pillager": 
                case "minecraft:witch": 
                case "minecraft:vindicator": 
                case "minecraft:ravager": 
                case "minecraft:illusioner": 
                case "minecraft:evoker": {
                    CompoundTag patrolTarget = (CompoundTag)Helper.tagFromCompound(entity, "PatrolTarget");
                    Helper.applyIntOffsetIfRootPresent(patrolTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:falling_block": {
                    CompoundTag tileEntityData = (CompoundTag)Helper.tagFromCompound(entity, "TileEntityData");
                    this.applyOffsetToTileEntity(tileEntityData, offset);
                }
            }
            ListTag passengers = (ListTag)Helper.tagFromCompound(entity, "Passengers");
            if (passengers != null) {
                passengers.forEach(p -> this.applyOffsetToEntity((CompoundTag)p, offset));
            }
            CompoundTag item = (CompoundTag)Helper.tagFromCompound(entity, "Item");
            this.applyOffsetToItem(item, offset);
            ListTag items = (ListTag)Helper.tagFromCompound(entity, "Items");
            if (items != null) {
                items.forEach(i -> this.applyOffsetToItem((CompoundTag)i, offset));
            }
            if ((handItems = (ListTag)Helper.tagFromCompound(entity, "HandItems")) != null) {
                handItems.forEach(i -> this.applyOffsetToItem((CompoundTag)i, offset));
            }
            if ((armorItems = (ListTag)Helper.tagFromCompound(entity, "ArmorItems")) != null) {
                armorItems.forEach(i -> this.applyOffsetToItem((CompoundTag)i, offset));
            }
            Helper.fixEntityUUID(entity);
        }

        protected void applyOffsetToItem(CompoundTag item, Point3i offset) {
            String id;
            if (item == null) {
                return;
            }
            CompoundTag tag = (CompoundTag)Helper.tagFromCompound(item, "tag");
            if (tag == null) {
                return;
            }
            switch (id = Helper.stringFromCompound(item, "id", "")) {
                case "minecraft:compass": {
                    CompoundTag lodestonePos = (CompoundTag)Helper.tagFromCompound(tag, "LodestonePos");
                    Helper.applyIntOffsetIfRootPresent(lodestonePos, "X", "Y", "Z", offset);
                }
            }
            CompoundTag blockEntityTag = (CompoundTag)Helper.tagFromCompound(tag, "BlockEntityTag");
            ListTag items = (ListTag)Helper.tagFromCompound(blockEntityTag, "Items");
            if (items != null) {
                items.forEach(i -> this.applyOffsetToItem((CompoundTag)i, offset));
            }
        }
    }
}

