/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_17;

import java.util.List;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.validation.ValidationHelper;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.java_1_15.ChunkFilter_19w36a;
import net.querz.mcaselector.version.java_1_16.ChunkFilter_20w13a;
import net.querz.mcaselector.version.java_1_16.ChunkFilter_20w17a;
import net.querz.mcaselector.version.mapping.generator.HeightmapConfig;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.ListTag;

public class ChunkFilter_20w45a {

    @MCVersionImplementation(value=2681)
    public static class Heightmap
    extends ChunkFilter_20w17a.Heightmap {
        @Override
        protected void loadCfg() {
            this.cfg = FileHelper.loadFromResource("mapping/java_1_17/heightmaps_20w45a.json", HeightmapConfig::load);
        }
    }

    @MCVersionImplementation(value=2681)
    public static class Merge
    extends ChunkFilter_19w36a.Merge {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Sections", c -> ((CompoundTag)c).getInt("Y"));
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileEntities", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "LiquidTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeListTagLists(source, destination, ranges, yOffset, "Lights");
            this.mergeListTagLists(source, destination, ranges, yOffset, "LiquidsToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "ToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "PostProcessing");
            this.mergeStructures(source, destination, ranges, yOffset);
        }
    }

    @MCVersionImplementation(value=2681)
    public static class Relocate
    extends ChunkFilter_20w13a.Relocate {
        static Relocate instance;

        public Relocate() {
            instance = this;
        }

        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            CompoundTag structures;
            ListTag liquidTicks;
            ListTag tileTicks;
            CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
            if (level == null) {
                return false;
            }
            level.putInt("xPos", level.getInt("xPos") + offset.blockToChunk().getX());
            level.putInt("zPos", level.getInt("zPos") + offset.blockToChunk().getZ());
            ListTag tileEntities = (ListTag)Helper.tagFromCompound(level, "TileEntities");
            if (tileEntities != null) {
                tileEntities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTileEntity((CompoundTag)v, offset)));
            }
            if ((tileTicks = (ListTag)Helper.tagFromCompound(level, "TileTicks")) != null) {
                tileTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((liquidTicks = (ListTag)Helper.tagFromCompound(level, "LiquidTicks")) != null) {
                liquidTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((structures = (CompoundTag)Helper.tagFromCompound(level, "Structures")) != null) {
                ValidationHelper.catchAndLog(() -> this.applyOffsetToStructures(structures, offset));
            }
            ValidationHelper.catchAndLog(() -> this.applyOffsetToBiomes((IntArrayTag)Helper.tagFromCompound(level, "Biomes"), offset.blockToSection(), 16));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "Lights", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "LiquidsToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "ToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "PostProcessing", offset.blockToSection()));
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(root, "Sections");
            if (sections != null) {
                ListTag newSections = new ListTag();
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    if (!this.applyOffsetToSection(section, offset.blockToSection(), new Range(0, 15))) continue;
                    newSections.add(section);
                }
                level.put("Sections", newSections);
            }
            return true;
        }

        @Override
        protected void applyOffsetToTileEntity(CompoundTag tileEntity, Point3i offset) {
            super.applyOffsetToTileEntity(tileEntity, offset);
        }

        @Override
        protected void applyOffsetToVillagerMemory(CompoundTag memory, Point3i offset) {
            super.applyOffsetToVillagerMemory(memory, offset);
        }

        @Override
        protected void applyOffsetToItem(CompoundTag item, Point3i offset) {
            super.applyOffsetToItem(item, offset);
        }
    }

    @MCVersionImplementation(value=2681)
    public static class RelocateEntities
    implements ChunkFilter.RelocateEntities {
        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            int[] position = Helper.intArrayFromCompound(root, "Position");
            if (position == null || position.length != 2) {
                return false;
            }
            position[0] = position[0] + offset.blockToChunk().getX();
            position[1] = position[1] + offset.blockToChunk().getZ();
            ListTag entities = (ListTag)Helper.tagFromCompound(root, "Entities");
            if (entities != null) {
                entities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToEntity((CompoundTag)v, offset)));
            }
            return true;
        }

        protected void applyOffsetToEntity(CompoundTag entity, Point3i offset) {
            ListTag armorItems;
            ListTag handItems;
            String id;
            if (entity == null) {
                return;
            }
            ListTag entityPos = (ListTag)Helper.tagFromCompound(entity, "Pos");
            if (entityPos != null && entityPos.size() == 3) {
                entityPos.set(0, DoubleTag.valueOf(entityPos.getDouble(0) + (double)offset.getX()));
                entityPos.set(1, DoubleTag.valueOf(entityPos.getDouble(1) + (double)offset.getY()));
                entityPos.set(2, DoubleTag.valueOf(entityPos.getDouble(2) + (double)offset.getZ()));
            }
            CompoundTag leash = (CompoundTag)Helper.tagFromCompound(entity, "Leash");
            Helper.applyIntOffsetIfRootPresent(leash, "X", "Y", "Z", offset);
            if (ValidationHelper.attempt(() -> Helper.applyIntOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset))) {
                ValidationHelper.attempt(() -> Helper.applyShortOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset));
            }
            Helper.applyIntOffsetIfRootPresent(entity, "SleepingX", "SleepingY", "SleepingZ", offset);
            switch (id = Helper.stringFromCompound(entity, "id", "")) {
                case "minecraft:dolphin": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TreasurePosX", "TreasurePosY", "TreasurePosZ", offset);
                    break;
                }
                case "minecraft:phantom": {
                    Helper.applyIntOffsetIfRootPresent(entity, "AX", "AY", "AZ", offset);
                    break;
                }
                case "minecraft:shulker": {
                    Helper.applyIntOffsetIfRootPresent(entity, "APX", "APY", "APZ", offset);
                    break;
                }
                case "minecraft:turtle": {
                    Helper.applyIntOffsetIfRootPresent(entity, "HomePosX", "HomePosY", "HomePosZ", offset);
                    Helper.applyIntOffsetIfRootPresent(entity, "TravelPosX", "TravelPosY", "TravelPosZ", offset);
                    break;
                }
                case "minecraft:vex": {
                    Helper.applyIntOffsetIfRootPresent(entity, "BoundX", "BoundY", "BoundZ", offset);
                    break;
                }
                case "minecraft:wandering_trader": {
                    CompoundTag wanderTarget = (CompoundTag)Helper.tagFromCompound(entity, "WanderTarget");
                    Helper.applyIntOffsetIfRootPresent(wanderTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:shulker_bullet": {
                    CompoundTag owner = (CompoundTag)Helper.tagFromCompound(entity, "Owner");
                    Helper.applyIntOffsetIfRootPresent(owner, "X", "Y", "Z", offset);
                    CompoundTag target = (CompoundTag)Helper.tagFromCompound(entity, "Target");
                    Helper.applyIntOffsetIfRootPresent(target, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:end_crystal": {
                    CompoundTag beamTarget = (CompoundTag)Helper.tagFromCompound(entity, "BeamTarget");
                    Helper.applyIntOffsetIfRootPresent(beamTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:item_frame": 
                case "minecraft:painting": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TileX", "TileY", "TileZ", offset);
                    break;
                }
                case "minecraft:villager": {
                    CompoundTag memories = (CompoundTag)Helper.tagFromCompound(Helper.tagFromCompound(entity, "Brain"), "memories");
                    if (memories == null || memories.isEmpty()) break;
                    Relocate.instance.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:meeting_point"), offset);
                    Relocate.instance.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:home"), offset);
                    Relocate.instance.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:job_site"), offset);
                    break;
                }
                case "minecraft:pillager": 
                case "minecraft:witch": 
                case "minecraft:vindicator": 
                case "minecraft:ravager": 
                case "minecraft:illusioner": 
                case "minecraft:evoker": {
                    CompoundTag patrolTarget = (CompoundTag)Helper.tagFromCompound(entity, "PatrolTarget");
                    Helper.applyIntOffsetIfRootPresent(patrolTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:falling_block": {
                    CompoundTag tileEntityData = (CompoundTag)Helper.tagFromCompound(entity, "TileEntityData");
                    Relocate.instance.applyOffsetToTileEntity(tileEntityData, offset);
                }
            }
            ListTag passengers = (ListTag)Helper.tagFromCompound(entity, "Passengers");
            if (passengers != null) {
                passengers.forEach(p -> this.applyOffsetToEntity((CompoundTag)p, offset));
            }
            CompoundTag item = (CompoundTag)Helper.tagFromCompound(entity, "Item");
            Relocate.instance.applyOffsetToItem(item, offset);
            ListTag items = (ListTag)Helper.tagFromCompound(entity, "Items");
            if (items != null) {
                items.forEach(i -> Relocate.instance.applyOffsetToItem((CompoundTag)i, offset));
            }
            if ((handItems = (ListTag)Helper.tagFromCompound(entity, "HandItems")) != null) {
                handItems.forEach(i -> Relocate.instance.applyOffsetToItem((CompoundTag)i, offset));
            }
            if ((armorItems = (ListTag)Helper.tagFromCompound(entity, "ArmorItems")) != null) {
                armorItems.forEach(i -> Relocate.instance.applyOffsetToItem((CompoundTag)i, offset));
            }
            Helper.fixEntityUUID(entity);
        }
    }

    @MCVersionImplementation(value=2681)
    public static class MergeEntities
    implements ChunkFilter.MergeEntities {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            this.mergeCompoundTagLists(source, destination, ranges, yOffset, "Entities", c -> ((CompoundTag)c).getList("Pos").getInt(1) >> 4);
        }

        @Override
        public CompoundTag newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
            CompoundTag root = new CompoundTag();
            int[] position = new int[]{absoluteLocation.getX(), absoluteLocation.getZ()};
            root.putIntArray("Position", position);
            root.putInt("DataVersion", dataVersion);
            root.put("Entities", new ListTag());
            return root;
        }
    }

    @MCVersionImplementation(value=2681)
    public static class Entities
    implements ChunkFilter.Entities {
        @Override
        public void deleteEntities(ChunkData data, List<Range> ranges) {
            ListTag entities = (ListTag)Helper.tagFromLevelFromRoot(Helper.getEntities(data), "Entities");
            this.deleteEntities(entities, ranges);
            ListTag protoEntities = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Entities");
            this.deleteEntities(protoEntities, ranges);
        }

        protected void deleteEntities(ListTag entities, List<Range> ranges) {
            if (entities == null) {
                return;
            }
            if (ranges == null) {
                entities.clear();
            } else {
                for (int i = 0; i < entities.size(); ++i) {
                    CompoundTag entity = entities.getCompound(i);
                    for (Range range : ranges) {
                        ListTag entityPos = (ListTag)Helper.tagFromCompound(entity, "Pos");
                        if (entityPos == null || entityPos.size() != 3 || !range.contains(entityPos.getInt(1) >> 4)) continue;
                        entities.remove(i);
                        --i;
                    }
                }
            }
        }

        @Override
        public ListTag getEntities(ChunkData data) {
            return (ListTag)Helper.tagFromCompound(Helper.getEntities(data), "Entities");
        }
    }
}

