/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_9;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.validation.ValidationHelper;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.mapping.registry.BiomeRegistry;
import net.querz.mcaselector.version.mapping.registry.StatusRegistry;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkFilter_15w32a {
    private static final Logger LOGGER = LogManager.getLogger(ChunkFilter_15w32a.class);
    private static final Map<String, BlockData[]> mapping = FileHelper.loadFromResource("mapping/java_1_9/block_name_to_id.csv", r -> {
        HashMap map = new HashMap();
        try (Stream<String> lines = r.lines();){
            lines.forEach(line -> {
                String[] bytes;
                String[] split = line.split(";");
                int id = Integer.parseInt(split[1]);
                HashSet<Byte> data = new HashSet<Byte>();
                if (split.length == 2 || (bytes = split[2].split(",")).length == 0) {
                    for (int i = 0; i < 16; ++i) {
                        data.add((byte)i);
                    }
                } else {
                    for (String b : bytes) {
                        data.add(Byte.parseByte(b));
                    }
                }
                for (String name : split[0].split(",")) {
                    String fullName = "minecraft:" + name;
                    BlockData blockData = new BlockData(id, data);
                    map.compute(fullName, (k, v) -> {
                        if (v == null) {
                            return new BlockData[]{blockData};
                        }
                        BlockData[] newArray = new BlockData[((BlockData[])v).length + 1];
                        System.arraycopy(v, 0, newArray, 0, ((BlockData[])v).length);
                        newArray[newArray.length - 1] = blockData;
                        return newArray;
                    });
                }
            });
        }
        return map;
    });

    private static class BlockData {
        int id;
        Set<Byte> data;

        BlockData(int id, Set<Byte> data) {
            this.id = id;
            this.data = data;
        }

        public String toString() {
            return "{" + this.id + ":" + Arrays.toString(this.data.toArray()) + "}";
        }
    }

    @MCVersionImplementation(value=100)
    public static class Heightmap
    implements ChunkFilter.Heightmap {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        private static final Set<Short> nonWorldSurfaceBlocks = FileHelper.loadFromResource("mapping/java_1_9/heightmaps_legacy.json", r -> GSON.fromJson((Reader)r, new TypeToken<Set<Short>>(){}));

        @Override
        public void worldSurface(ChunkData data) {
            this.setHeightMap(Helper.getRegion(data), this.getHeightMap(Helper.getRegion(data), block -> !nonWorldSurfaceBlocks.contains(block)));
        }

        @Override
        public void oceanFloor(ChunkData data) {
        }

        @Override
        public void motionBlocking(ChunkData data) {
        }

        @Override
        public void motionBlockingNoLeaves(ChunkData data) {
        }

        protected void setHeightMap(CompoundTag data, int[] heightmap) {
            if (data == null) {
                return;
            }
            CompoundTag level = data.getCompoundTag("Level");
            if (level == null) {
                return;
            }
            level.putIntArray("HeightMap", heightmap);
        }

        protected int[] getHeightMap(CompoundTag data, Predicate<Short> matcher) {
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(data, "Sections");
            if (sections == null) {
                return new int[256];
            }
            byte[][] blocksArray = new byte[16][];
            for (CompoundTag s : sections.iterateType(CompoundTag.class)) {
                if (!s.containsKey("Blocks")) continue;
                int y = Helper.numberFromCompound(s, "Y", -1).intValue();
                byte[] b = Helper.byteArrayFromCompound(s, "Blocks");
                if (y < 0 || y >= 16 || b == null) continue;
                blocksArray[y] = b;
            }
            int[] heightmap = new int[256];
            for (int cx = 0; cx < 16; ++cx) {
                block2: for (int cz = 0; cz < 16; ++cz) {
                    for (int i = 15; i >= 0; --i) {
                        byte[] blocks = blocksArray[i];
                        if (blocks == null) continue;
                        for (int cy = 15; cy >= 0; --cy) {
                            int index = cy * 256 + cz * 16 + cx;
                            short block = (short)(blocks[index] & 0xFF);
                            if (!matcher.test(block)) continue;
                            heightmap[cz * 16 + cx] = i * 16 + cy + 1;
                            continue block2;
                        }
                    }
                }
            }
            return heightmap;
        }
    }

    @MCVersionImplementation(value=100)
    public static class RelocatePOI
    implements ChunkFilter.RelocatePOI {
        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            return true;
        }
    }

    @MCVersionImplementation(value=100)
    public static class RelocateEntities
    implements ChunkFilter.RelocateEntities {
        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            return true;
        }
    }

    @MCVersionImplementation(value=100)
    public static class MergePOI
    implements ChunkFilter.MergePOI {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
        }

        @Override
        public CompoundTag newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
            return null;
        }
    }

    @MCVersionImplementation(value=100)
    public static class MergeEntities
    implements ChunkFilter.MergeEntities {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
        }

        @Override
        public CompoundTag newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
            return null;
        }
    }

    @MCVersionImplementation(value=100)
    public static class Entities
    implements ChunkFilter.Entities {
        @Override
        public void deleteEntities(ChunkData data, List<Range> ranges) {
            ListTag entities = Helper.tagFromLevelFromRoot(data.region().getData(), "Entities", null);
            if (ranges == null) {
                if (entities != null) {
                    entities.clear();
                }
            } else {
                for (int i = 0; i < entities.size(); ++i) {
                    CompoundTag entity = entities.getCompound(i);
                    for (Range range : ranges) {
                        ListTag entityPos = (ListTag)Helper.tagFromCompound(entity, "Pos");
                        if (entityPos == null || entityPos.size() != 3 || !range.contains(entityPos.getInt(1) >> 4)) continue;
                        entities.remove(i);
                        --i;
                    }
                }
            }
        }

        @Override
        public ListTag getEntities(ChunkData data) {
            return Helper.tagFromLevelFromRoot(data.region().getData(), "Entities", null);
        }
    }

    @MCVersionImplementation(value=100)
    public static class Merge
    implements ChunkFilter.Merge {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Sections", c -> ((CompoundTag)c).getInt("Y"));
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "Entities", c -> ((CompoundTag)c).getList("Pos").getInt(1) >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileEntities", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "TileTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagListsFromLevel(source, destination, ranges, yOffset, "LiquidTicks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeListTagLists(source, destination, ranges, yOffset, "Lights");
            this.mergeListTagLists(source, destination, ranges, yOffset, "LiquidsToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "ToBeTicked");
            this.mergeListTagLists(source, destination, ranges, yOffset, "PostProcessing");
            this.fixEntityUUIDs(Helper.levelFromRoot(destination));
        }

        @Override
        public CompoundTag newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
            CompoundTag root = new CompoundTag();
            CompoundTag level = new CompoundTag();
            level.putInt("xPos", absoluteLocation.getX());
            level.putInt("zPos", absoluteLocation.getZ());
            level.putString("Status", "postprocessed");
            root.put("Level", level);
            root.putInt("DataVersion", dataVersion);
            return root;
        }
    }

    @MCVersionImplementation(value=100)
    public static class Relocate
    implements ChunkFilter.Relocate {
        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            ListTag liquidTicks;
            ListTag tileTicks;
            ListTag tileEntities;
            CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
            if (level == null) {
                return false;
            }
            level.putInt("xPos", level.getInt("xPos") + offset.blockToChunk().getX());
            level.putInt("zPos", level.getInt("zPos") + offset.blockToChunk().getZ());
            ListTag entities = (ListTag)Helper.tagFromCompound(level, "Entities");
            if (entities != null) {
                entities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToEntity((CompoundTag)v, offset)));
            }
            if ((tileEntities = (ListTag)Helper.tagFromCompound(level, "TileEntities")) != null) {
                tileEntities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTileEntity((CompoundTag)v, offset)));
            }
            if ((tileTicks = (ListTag)Helper.tagFromCompound(level, "TileTicks")) != null) {
                tileTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((liquidTicks = (ListTag)Helper.tagFromCompound(level, "LiquidTicks")) != null) {
                liquidTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "Lights", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "LiquidsToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "ToBeTicked", offset.blockToSection()));
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(level, "PostProcessing", offset.blockToSection()));
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(root, "Sections");
            if (sections != null) {
                ListTag newSections = new ListTag();
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    if (!this.applyOffsetToSection(section, offset.blockToSection(), new Range(0, 15))) continue;
                    newSections.add(section);
                }
                level.put("Sections", newSections);
            }
            return true;
        }

        private void applyOffsetToEntity(CompoundTag entity, Point3i offset) {
            String id;
            if (entity == null) {
                return;
            }
            ListTag entityPos = (ListTag)Helper.tagFromCompound(entity, "Pos");
            if (entityPos != null && entityPos.size() == 3) {
                entityPos.set(0, DoubleTag.valueOf(entityPos.getDouble(0) + (double)offset.getX()));
                entityPos.set(1, DoubleTag.valueOf(entityPos.getDouble(1) + (double)offset.getY()));
                entityPos.set(2, DoubleTag.valueOf(entityPos.getDouble(2) + (double)offset.getZ()));
            }
            CompoundTag leash = (CompoundTag)Helper.tagFromCompound(entity, "Leash");
            Helper.applyIntOffsetIfRootPresent(leash, "X", "Y", "Z", offset);
            if (ValidationHelper.attempt(() -> Helper.applyIntOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset))) {
                ValidationHelper.attempt(() -> Helper.applyShortOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset));
            }
            Helper.applyIntOffsetIfRootPresent(entity, "SleepingX", "SleepingY", "SleepingZ", offset);
            switch (id = Helper.stringFromCompound(entity, "id", "")) {
                case "minecraft:shulker": {
                    Helper.applyIntOffsetIfRootPresent(entity, "APX", "APY", "APZ", offset);
                    break;
                }
                case "minecraft:vex": {
                    Helper.applyIntOffsetIfRootPresent(entity, "BoundX", "BoundY", "BoundZ", offset);
                    break;
                }
                case "minecraft:shulker_bullet": {
                    CompoundTag owner = (CompoundTag)Helper.tagFromCompound(entity, "Owner");
                    Helper.applyIntOffsetIfRootPresent(owner, "X", "Y", "Z", offset);
                    CompoundTag target = (CompoundTag)Helper.tagFromCompound(entity, "Target");
                    Helper.applyIntOffsetIfRootPresent(target, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:end_crystal": {
                    CompoundTag beamTarget = (CompoundTag)Helper.tagFromCompound(entity, "BeamTarget");
                    Helper.applyIntOffsetIfRootPresent(beamTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:item_frame": 
                case "minecraft:painting": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TileX", "TileY", "TileZ", offset);
                    break;
                }
                case "minecraft:villager": {
                    CompoundTag jobSite;
                    CompoundTag home;
                    CompoundTag memories;
                    CompoundTag brain;
                    if (!entity.containsKey("Brain") || (brain = (CompoundTag)Helper.tagFromCompound(entity, "Brain")) == null || !brain.containsKey("memories") || (memories = (CompoundTag)Helper.tagFromCompound(brain, "memories")) == null || memories.isEmpty()) break;
                    CompoundTag meetingPoint = (CompoundTag)Helper.tagFromCompound(memories, "minecraft:meeting_point");
                    if (meetingPoint != null && meetingPoint.containsKey("pos")) {
                        if (meetingPoint.get("pos") instanceof IntArrayTag) {
                            pos = (IntArrayTag)Helper.tagFromCompound(meetingPoint, "pos");
                            Helper.applyOffsetToIntArrayPos(pos, offset);
                        } else if (meetingPoint.get("pos") instanceof ListTag) {
                            pos = (ListTag)Helper.tagFromCompound(meetingPoint, "pos");
                            Helper.applyOffsetToIntListPos((ListTag)pos, offset);
                        }
                    }
                    if ((home = (CompoundTag)Helper.tagFromCompound(memories, "minecraft:home")) != null && home.containsKey("pos")) {
                        if (home.get("pos") instanceof IntArrayTag) {
                            pos = (IntArrayTag)Helper.tagFromCompound(home, "pos");
                            Helper.applyOffsetToIntArrayPos(pos, offset);
                        } else if (home.get("pos") instanceof ListTag) {
                            pos = (ListTag)Helper.tagFromCompound(home, "pos");
                            Helper.applyOffsetToIntListPos((ListTag)pos, offset);
                        }
                    }
                    if ((jobSite = (CompoundTag)Helper.tagFromCompound(memories, "minecraft:job_site")) == null || !jobSite.containsKey("pos")) break;
                    if (jobSite.get("pos") instanceof IntArrayTag) {
                        IntArrayTag pos = (IntArrayTag)Helper.tagFromCompound(jobSite, "pos");
                        Helper.applyOffsetToIntArrayPos(pos, offset);
                        break;
                    }
                    if (!(jobSite.get("pos") instanceof ListTag)) break;
                    ListTag pos = (ListTag)Helper.tagFromCompound(jobSite, "pos");
                    Helper.applyOffsetToIntListPos(pos, offset);
                    break;
                }
                case "minecraft:witch": 
                case "minecraft:vindicator": 
                case "minecraft:illusioner": 
                case "minecraft:evoker": {
                    CompoundTag patrolTarget = (CompoundTag)Helper.tagFromCompound(entity, "PatrolTarget");
                    Helper.applyIntOffsetIfRootPresent(patrolTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:falling_block": {
                    CompoundTag tileEntityData = (CompoundTag)Helper.tagFromCompound(entity, "TileEntityData");
                    this.applyOffsetToTileEntity(tileEntityData, offset);
                }
            }
            ListTag passengers = (ListTag)Helper.tagFromCompound(entity, "Passengers");
            if (passengers != null) {
                passengers.forEach(p -> this.applyOffsetToEntity((CompoundTag)p, offset));
            }
            Helper.fixEntityUUID(entity);
        }

        private void applyOffsetToTick(CompoundTag tick, Point3i offset) {
            Helper.applyIntOffsetIfRootPresent(tick, "x", "y", "z", offset);
        }

        private void applyOffsetToTileEntity(CompoundTag tileEntity, Point3i offset) {
            String id;
            if (tileEntity == null) {
                return;
            }
            Helper.applyIntOffsetIfRootPresent(tileEntity, "x", "y", "z", offset);
            switch (id = Helper.stringFromCompound(tileEntity, "id", "")) {
                case "minecraft:end_gateway": {
                    CompoundTag exitPortal = (CompoundTag)Helper.tagFromCompound(tileEntity, "ExitPortal");
                    Helper.applyIntOffsetIfRootPresent(exitPortal, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:structure_block": {
                    Helper.applyIntOffsetIfRootPresent(tileEntity, "posX", "posY", "posZ", offset);
                    break;
                }
                case "minecraft:mob_spawner": {
                    ListTag spawnPotentials = (ListTag)Helper.tagFromCompound(tileEntity, "SpawnPotentials");
                    if (spawnPotentials == null) break;
                    for (CompoundTag spawnPotential : spawnPotentials.iterateType(CompoundTag.class)) {
                        CompoundTag entity = (CompoundTag)Helper.tagFromCompound(spawnPotential, "Entity");
                        this.applyOffsetToEntity(entity, offset);
                    }
                    break;
                }
            }
        }
    }

    @MCVersionImplementation(value=100)
    public static class Blending
    implements ChunkFilter.Blending {
        @Override
        public void forceBlending(ChunkData data) {
        }
    }

    @MCVersionImplementation(value=100)
    public static class Structures
    implements ChunkFilter.Structures {
        @Override
        public CompoundTag getStructureReferences(ChunkData data) {
            CompoundTag structures = (CompoundTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Structures");
            return (CompoundTag)Helper.tagFromCompound(structures, "References");
        }

        @Override
        public CompoundTag getStructureStarts(ChunkData data) {
            CompoundTag structures = (CompoundTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Structures");
            return (CompoundTag)Helper.tagFromCompound(structures, "Starts");
        }
    }

    @MCVersionImplementation(value=100)
    public static class LightPopulated
    implements ChunkFilter.LightPopulated {
        @Override
        public ByteTag getLightPopulated(ChunkData data) {
            return (ByteTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "LightPopulated");
        }

        @Override
        public void setLightPopulated(ChunkData data, byte lightPopulated) {
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            if (level != null) {
                level.putLong("LightPopulated", lightPopulated);
            }
        }
    }

    @MCVersionImplementation(value=100)
    public static class Pos
    implements ChunkFilter.Pos {
        @Override
        public IntTag getXPos(ChunkData data) {
            return (IntTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "xPos");
        }

        @Override
        public IntTag getYPos(ChunkData data) {
            return null;
        }

        @Override
        public IntTag getZPos(ChunkData data) {
            return (IntTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "zPos");
        }
    }

    @MCVersionImplementation(value=100)
    public static class LastUpdate
    implements ChunkFilter.LastUpdate {
        @Override
        public LongTag getLastUpdate(ChunkData data) {
            return (LongTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "LastUpdate");
        }

        @Override
        public void setLastUpdate(ChunkData data, long lastUpdate) {
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            if (level != null) {
                level.putLong("LastUpdate", lastUpdate);
            }
        }
    }

    @MCVersionImplementation(value=100)
    public static class Status
    implements ChunkFilter.Status {
        @Override
        public StringTag getStatus(ChunkData data) {
            return null;
        }

        @Override
        public void setStatus(ChunkData data, StatusRegistry.StatusIdentifier status) {
        }

        @Override
        public boolean matchStatus(ChunkData data, StatusRegistry.StatusIdentifier status) {
            return false;
        }
    }

    @MCVersionImplementation(value=100)
    public static class InhabitedTime
    implements ChunkFilter.InhabitedTime {
        @Override
        public LongTag getInhabitedTime(ChunkData data) {
            return (LongTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "InhabitedTime");
        }

        @Override
        public void setInhabitedTime(ChunkData data, long inhabitedTime) {
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            if (level != null) {
                level.putLong("InhabitedTime", inhabitedTime);
            }
        }
    }

    @MCVersionImplementation(value=100)
    public static class Sections
    implements ChunkFilter.Sections {
        @Override
        public ListTag getSections(ChunkData data) {
            return (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
        }

        @Override
        public void deleteSections(ChunkData data, List<Range> ranges) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return;
            }
            for (int i = 0; i < sections.size(); ++i) {
                CompoundTag section = sections.getCompound(i);
                for (Range range : ranges) {
                    if (!range.contains(section.getInt("Y"))) continue;
                    sections.remove(i);
                    --i;
                }
            }
        }
    }

    @MCVersionImplementation(value=100)
    public static class TileEntities
    implements ChunkFilter.TileEntities {
        @Override
        public ListTag getTileEntities(ChunkData data) {
            return (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "TileEntities");
        }
    }

    @MCVersionImplementation(value=100)
    public static class Palette
    implements ChunkFilter.Palette {
        @Override
        public boolean paletteEquals(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            HashSet<Block> blocks = new HashSet<Block>();
            ArrayList<BlockData> blockData = new ArrayList<BlockData>(names.size());
            for (String name : names) {
                BlockData[] bd = mapping.get(name);
                if (bd == null) {
                    LOGGER.debug("no mapping found for {}", (Object)name);
                    continue;
                }
                blockData.addAll(Arrays.asList(bd));
            }
            for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                byte[] dataBits;
                byte[] blockBytes = Helper.byteArrayFromCompound(t, "Blocks");
                if (blockBytes == null || (dataBits = Helper.byteArrayFromCompound(t, "Data")) == null) continue;
                for (int i = 0; i < blockBytes.length; ++i) {
                    byte dataByte;
                    short b;
                    block8: {
                        b = (short)(blockBytes[i] & 0xFF);
                        for (BlockData d : blockData) {
                            if (b != d.id || !d.data.contains(dataByte = (byte)(i % 2 == 0 ? dataBits[i / 2] & 0xF : dataBits[i / 2] >> 4 & 0xF))) continue;
                            break block8;
                        }
                        return false;
                    }
                    blocks.add(new Block(b, dataByte));
                }
            }
            block4: for (BlockData bd : blockData) {
                for (Block block : blocks) {
                    if (bd.id != block.id || !bd.data.contains(block.data)) continue;
                    continue block4;
                }
                return false;
            }
            return true;
        }
    }

    @MCVersionImplementation(value=100)
    public static class Blocks
    implements ChunkFilter.Blocks {
        @Override
        public boolean matchBlockNames(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            int c = 0;
            block0: for (String name : names) {
                BlockData[] bd = mapping.get(name);
                if (bd == null) {
                    LOGGER.debug("no mapping found for {}", (Object)name);
                    continue;
                }
                for (Tag t : sections) {
                    byte[] blockData;
                    byte[] blocks = Helper.byteArrayFromCompound(t, "Blocks");
                    if (blocks == null || (blockData = Helper.byteArrayFromCompound(t, "Data")) == null) continue;
                    for (int i = 0; i < blocks.length; ++i) {
                        short b = (short)(blocks[i] & 0xFF);
                        for (BlockData d : bd) {
                            byte dataByte;
                            if (d.id != b || !d.data.contains(dataByte = (byte)(i % 2 == 0 ? blockData[i / 2] & 0xF : blockData[i / 2] >> 4 & 0xF))) continue;
                            ++c;
                            continue block0;
                        }
                    }
                }
            }
            return names.size() == c;
        }

        @Override
        public boolean matchAnyBlockName(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            for (String name : names) {
                BlockData[] bd = mapping.get(name);
                if (bd == null) {
                    LOGGER.debug("no mapping found for {}", (Object)name);
                    continue;
                }
                for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                    byte[] blockData;
                    byte[] blocks = Helper.byteArrayFromCompound(t, "Blocks");
                    if (blocks == null || (blockData = Helper.byteArrayFromCompound(t, "Data")) == null) continue;
                    for (int i = 0; i < blocks.length; ++i) {
                        short b = (short)(blocks[i] & 0xFF);
                        for (BlockData d : bd) {
                            byte dataByte;
                            if (d.id != b || !d.data.contains(dataByte = (byte)(i % 2 == 0 ? blockData[i / 2] & 0xF : blockData[i / 2] >> 4 & 0xF))) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public void replaceBlocks(ChunkData data, Map<String, ChunkFilter.BlockReplaceData> replace) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return;
            }
            if (replace.containsKey("minecraft:air")) {
                HashMap sectionMap = new HashMap();
                ArrayList<Integer> heights = new ArrayList<Integer>(18);
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    sectionMap.put(section.getInt("Y"), section);
                    heights.add(section.getInt("Y"));
                }
                for (int y = 0; y < 16; ++y) {
                    CompoundTag section;
                    if (!sectionMap.containsKey(y)) {
                        sectionMap.put(y, this.createEmptySection(y));
                        heights.add(y);
                        continue;
                    }
                    section = (CompoundTag)sectionMap.get(y);
                    if (section.containsKey("Blocks") && section.containsKey("Data")) continue;
                    sectionMap.put(y, this.createEmptySection(y));
                }
                heights.sort(Integer::compareTo);
                sections.clear();
                Iterator<Map.Entry<String, ChunkFilter.BlockReplaceData>> y = heights.iterator();
                while (y.hasNext()) {
                    int height = (Integer)((Object)y.next());
                    sections.add((Tag)sectionMap.get(height));
                }
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                for (Map.Entry<String, ChunkFilter.BlockReplaceData> entry : replace.entrySet()) {
                    BlockData[] bd = mapping.get(entry.getKey());
                    BlockData bdr = mapping.get(entry.getValue().getName())[0];
                    byte[] blocks = section.getByteArray("Blocks");
                    byte[] blockData = section.getByteArray("Data");
                    section.remove("BlockLight");
                    section.remove("SkyLight");
                    block5: for (int i = 0; i < blocks.length; ++i) {
                        byte dataByte = blockData[i / 2];
                        byte dataBits = (byte)(i % 2 == 0 ? dataByte & 0xF : dataByte >> 4 & 0xF);
                        for (BlockData d : bd) {
                            if (d.id != (blocks[i] & 0xFF) || !d.data.contains(dataBits)) continue;
                            blocks[i] = (byte)bdr.id;
                            byte newDataBits = bdr.data.iterator().next();
                            blockData[i / 2] = (byte)(i % 2 == 0 ? (dataByte & 0xF0) + newDataBits : (dataByte & 0xF) + (newDataBits << 4));
                            continue block5;
                        }
                    }
                }
            }
            ListTag tileEntities = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "TileEntities");
            if (tileEntities != null) {
                for (int i = 0; i < tileEntities.size(); ++i) {
                    CompoundTag tileEntity = tileEntities.getCompound(i);
                    String id = Helper.stringFromCompound(tileEntity, "id");
                    if (id == null || !replace.containsKey(id)) continue;
                    tileEntities.remove(i);
                    --i;
                }
            }
        }

        private CompoundTag createEmptySection(int y) {
            CompoundTag newSection = new CompoundTag();
            newSection.putByte("Y", (byte)y);
            newSection.putByteArray("Blocks", new byte[4096]);
            newSection.putByteArray("Data", new byte[2048]);
            return newSection;
        }

        @Override
        public int getBlockAmount(ChunkData data, String[] blocks) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return 0;
            }
            int result = 0;
            for (String blockName : blocks) {
                if (!mapping.containsKey(blockName)) continue;
                BlockData[] blockData = mapping.get(blockName);
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    byte[] blockIDsData;
                    byte[] blockIDs = Helper.byteArrayFromCompound(section, "Blocks");
                    if (blockIDs == null || (blockIDsData = Helper.byteArrayFromCompound(section, "Data")) == null) continue;
                    for (int i = 0; i < blockIDs.length; ++i) {
                        int blockID = blockIDs[i] & 0xFF;
                        byte dataByte = blockIDsData[i / 2];
                        byte dataBits = (byte)(i % 2 == 0 ? dataByte & 0xF : dataByte >> 4 & 0xF);
                        for (BlockData bd : blockData) {
                            if (blockID != bd.id || !bd.data.contains(dataBits)) continue;
                            ++result;
                        }
                    }
                }
            }
            return result;
        }

        @Override
        public int getAverageHeight(ChunkData data) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return 0;
            }
            sections.sort(this::filterSections);
            int totalHeight = 0;
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                        Number height;
                        byte[] blocks = Helper.byteArrayFromCompound(section, "Blocks");
                        if (blocks == null || (height = Helper.numberFromCompound(section, "Y", null)) == null) continue;
                        for (int cy = 15; cy >= 0; --cy) {
                            int index = cy * 256 + cz * 16 + cx;
                            if (this.isEmpty(blocks[index])) continue;
                            totalHeight += height.intValue() * 16 + cy;
                            continue block1;
                        }
                    }
                }
            }
            return totalHeight / 256;
        }

        private int filterSections(Tag sectionA, Tag sectionB) {
            return Helper.numberFromCompound(sectionB, "Y", -1).intValue() - Helper.numberFromCompound(sectionA, "Y", -1).intValue();
        }

        private boolean isEmpty(int blockID) {
            return blockID == 0 || blockID == 166 || blockID == 217;
        }
    }

    @MCVersionImplementation(value=100)
    public static class Biomes
    implements ChunkFilter.Biomes {
        @Override
        public boolean matchBiomes(ChunkData data, Collection<BiomeRegistry.BiomeIdentifier> biomes) {
            ByteArrayTag biomesTag = (ByteArrayTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Biomes");
            if (biomesTag == null) {
                return false;
            }
            block0: for (BiomeRegistry.BiomeIdentifier identifier : biomes) {
                for (byte dataID : biomesTag.getValue()) {
                    if (identifier.matches(dataID)) continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean matchAnyBiome(ChunkData data, Collection<BiomeRegistry.BiomeIdentifier> biomes) {
            ByteArrayTag biomesTag = (ByteArrayTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Biomes");
            if (biomesTag == null) {
                return false;
            }
            for (BiomeRegistry.BiomeIdentifier identifier : biomes) {
                for (byte dataID : biomesTag.getValue()) {
                    if (!identifier.matches(dataID)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void changeBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            ByteArrayTag biomesTag = (ByteArrayTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Biomes");
            if (biomesTag != null) {
                Arrays.fill(biomesTag.getValue(), (byte)biome.getID());
            }
        }

        @Override
        public void forceBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            if (level != null) {
                byte[] biomes = new byte[256];
                Arrays.fill(biomes, (byte)biome.getID());
                level.putByteArray("Biomes", biomes);
            }
        }
    }

    private static class Block {
        int id;
        byte data;

        Block(int id, byte data) {
            this.id = id;
            this.data = data;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.data);
        }

        public boolean equals(Object other) {
            return other instanceof Block && ((Block)other).id == this.id && ((Block)other).data == this.data;
        }
    }
}

