/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.color;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.StringTag;

public class BlockStates {
    private final Map<String, Map<String, Integer>> states;
    private final transient int size;
    private final transient int waterlogged;

    public BlockStates(Map<String, Map<String, Integer>> states, int size) {
        this.states = states;
        this.size = size;
        this.waterlogged = states.get("waterlogged").get("true");
    }

    public BlockStates(Map<String, Map<String, Integer>> states) {
        this.states = states;
        this.size = states.values().stream().mapToInt(Map::size).sum();
        this.waterlogged = states.get("waterlogged").get("true");
    }

    public BitSet getState(CompoundTag properties) {
        if (properties == null) {
            return null;
        }
        BitSet state = new BitSet(this.size);
        properties.forEach((k, v) -> {
            Integer i;
            Map<String, Integer> map = this.states.get(k);
            if (map != null && (i = map.get(((StringTag)v).getValue())) != null) {
                state.set(i);
            }
        });
        return state;
    }

    public BitSet getState(Map<String, String> properties) {
        BitSet state = new BitSet();
        properties.forEach((k, v) -> {
            Integer i;
            Map<String, Integer> map = this.states.get(k);
            if (map != null && (i = map.get(v)) != null) {
                state.set(i);
            }
        });
        return state;
    }

    public BitSet getState(String properties) {
        if (properties.isEmpty()) {
            return null;
        }
        BitSet state = new BitSet();
        String[] split = properties.split("[,=]");
        if ((split.length & 1) == 1) {
            return null;
        }
        for (int i = 0; i < split.length; i += 2) {
            state.set(this.states.getOrDefault(split[i], Collections.emptyMap()).getOrDefault(split[i + 1], 0));
        }
        return state;
    }

    public boolean isWaterlogged(BitSet state) {
        return state.get(this.waterlogged);
    }

    public boolean isWaterlogged(CompoundTag properties) {
        if (properties == null) {
            return false;
        }
        String w = properties.getStringOrDefault("waterlogged", null);
        return w != null && w.equals("true");
    }

    public int size() {
        return this.size;
    }

    public static class BlockStatesTypeAdapter
    extends TypeAdapter<BlockStates> {
        @Override
        public void write(JsonWriter out, BlockStates value) throws IOException {
            out.beginObject();
            TreeMap states = new TreeMap();
            value.states.forEach((k, v) -> states.put(k, new TreeMap(v)));
            for (Map.Entry entry : states.entrySet()) {
                out.name((String)entry.getKey());
                out.beginObject();
                for (Map.Entry stateEntry : ((TreeMap)entry.getValue()).entrySet()) {
                    out.name((String)stateEntry.getKey());
                    out.value((Number)stateEntry.getValue());
                }
                out.endObject();
            }
            out.endObject();
        }

        @Override
        public BlockStates read(JsonReader in) throws IOException {
            HashMap<String, Map<String, Integer>> states = new HashMap<String, Map<String, Integer>>();
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                states.put(name, map);
                in.beginObject();
                while (in.hasNext()) {
                    String value = in.nextName();
                    int index = in.nextInt();
                    map.put(value, index);
                }
                in.endObject();
            }
            in.endObject();
            return new BlockStates(states);
        }
    }
}

