/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.querz.mcaselector.version.mapping.minecraft.Blocks;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersion;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersionFile;
import net.querz.mcaselector.version.mapping.minecraft.Report;
import net.querz.mcaselector.version.mapping.util.CollectionAdapter;
import net.querz.mcaselector.version.mapping.util.Download;

public class BlockConfig {
    private final Set<String> blocks;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Set.class, new CollectionAdapter()).create();

    public BlockConfig() {
        this.blocks = new HashSet<String>();
    }

    public BlockConfig(Set<String> blocks) {
        this.blocks = blocks;
    }

    public static BlockConfig load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            BlockConfig blockConfig = BlockConfig.load(reader);
            return blockConfig;
        }
    }

    public static BlockConfig load(Reader reader) throws IOException {
        return new BlockConfig(GSON.fromJson(reader, new TypeToken<Set<String>>(){}));
    }

    public void save(Path path) throws IOException {
        String json = GSON.toJson(this.blocks);
        Files.writeString(path, (CharSequence)json, new OpenOption[0]);
    }

    public void merge(BlockConfig other) {
        this.blocks.addAll(other.blocks);
    }

    public void generate(MinecraftVersion version, Path tmp) throws IOException, InterruptedException {
        Path versionJson = tmp.resolve("version.json");
        Path serverJar = tmp.resolve("server.jar");
        Path generated = tmp.resolve("generated");
        if (!Files.exists(versionJson, new LinkOption[0])) {
            MinecraftVersionFile.download(version, versionJson);
        }
        MinecraftVersionFile versionFile = MinecraftVersionFile.load(versionJson);
        if (!Files.exists(serverJar, new LinkOption[0])) {
            Download.to(versionFile.getDownloads().server().url(), serverJar);
        }
        if (!Files.exists(generated, new LinkOption[0])) {
            Report.generate(serverJar, generated);
        }
        Path blocksJson = generated.resolve("reports/blocks.json");
        Blocks blocks = Blocks.load(blocksJson);
        blocks.states.keySet().forEach(k -> this.blocks.add(k.substring(10)));
    }
}

