/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javax.imageio.ImageIO;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.version.mapping.color.BiomeColors;
import net.querz.mcaselector.version.mapping.color.BlockColor;
import net.querz.mcaselector.version.mapping.color.BlockStates;
import net.querz.mcaselector.version.mapping.color.ColorMapping;
import net.querz.mcaselector.version.mapping.color.SingleStateColors;
import net.querz.mcaselector.version.mapping.color.StateColors;
import net.querz.mcaselector.version.mapping.minecraft.Biome;
import net.querz.mcaselector.version.mapping.minecraft.Blocks;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersion;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersionFile;
import net.querz.mcaselector.version.mapping.minecraft.Report;
import net.querz.mcaselector.version.mapping.util.BitSetAdapter;
import net.querz.mcaselector.version.mapping.util.CollectionAdapter;
import net.querz.mcaselector.version.mapping.util.Download;
import net.querz.mcaselector.version.mapping.util.HexColorAdapter;
import net.querz.nbt.CompoundTag;

public class ColorConfig {
    @SerializedName(value="states")
    public BlockStates states;
    @SerializedName(value="colors")
    public ColorMapping colors;
    @SerializedName(value="tints")
    public BiomeColors tints;
    public transient ColorMapping.TintCache tintCache;
    public transient ColorMapping.LegacyTintCache legacyTintCache;
    public static final ColorProperties colorProperties = FileHelper.loadFromResource("mapping/color_properties.json", ColorProperties::load);
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)BitSet.class), new BitSetAdapter()).registerTypeHierarchyAdapter(BlockColor.class, new BlockColor.BlockColorAdapter()).registerTypeAdapter((Type)((Object)SingleStateColors.class), new SingleStateColors.SingleStateColorsAdapter()).registerTypeAdapter((Type)((Object)BlockStates.class), new BlockStates.BlockStatesTypeAdapter()).registerTypeAdapter((Type)((Object)BiomeColors.class), new BiomeColors.BiomeColorsTypeAdapter()).registerTypeAdapterFactory(ColorMapping.ColorMappingTypeAdapterFactory.getColorMappingTypeAdapterFactory()).registerTypeAdapterFactory(StateColors.StateColorsTypeAdapterFactory.getStateColorsTypeAdapterFactory()).registerTypeHierarchyAdapter(Set.class, new CollectionAdapter()).enableComplexMapKeySerialization().disableHtmlEscaping().setPrettyPrinting().create();

    public static ColorConfig load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ColorConfig colorConfig = ColorConfig.load(reader);
            return colorConfig;
        }
    }

    public static ColorConfig load(Reader reader) {
        ColorConfig cfg = GSON.fromJson(reader, ColorConfig.class);
        cfg.tintCache = cfg.colors.createTintCache(cfg.tints);
        return cfg;
    }

    public static ColorConfig loadLegacy(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ColorConfig colorConfig = ColorConfig.loadLegacy(reader);
            return colorConfig;
        }
    }

    public static ColorConfig loadLegacy(Reader reader) {
        ColorConfig cfg = GSON.fromJson(reader, ColorConfig.class);
        cfg.legacyTintCache = cfg.colors.createLegacyTintCache(cfg.tints);
        return cfg;
    }

    public void save(Path path) throws IOException {
        String json = GSON.toJson(this);
        Files.writeString(path, (CharSequence)json, new OpenOption[0]);
    }

    public BlockColor getColor(String name, String biome, CompoundTag tag) {
        BitSet blockState = this.states.getState(tag);
        BlockColor blockColor = this.colors.getBlockColor(name, blockState);
        if ((blockColor.properties & 0x8E) > 0) {
            BlockColor tinted = this.tintCache.getColor(name, biome, blockState);
            return tinted == null ? this.tintCache.getColor(name, "minecraft:plains", null) : tinted;
        }
        return blockColor;
    }

    public int getLegacyColor(String name, int biome, CompoundTag tag) {
        BitSet blockState = this.states.getState(tag);
        BlockColor blockColor = this.colors.getBlockColor(name, blockState);
        if ((blockColor.properties & 0x8E) > 0) {
            return this.legacyTintCache.getColor(name, biome, blockState);
        }
        return blockColor.color;
    }

    public void generate(MinecraftVersion version, Path tmp) throws IOException, InterruptedException {
        BlockStates blockStates;
        Path versionJson = tmp.resolve("version.json");
        Path clientJar = tmp.resolve("client.jar");
        Path serverJar = tmp.resolve("server.jar");
        Path generated = tmp.resolve("generated");
        if (!Files.exists(versionJson, new LinkOption[0])) {
            MinecraftVersionFile.download(version, versionJson);
        }
        MinecraftVersionFile versionFile = MinecraftVersionFile.load(versionJson);
        if (!Files.exists(serverJar, new LinkOption[0])) {
            Download.to(versionFile.getDownloads().server().url(), serverJar);
        }
        if (!Files.exists(clientJar, new LinkOption[0])) {
            Download.to(versionFile.getDownloads().client().url(), clientJar);
        }
        if (!Files.exists(generated, new LinkOption[0])) {
            Report.generate(serverJar, generated);
        }
        Path blocksJson = generated.resolve("reports/blocks.json");
        Blocks blocks = Blocks.load(blocksJson);
        this.states = blockStates = blocks.generateBlockStates();
        HashMap<String, String> waterloggedTrue = new HashMap<String, String>();
        waterloggedTrue.put("waterlogged", "true");
        HashMap<String, String> waterloggedFalse = new HashMap<String, String>();
        waterloggedFalse.put("waterlogged", "false");
        ColorMapping mapping = new ColorMapping();
        BiomeColors tints = new BiomeColors();
        try (FileSystem fs = FileSystems.newFileSystem(clientJar);){
            Path assetBase = fs.getPath("assets/minecraft", new String[0]);
            Path assetBlockstates = assetBase.resolve("blockstates");
            Path assetModels = assetBase.resolve("models");
            Path assetTextures = assetBase.resolve("textures");
            for (Map.Entry<String, Blocks.Block> states : blocks.states.entrySet()) {
                String blockName = states.getKey();
                if (colorProperties.isAir(blockName)) continue;
                if (ColorConfig.colorProperties.staticColor.containsKey(blockName)) {
                    mapping.setBlockColor(blockName, new SingleStateColors(new BlockColor(ColorConfig.colorProperties.staticColor.get(blockName), colorProperties.get(blockName))));
                    continue;
                }
                Path assetBlockState = assetBlockstates.resolve(this.trimNS(blockName) + ".json");
                JsonObject jsonBlockstate = this.readJSONAsset(assetBlockState);
                JsonObject variants = jsonBlockstate.getAsJsonObject("variants");
                if (variants != null) {
                    boolean canBeWaterlogged = states.getValue().properties().containsKey("waterlogged");
                    for (Map.Entry entry : variants.entrySet()) {
                        String model = ((JsonElement)entry.getValue()).isJsonArray() ? this.trimNS(((JsonElement)entry.getValue()).getAsJsonArray().get(0).getAsJsonObject().get("model").getAsString()) : this.trimNS(((JsonElement)entry.getValue()).getAsJsonObject().get("model").getAsString());
                        Map<String, String> textureMapping = this.resolveTextureMapping(model, assetModels);
                        String topTexture = this.trimNS(this.getTopTextureName(textureMapping));
                        Path assetTexture = assetTextures.resolve(topTexture + ".png");
                        int color = this.averageColor(assetTexture);
                        BitSet blockStateBits = blockStates.getState((String)entry.getKey());
                        if (canBeWaterlogged && blockStateBits != null) {
                            BitSet blockStateBitsWT = blockStates.getState(waterloggedTrue);
                            blockStateBitsWT.or(blockStateBits);
                            mapping.addBlockColor(blockName, blockStateBitsWT, new BlockColor(color, colorProperties.get(blockName)));
                            BitSet blockStateBitsWF = blockStates.getState(waterloggedFalse);
                            blockStateBitsWF.or(blockStateBits);
                            mapping.addBlockColor(blockName, blockStateBitsWF, new BlockColor(color, colorProperties.get(blockName)));
                            continue;
                        }
                        mapping.addBlockColor(blockName, blockStateBits, new BlockColor(color, colorProperties.get(blockName)));
                    }
                } else {
                    JsonArray multipart = jsonBlockstate.getAsJsonArray("multipart");
                    if (multipart != null) {
                        JsonObject part = multipart.get(0).getAsJsonObject();
                        String model = part.get("apply").isJsonObject() ? this.trimNS(part.getAsJsonObject("apply").get("model").getAsString()) : this.trimNS(part.getAsJsonArray("apply").get(0).getAsJsonObject().get("model").getAsString());
                        Map<String, String> map = this.resolveTextureMapping(model, assetModels);
                        String topTexture = this.trimNS(this.getTopTextureName(map));
                        Path assetTexture = assetTextures.resolve(topTexture + ".png");
                        int color = this.averageColor(assetTexture);
                        mapping.addBlockColor(blockName, null, new BlockColor(color, colorProperties.get(blockName)));
                    }
                }
                if (!ColorConfig.colorProperties.staticTint.containsKey(blockName)) continue;
                BlockColor rawColor = mapping.getBlockColor(blockName, null);
                BlockColor tinted = new BlockColor(ColorMapping.applyTint(rawColor.color, ColorConfig.colorProperties.staticTint.get(blockName)), rawColor.properties);
                mapping.setBlockColor(blockName, new SingleStateColors(tinted));
            }
            Path biomes = generated.resolve("data/minecraft/worldgen/biome");
            Path assetGrass = assetBase.resolve("textures/colormap/grass.png");
            Path assetFoliage = assetBase.resolve("textures/colormap/foliage.png");
            Path assetDryFoliage = assetBase.resolve("textures/colormap/dry_foliage.png");
            BufferedImage grassTints = ImageIO.read(Files.newInputStream(assetGrass, new OpenOption[0]));
            BufferedImage foliageTints = ImageIO.read(Files.newInputStream(assetFoliage, new OpenOption[0]));
            BufferedImage dryFoliageTints = ImageIO.read(Files.newInputStream(assetDryFoliage, new OpenOption[0]));
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(biomes);){
                for (Path path : ds) {
                    if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                    Biome biome = Biome.load(path);
                    int grassTint = Objects.requireNonNullElseGet(biome.effects.grassTint(), () -> this.getColorMapping(biome.temperature, biome.downfall, grassTints));
                    int foliageTint = Objects.requireNonNullElseGet(biome.effects.foliageTint(), () -> this.getColorMapping(biome.temperature, biome.downfall, foliageTints));
                    int dryFoliageTint = Objects.requireNonNullElseGet(biome.effects.dryFoliageTint(), () -> this.getColorMapping(biome.temperature, biome.downfall, dryFoliageTints));
                    String fileName = path.getFileName().toString();
                    tints.addTints("minecraft:" + fileName.substring(0, fileName.length() - 5), new BiomeColors.BiomeTints(grassTint, foliageTint, biome.effects.waterTint(), dryFoliageTint));
                }
            }
        }
        mapping.compress();
        this.colors = mapping;
        this.tints = tints;
    }

    private String trimNS(String s) {
        return s.substring(s.indexOf(58) + 1);
    }

    private JsonObject readJSONAsset(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonObject = JsonParser.parseReader(reader).getAsJsonObject();
            return jsonObject;
        }
    }

    private Map<String, String> resolveTextureMapping(String model, Path assetBlockmodels) throws IOException {
        Path modelPath = assetBlockmodels.resolve(model + ".json");
        HashMap<String, String> mapping = new HashMap<String, String>();
        Path parent = modelPath;
        while (parent != null) {
            BufferedReader reader = Files.newBufferedReader(parent);
            try {
                JsonObject pRoot = JsonParser.parseReader(reader).getAsJsonObject();
                if (pRoot.has("textures")) {
                    for (Map.Entry<String, JsonElement> entry : pRoot.getAsJsonObject("textures").entrySet()) {
                        mapping.putIfAbsent(entry.getKey(), entry.getValue().getAsString());
                    }
                }
                if (!pRoot.has("parent")) {
                    parent = null;
                    continue;
                }
                String ps = this.trimNS(pRoot.get("parent").getAsString());
                parent = assetBlockmodels.resolve(ps + ".json");
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return mapping;
    }

    private String getTopTextureName(Map<String, String> mapping) {
        if (mapping.containsKey("top")) {
            return this.resolveTextureReference("top", mapping);
        }
        if (mapping.containsKey("up")) {
            return this.resolveTextureReference("up", mapping);
        }
        if (mapping.containsKey("all")) {
            return this.resolveTextureReference("all", mapping);
        }
        if (mapping.containsKey("particle")) {
            return this.resolveTextureReference("particle", mapping);
        }
        throw new IllegalStateException("block doesn't have top texture");
    }

    private String resolveTextureReference(String key, Map<String, String> mapping) {
        String t = mapping.get(key);
        while (t.startsWith("#")) {
            t = mapping.get(t.substring(1));
        }
        return t;
    }

    private int averageColor(Path img) {
        int n;
        block11: {
            InputStream inputStream = Files.newInputStream(img, new OpenOption[0]);
            try {
                Image image = new Image(inputStream);
                PixelReader pr = image.getPixelReader();
                long r = 0L;
                long g = 0L;
                long b = 0L;
                int c = 0;
                int x = 0;
                while ((double)x < image.getWidth()) {
                    int y = 0;
                    while ((double)y < image.getHeight()) {
                        int p = pr.getArgb(x, y);
                        if (p >> 24 != 0) {
                            r += (long)(p >> 16 & 0xFF);
                            g += (long)(p >> 8 & 0xFF);
                            b += (long)(p & 0xFF);
                            ++c;
                        }
                        ++y;
                    }
                    ++x;
                }
                int ir = (int)(r / (long)c);
                int ig = (int)(g / (long)c);
                int ib = (int)(b / (long)c);
                n = ir << 16 | ig << 8 | ib;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return 0xFFFFFF;
                }
            }
            inputStream.close();
        }
        return n;
    }

    private int getColorMapping(double temperature, double downfall, BufferedImage map) {
        double adjTemperature = Math.max(0.0, Math.min(1.0, temperature));
        double adjDownfall = Math.max(0.0, Math.min(1.0, downfall)) * adjTemperature;
        int pixelX = (int)(255.0 - adjTemperature * 255.0);
        int pixelY = (int)(255.0 - adjDownfall * 255.0);
        return map.getRGB(pixelX, pixelY) & 0xFFFFFF;
    }

    public record ColorProperties(@SerializedName(value="air") Set<String> air, @SerializedName(value="transparent") Set<String> transparent, @SerializedName(value="grass_tint") Set<String> grassTint, @SerializedName(value="foliage_tint") Set<String> foliageTint, @SerializedName(value="dry_foliage_tint") Set<String> dryFoliageTint, @SerializedName(value="water") Set<String> water, @SerializedName(value="foliage") Set<String> foliage, @SerializedName(value="static_tint") Map<String, Integer> staticTint, @SerializedName(value="static_color") Map<String, Integer> staticColor) {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter((Type)((Object)Integer.class), new HexColorAdapter()).create();

        public static ColorProperties load(Path path) throws IOException {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                ColorProperties colorProperties = ColorProperties.load(reader);
                return colorProperties;
            }
        }

        public static ColorProperties load(Reader reader) throws IOException {
            return GSON.fromJson(reader, ColorProperties.class);
        }

        public boolean isAir(String blockName) {
            return this.air.contains(blockName);
        }

        public int getTransparent(String blockName) {
            return this.transparent.contains(blockName) ? 1 : 0;
        }

        public int getGrassTint(String blockName) {
            return this.grassTint.contains(blockName) ? 2 : 0;
        }

        public int getFoliageTint(String blockName) {
            return this.foliageTint.contains(blockName) ? 4 : 0;
        }

        public int getWater(String blockName) {
            return this.water.contains(blockName) ? 8 : 0;
        }

        public int getFoliage(String blockName) {
            return this.foliage.contains(blockName) ? 16 : 0;
        }

        public int getStaticTint(String blockName) {
            return this.staticTint.containsKey(blockName) ? 32 : 0;
        }

        public int getStaticColor(String blockName) {
            return this.staticColor.containsKey(blockName) ? 64 : 0;
        }

        public int getDryFoliageTint(String blockName) {
            return this.dryFoliageTint.contains(blockName) ? 128 : 0;
        }

        public int get(String blockName) {
            return this.getTransparent(blockName) | this.getGrassTint(blockName) | this.getFoliageTint(blockName) | this.getWater(blockName) | this.getFoliage(blockName) | this.getStaticTint(blockName) | this.getStaticColor(blockName) | this.getDryFoliageTint(blockName);
        }
    }
}

