/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.minecraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.querz.mcaselector.version.mapping.color.BlockStates;

public class Blocks {
    public Map<String, Block> states;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Blocks load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Blocks blocks = new Blocks();
            blocks.states = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, Block>>(){}.getType());
            Blocks blocks2 = blocks;
            return blocks2;
        }
    }

    public BlockStates generateBlockStates() {
        TreeMap<String, Set<String>> properties = this.parseProperties();
        TreeMap<String, Map<String, Integer>> indexedProperties = new TreeMap<String, Map<String, Integer>>();
        int index = 0;
        for (Map.Entry entry : properties.entrySet()) {
            HashMap<String, Integer> indexedValues = new HashMap<String, Integer>();
            for (String value : (Set)entry.getValue()) {
                indexedValues.put(value, index++);
            }
            indexedProperties.put((String)entry.getKey(), indexedValues);
        }
        return new BlockStates(indexedProperties, index - 1);
    }

    private TreeMap<String, Set<String>> parseProperties() {
        HashMap<String, Integer> frequencies = new HashMap<String, Integer>();
        HashMap<String, Set> properties = new HashMap<String, Set>();
        for (Map.Entry<String, Block> e : this.states.entrySet()) {
            for (Map.Entry<String, Set<String>> property : e.getValue().properties().entrySet()) {
                properties.computeIfAbsent(property.getKey(), k -> new HashSet()).addAll((Collection)property.getValue());
                frequencies.compute(property.getKey(), (k, v) -> v == null ? 1 : v + 1);
            }
        }
        TreeMap<String, Set<String>> ordered = new TreeMap<String, Set<String>>(Comparator.comparingInt(a -> (Integer)frequencies.get(a)).thenComparing(a -> a).reversed());
        ordered.putAll(properties);
        return ordered;
    }

    public static class Block {
        private Map<String, Set<String>> properties;
        public Set<State> states;

        public Map<String, Set<String>> properties() {
            return this.properties == null ? Collections.emptyMap() : this.properties;
        }

        public static class State {
            public int id;
            private Map<String, String> properties;

            public Map<String, String> properties() {
                return this.properties == null ? Collections.emptyMap() : this.properties;
            }
        }
    }
}

