/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.minecraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersion;

public final class MinecraftVersionFile {
    @SerializedName(value="downloads")
    private Downloads downloads;
    private static final Gson GSON = new GsonBuilder().create();

    private MinecraftVersionFile() {
    }

    public static MinecraftVersionFile load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            MinecraftVersionFile minecraftVersionFile = GSON.fromJson((Reader)reader, MinecraftVersionFile.class);
            return minecraftVersionFile;
        }
    }

    public static void download(MinecraftVersion minecraftVersion, Path output) throws IOException {
        net.querz.mcaselector.version.mapping.util.Download.to(minecraftVersion.url(), output);
    }

    public Downloads getDownloads() {
        return this.downloads;
    }

    public record Downloads(@SerializedName(value="client") Download client, @SerializedName(value="client_mappings") Download clientMappings, @SerializedName(value="server") Download server, @SerializedName(value="server_mappings") Download serverMappings) {
    }

    public record Download(@SerializedName(value="sha1") String sha1, @SerializedName(value="size") int size, @SerializedName(value="url") String url) {
    }
}

