/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.minecraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersion;
import net.querz.mcaselector.version.mapping.util.Download;

public final class VersionManifest {
    @SerializedName(value="latest")
    private Latest latest;
    @SerializedName(value="versions")
    private List<MinecraftVersion> versions;
    private final transient Map<String, MinecraftVersion> versionMap = new HashMap<String, MinecraftVersion>();
    private static final Gson GSON = new GsonBuilder().create();

    private VersionManifest() {
    }

    public static VersionManifest load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            VersionManifest vm = GSON.fromJson((Reader)reader, VersionManifest.class);
            vm.versions.forEach(v -> vm.versionMap.put(v.id(), (MinecraftVersion)v));
            VersionManifest versionManifest = vm;
            return versionManifest;
        }
    }

    public static void download(Path output) throws IOException {
        Download.to("https://launchermeta.mojang.com/mc/game/version_manifest.json", output);
    }

    public MinecraftVersion getVersionByID(String id) {
        return this.versionMap.get(id);
    }

    public MinecraftVersion latestRelease() {
        return this.getVersionByID(this.latest.release);
    }

    public MinecraftVersion latestSnapshot() {
        return this.getVersionByID(this.latest.snapshot);
    }

    public List<MinecraftVersion> getVersions() {
        return Collections.unmodifiableList(this.versions);
    }

    public List<MinecraftVersion> getReleases() {
        return this.versions.stream().filter(v -> v.type() == MinecraftVersion.Type.RELEASE).toList();
    }

    public List<MinecraftVersion> getSnapshots() {
        return this.versions.stream().filter(v -> v.type() == MinecraftVersion.Type.SNAPSHOT).toList();
    }

    public List<MinecraftVersion> getOldAlpha() {
        return this.versions.stream().filter(v -> v.type() == MinecraftVersion.Type.OLD_ALPHA).toList();
    }

    public List<MinecraftVersion> getOldBeta() {
        return this.versions.stream().filter(v -> v.type() == MinecraftVersion.Type.OLD_BETA).toList();
    }

    private record Latest(@SerializedName(value="release") String release, @SerializedName(value="snapshot") String snapshot) {
    }
}

