/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.querz.mcaselector.io.FileHelper;

public final class BiomeRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, Integer> nameMapping = FileHelper.loadFromResource("mapping/registry/biome_name_to_id.json", r -> (Map)GSON.fromJson((Reader)r, new TypeToken<Map<String, Integer>>(){}.getType()));
    private static final Map<Integer, String> idMapping = new HashMap<Integer, String>();
    private static final Set<String> mapping;

    private BiomeRegistry() {
    }

    public static boolean isValidName(String name) {
        return mapping.contains(name);
    }

    public static boolean isValidID(int id) {
        return idMapping.containsKey(id);
    }

    public static String toName(int id) {
        return idMapping.get(id);
    }

    public static Integer toID(String name) {
        return nameMapping.getOrDefault(name, null);
    }

    static {
        nameMapping.forEach((k, v) -> idMapping.put((Integer)v, (String)k));
        mapping = FileHelper.loadFromResource("mapping/registry/biomes.json", r -> (Set)GSON.fromJson((Reader)r, new TypeToken<Set<String>>(){}.getType()));
    }

    public static class BiomeIdentifier
    implements Serializable {
        Integer id;
        String name;

        public BiomeIdentifier(String name) {
            this(name, BiomeRegistry.toID(name));
        }

        public BiomeIdentifier(int id) {
            this(BiomeRegistry.toName(id), id);
        }

        public BiomeIdentifier(String name, Integer id) {
            this.id = id;
            this.name = name;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean matches(String name) {
            return this.name != null && this.name.equals(name);
        }

        public boolean matches(int id) {
            return this.id == id;
        }

        public String toString() {
            if (this.name != null) {
                if (BiomeRegistry.isValidName(this.name)) {
                    return this.name;
                }
                return "'" + this.name + "'";
            }
            if (this.id != null) {
                if (BiomeRegistry.isValidID(this.id)) {
                    return Integer.toString(this.id);
                }
                return "'" + this.id + "'";
            }
            return "";
        }
    }
}

