/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.querz.mcaselector.io.FileHelper;

public final class BlockRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, String> valid = FileHelper.loadFromResource("mapping/registry/blocks.json", r -> {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        List status = (List)GSON.fromJson((Reader)r, new TypeToken<List<String>>(){}.getType());
        for (String s : status) {
            map.put(s, "minecraft:" + s);
            map.put("minecraft:" + s, s);
        }
        return map;
    });

    private BlockRegistry() {
    }

    public static boolean isValidName(String name) {
        return valid.containsKey(name) || name != null && name.startsWith("'") && name.endsWith("'");
    }

    public static String[] parseBlockNames(String raw) {
        String[] split;
        ArrayList<String> blocks = new ArrayList<String>();
        for (String s : split = raw.split(",")) {
            if ((s = s.trim()).length() >= 2 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
                blocks.add(s.substring(1, s.length() - 1));
            }
            if (!valid.containsKey(s)) continue;
            if (s.startsWith("minecraft:")) {
                blocks.add(s);
                continue;
            }
            blocks.add(valid.get(s));
        }
        if (blocks.isEmpty()) {
            return null;
        }
        return blocks.toArray(new String[0]);
    }
}

