/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.querz.mcaselector.io.FileHelper;

public final class StatusRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, String> valid = FileHelper.loadFromResource("mapping/registry/status.json", r -> {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        List status = (List)GSON.fromJson((Reader)r, new TypeToken<List<String>>(){}.getType());
        for (String s : status) {
            map.put(s, "minecraft:" + s);
            map.put("minecraft:" + s, s);
        }
        return map;
    });

    private StatusRegistry() {
    }

    public static boolean isValidName(String name) {
        return valid.containsKey(name) || name != null && name.startsWith("'") && name.endsWith("'");
    }

    public static class StatusIdentifier
    implements Serializable {
        String name;
        String nameWithNamespace;
        boolean custom = false;

        public StatusIdentifier(String name) {
            if (name != null && name.startsWith("'") && name.endsWith("'")) {
                this.name = name.substring(1, name.length() - 1);
                this.custom = true;
            } else if (name != null && StatusRegistry.isValidName(name)) {
                this.initValid(name);
            } else {
                throw new IllegalArgumentException("invalid status");
            }
        }

        public StatusIdentifier(String name, boolean custom) {
            if (custom) {
                this.name = name;
                this.custom = true;
            } else if (StatusRegistry.isValidName(name)) {
                this.initValid(name);
            } else {
                throw new IllegalArgumentException("invalid status");
            }
        }

        private void initValid(String name) {
            if (name.startsWith("minecraft:")) {
                this.name = valid.get(name);
                this.nameWithNamespace = name;
            } else {
                this.name = name;
                this.nameWithNamespace = valid.get(name);
            }
        }

        public String getStatus() {
            return this.name;
        }

        public String getStatusWithNamespace() {
            if (this.custom) {
                return this.name;
            }
            return this.nameWithNamespace;
        }

        public boolean equals(String value) {
            if (value == null) {
                return false;
            }
            if (this.custom) {
                return this.name.equals(value);
            }
            return value.startsWith("minecraft:") && value.equals(this.nameWithNamespace) || value.equals(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

