/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.FloatTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.NumberTag;
import net.querz.nbt.ShortTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class CompoundTag
implements Tag,
Map<String, Tag>,
Iterable<Map.Entry<String, Tag>> {
    private final Map<String, Tag> value;
    public static final TagReader<CompoundTag> READER = new TagReader<CompoundTag>(){

        @Override
        public CompoundTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            byte type;
            if (depth > 512) {
                throw new RuntimeException("tried to read NBT tag with too high complexity, depth > 512");
            }
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            while ((type = in.readByte()) != Tag.Type.END.id) {
                String key = in.readUTF();
                TagReader<?> tagReader = Tag.Type.valueOf((byte)type).reader;
                Object tag = tagReader.read(in, rawArrays, depth + 1);
                map.put(key, (Tag)tag);
            }
            return new CompoundTag(map);
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            byte id;
            block11: while ((id = in.readByte()) != Tag.Type.END.id) {
                TagReader<?> reader = Tag.Type.valueOf((byte)id).reader;
                switch (visitor.visitEntry(reader)) {
                    case RETURN: {
                        return TagTypeVisitor.ValueResult.RETURN;
                    }
                    case BREAK: {
                        StringTag.skipUTF(in);
                        reader.skip(in);
                        break block11;
                    }
                    case SKIP: {
                        StringTag.skipUTF(in);
                        reader.skip(in);
                        continue block11;
                    }
                    default: {
                        String name = in.readUTF();
                        switch (visitor.visitEntry(reader, name)) {
                            case RETURN: {
                                return TagTypeVisitor.ValueResult.RETURN;
                            }
                            case BREAK: {
                                reader.skip(in);
                                break block11;
                            }
                            case SKIP: {
                                reader.skip(in);
                                continue block11;
                            }
                            case ENTER: {
                                if (reader.read(in, visitor, rawArrays) != TagTypeVisitor.ValueResult.RETURN) continue block11;
                                return TagTypeVisitor.ValueResult.RETURN;
                            }
                        }
                    }
                }
            }
            if (id != Tag.Type.END.id) {
                while ((id = in.readByte()) != Tag.Type.END.id) {
                    StringTag.skipUTF(in);
                    Tag.Type.valueOf((byte)id).reader.skip(in);
                }
            }
            return visitor.visitContainerEnd();
        }

        @Override
        public void skip(DataInput in) throws IOException {
            byte type;
            while ((type = in.readByte()) != Tag.Type.END.id) {
                in.skipBytes(in.readUnsignedShort());
                Tag.Type.valueOf((byte)type).reader.skip(in);
            }
        }
    };

    public CompoundTag(Map<String, Tag> map) {
        this.value = map;
    }

    public CompoundTag() {
        this(new HashMap<String, Tag>());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        for (String key : this.value.keySet()) {
            Tag tag = this.value.get(key);
            out.writeByte(tag.getType().id);
            if (tag.getType() == Tag.Type.END) continue;
            out.writeUTF(key);
            tag.write(out);
        }
        out.writeByte(Tag.Type.END.id);
    }

    @Override
    public CompoundTag copy() {
        HashMap<String, Tag> copy = new HashMap<String, Tag>();
        this.value.forEach((? super K k, ? super V v) -> copy.put((String)k, v.copy()));
        return new CompoundTag(copy);
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompoundTag && Objects.equals(this.value, ((CompoundTag)other).value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public void clear() {
        this.value.clear();
    }

    @Override
    public Tag put(String key, Tag tag) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(tag);
        if (tag.getType() == Tag.Type.END) {
            throw new IllegalArgumentException("Can't insert end tag into CompoundTag");
        }
        return this.value.put(key, tag);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Tag> m) {
        for (Map.Entry<? extends String, ? extends Tag> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putByte(String key, byte b) {
        this.put(key, ByteTag.valueOf(b));
    }

    public void putShort(String key, short s) {
        this.put(key, ShortTag.valueOf(s));
    }

    public void putInt(String key, int i) {
        this.put(key, IntTag.valueOf(i));
    }

    public void putLong(String key, long l) {
        this.put(key, LongTag.valueOf(l));
    }

    public void putFloat(String key, float f) {
        this.put(key, FloatTag.valueOf(f));
    }

    public void putDouble(String key, double d) {
        this.put(key, DoubleTag.valueOf(d));
    }

    public void putString(String key, String s) {
        this.put(key, StringTag.valueOf(s));
    }

    public void putByteArray(String key, byte[] b) {
        this.put(key, new ByteArrayTag(b));
    }

    public void putIntArray(String key, int[] i) {
        this.put(key, new IntArrayTag(i));
    }

    public void putLongArray(String key, long[] l) {
        this.put(key, new LongArrayTag(l));
    }

    public void putBoolean(String key, boolean b) {
        this.put(key, ByteTag.valueOf(b));
    }

    public Tag get(String key) {
        return this.value.get(key);
    }

    @Override
    @Deprecated
    public Tag get(Object key) {
        return this.get((String)key);
    }

    public byte getByte(String key) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No numeric tag with key '" + key + "'");
        }
        return tag.asByte();
    }

    public short getShort(String key) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No numeric tag with key '" + key + "'");
        }
        return tag.asShort();
    }

    public int getInt(String key) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No numeric tag with key '" + key + "'");
        }
        return tag.asInt();
    }

    public long getLong(String key) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No numeric tag with key '" + key + "'");
        }
        return tag.asLong();
    }

    public float getFloat(String key) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No numeric tag with key '" + key + "'");
        }
        return tag.asFloat();
    }

    public double getDouble(String key) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No numeric tag with key '" + key + "'");
        }
        return tag.asDouble();
    }

    public String getString(String key) {
        StringTag tag = this.getStringTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No string tag with key '" + key + "'");
        }
        return tag.getValue();
    }

    public byte[] getByteArray(String key) {
        ByteArrayTag tag = this.getByteArrayTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No byte array tag with key '" + key + "'");
        }
        return tag.getValue();
    }

    public int[] getIntArray(String key) {
        IntArrayTag tag = this.getIntArrayTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No int array tag with key '" + key + "'");
        }
        return tag.getValue();
    }

    public long[] getLongArray(String key) {
        LongArrayTag tag = this.getLongArrayTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No long array tag with key '" + key + "'");
        }
        return tag.getValue();
    }

    public CompoundTag getCompound(String key) {
        CompoundTag tag = this.getCompoundTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No compound tag with key '" + key + "'");
        }
        return tag;
    }

    public ListTag getList(String key) {
        ListTag tag = this.getListTag(key);
        if (tag == null) {
            throw new NoSuchElementException("No list tag with key '" + key + "'");
        }
        return tag;
    }

    public boolean getBoolean(String key) {
        return this.getByte(key) != 0;
    }

    public Tag getOrDefault(String key, Tag def) {
        return this.value.getOrDefault(key, def);
    }

    public byte getByteOrDefault(String key, byte def) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            return def;
        }
        return tag.asByte();
    }

    public short getShortOrDefault(String key, short def) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            return def;
        }
        return tag.asShort();
    }

    public int getIntOrDefault(String key, int def) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            return def;
        }
        return tag.asInt();
    }

    public long getLongOrDefault(String key, long def) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            return def;
        }
        return tag.asLong();
    }

    public float getFloatOrDefault(String key, float def) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            return def;
        }
        return tag.asFloat();
    }

    public double getDoubleOrDefault(String key, double def) {
        NumberTag tag = this.getNumberTag(key);
        if (tag == null) {
            return def;
        }
        return tag.asDouble();
    }

    public String getStringOrDefault(String key, String def) {
        StringTag tag = this.getStringTag(key);
        if (tag == null) {
            return def;
        }
        return tag.getValue();
    }

    public byte[] getByteArrayOrDefault(String key, byte[] def) {
        ByteArrayTag tag = this.getByteArrayTag(key);
        if (tag == null) {
            return def;
        }
        return tag.getValue();
    }

    public int[] getIntArrayOrDefault(String key, int[] def) {
        IntArrayTag tag = this.getIntArrayTag(key);
        if (tag == null) {
            return def;
        }
        return tag.getValue();
    }

    public long[] getLongArrayOrDefault(String key, long[] def) {
        LongArrayTag tag = this.getLongArrayTag(key);
        if (tag == null) {
            return def;
        }
        return tag.getValue();
    }

    public CompoundTag getCompoundOrDefault(String key, CompoundTag def) {
        CompoundTag tag = this.getCompoundTag(key);
        if (tag == null) {
            return def;
        }
        return tag;
    }

    public ListTag getListOrDefault(String key, ListTag def) {
        ListTag tag = this.getListTag(key);
        if (tag == null) {
            return def;
        }
        return tag;
    }

    public boolean getBooleanOrDefault(String key, boolean b) {
        return this.getByteOrDefault(key, (byte)(b ? 1 : 0)) != 0;
    }

    public NumberTag getNumberTag(String key) {
        if (this.containsNumber(key)) {
            return (NumberTag)this.value.get(key);
        }
        return null;
    }

    public ByteTag getByteTag(String key) {
        if (this.contains(key, Tag.Type.BYTE)) {
            return (ByteTag)this.value.get(key);
        }
        return null;
    }

    public ShortTag getShortTag(String key) {
        if (this.contains(key, Tag.Type.SHORT)) {
            return (ShortTag)this.value.get(key);
        }
        return null;
    }

    public IntTag getIntTag(String key) {
        if (this.contains(key, Tag.Type.INT)) {
            return (IntTag)this.value.get(key);
        }
        return null;
    }

    public LongTag getLongTag(String key) {
        if (this.contains(key, Tag.Type.LONG)) {
            return (LongTag)this.value.get(key);
        }
        return null;
    }

    public FloatTag getFloatTag(String key) {
        if (this.contains(key, Tag.Type.FLOAT)) {
            return (FloatTag)this.value.get(key);
        }
        return null;
    }

    public DoubleTag getDoubleTag(String key) {
        if (this.contains(key, Tag.Type.DOUBLE)) {
            return (DoubleTag)this.value.get(key);
        }
        return null;
    }

    public StringTag getStringTag(String key) {
        if (this.contains(key, Tag.Type.STRING)) {
            return (StringTag)this.value.get(key);
        }
        return null;
    }

    public ByteArrayTag getByteArrayTag(String key) {
        if (this.contains(key, Tag.Type.BYTE_ARRAY)) {
            return (ByteArrayTag)this.value.get(key);
        }
        return null;
    }

    public IntArrayTag getIntArrayTag(String key) {
        if (this.contains(key, Tag.Type.INT_ARRAY)) {
            return (IntArrayTag)this.value.get(key);
        }
        return null;
    }

    public LongArrayTag getLongArrayTag(String key) {
        if (this.contains(key, Tag.Type.LONG_ARRAY)) {
            return (LongArrayTag)this.value.get(key);
        }
        return null;
    }

    public ListTag getListTag(String key) {
        if (this.contains(key, Tag.Type.LIST)) {
            return (ListTag)this.value.get(key);
        }
        return null;
    }

    public CompoundTag getCompoundTag(String key) {
        if (this.contains(key, Tag.Type.COMPOUND)) {
            return (CompoundTag)this.value.get(key);
        }
        return null;
    }

    public boolean contains(String key, Tag.Type type) {
        Tag tag = this.value.get(key);
        return tag != null && tag.getType() == type;
    }

    public boolean containsNumber(String key) {
        Tag tag = this.value.get(key);
        return tag != null && tag.getType().isNumber;
    }

    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    @Override
    @Deprecated
    public boolean containsKey(Object key) {
        return this.containsKey((String)key);
    }

    public boolean containsValue(Tag value) {
        return this.value.containsValue(value);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object value) {
        return this.containsValue((Tag)value);
    }

    public boolean partOf(CompoundTag other) {
        if (other == null) {
            return false;
        }
        block4: for (Map.Entry<String, Tag> entry : this) {
            if (!other.containsKey(entry.getKey())) {
                return false;
            }
            Tag tag = entry.getValue();
            switch (tag.getType()) {
                case COMPOUND: {
                    Tag otherTag = other.getCompoundTag(entry.getKey());
                    if (((CompoundTag)tag).partOf((CompoundTag)otherTag)) continue block4;
                    return false;
                }
                case LIST: {
                    Tag otherTag = other.getListTag(entry.getKey());
                    if (((ListTag)tag).partOf((ListTag)otherTag)) continue block4;
                    return false;
                }
                default: {
                    return tag.equals(other.get(entry.getKey()));
                }
            }
        }
        return true;
    }

    public Tag remove(String key) {
        return this.value.remove(key);
    }

    @Override
    @Deprecated
    public Tag remove(Object key) {
        return this.remove((String)key);
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<String, Tag>> iterator() {
        return this.value.entrySet().iterator();
    }

    @Override
    public Set<String> keySet() {
        return this.value.keySet();
    }

    @Override
    public Collection<Tag> values() {
        return this.value.values();
    }

    @Override
    public Set<Map.Entry<String, Tag>> entrySet() {
        return this.value.entrySet();
    }
}

