/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.querz.nbt.NumberTag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class DoubleTag
extends NumberTag {
    private final double value;
    public static final DoubleTag ZERO = new DoubleTag(0.0);
    public static final TagReader<DoubleTag> READER = new TagReader<DoubleTag>(){

        @Override
        public DoubleTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            return DoubleTag.valueOf(in.readDouble());
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            return visitor.visit(in.readDouble());
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(8);
        }
    };

    private DoubleTag(double d) {
        this.value = d;
    }

    public static DoubleTag valueOf(double d) {
        return d == 0.0 ? ZERO : new DoubleTag(d);
    }

    @Override
    public byte asByte() {
        return (byte)(this.floor(this.value) & 0xFF);
    }

    @Override
    public short asShort() {
        return (short)(this.floor(this.value) & 0xFFFF);
    }

    @Override
    public int asInt() {
        return this.floor(this.value);
    }

    @Override
    public long asLong() {
        return (long)Math.floor(this.value);
    }

    @Override
    public float asFloat() {
        return (float)this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public Number asNumber() {
        return this.value;
    }

    private int floor(double d) {
        int o = (int)d;
        return d < (double)o ? o - 1 : o;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public DoubleTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DoubleTag && this.value == ((DoubleTag)other).value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    @Override
    public String toString() {
        return this.value + "d";
    }
}

